/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class KEWXmlDataLoader {
    public static void loadXmlResource(String resource) throws Exception {
        Resource res = new DefaultResourceLoader().getResource(resource);
        InputStream xmlFile = res.getInputStream();
        if (xmlFile == null) {
            throw new ConfigurationException("Didn't find resource " + resource);
        }
        try {
            KEWXmlDataLoader.loadXmlStream(xmlFile);
        }
        finally {
            xmlFile.close();
        }
    }

    public static void loadXmlClassLoaderResource(Class clazz, String path) throws Exception {
        if (path.indexOf(47) < 0) {
            KEWXmlDataLoader.loadXmlPackageResource(clazz, path);
        } else {
            KEWXmlDataLoader.loadXmlClassLoaderResource(clazz.getClassLoader(), path);
        }
    }

    public static void loadXmlPackageResource(Class clazz, String path) throws Exception {
        InputStream xmlFile = clazz.getResourceAsStream(path);
        if (xmlFile == null) {
            throw new WorkflowRuntimeException("Didn't find resource " + path);
        }
        try {
            KEWXmlDataLoader.loadXmlStream(xmlFile);
        }
        finally {
            xmlFile.close();
        }
    }

    public static void loadXmlClassLoaderResource(ClassLoader classloader, String path) throws Exception {
        InputStream xmlFile = classloader.getResourceAsStream(path);
        if (xmlFile == null) {
            throw new WorkflowRuntimeException("Didn't find resource " + path);
        }
        try {
            KEWXmlDataLoader.loadXmlStream(xmlFile);
        }
        finally {
            xmlFile.close();
        }
    }

    public static void loadXmlFile(String fileName) throws Exception {
        try (FileInputStream fis = new FileInputStream(fileName);){
            KEWXmlDataLoader.loadXmlStream(fis);
        }
    }

    public static void loadXmlStream(InputStream xmlStream) throws Exception {
        ArrayList<FileXmlDocCollection> xmlFiles = new ArrayList<FileXmlDocCollection>();
        FileXmlDocCollection docCollection = KEWXmlDataLoader.getFileXmlDocCollection(xmlStream, "UnitTestTemp");
        xmlFiles.add(docCollection);
        CoreApiServiceLocator.getXmlIngesterService().ingest(xmlFiles);
        for (XmlDoc doc : docCollection.getXmlDocs()) {
            if (doc.isProcessed()) continue;
            throw new RuntimeException("Failed to ingest xml doc: " + doc.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileXmlDocCollection getFileXmlDocCollection(InputStream stream, String tempFileName) throws IOException {
        if (stream == null) {
            throw new RuntimeException("Stream is null!");
        }
        File temp = File.createTempFile(tempFileName, ".xml");
        temp.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(temp);){
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        return new FileXmlDocCollection(temp);
    }
}

