/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SqlBuilder;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_DOC_HDR_EXT_DT_T")
@NamedQueries(value={@NamedQuery(name="SearchableAttributeDateTimeValue.FindByDocumentId", query="select s from SearchableAttributeDateTimeValue as s where s.documentId = :documentId"), @NamedQuery(name="SearchableAttributeDateTimeValue.FindByKey", query="select s from SearchableAttributeDateTimeValue as s where s.documentId = :documentId and s.searchableAttributeKey = :searchableAttributeKey")})
public class SearchableAttributeDateTimeValue
implements SearchableAttributeValue,
Serializable {
    private static final Logger LOG = Logger.getLogger(SearchableAttributeDateTimeValue.class);
    private static final long serialVersionUID = 3045621112943214772L;
    private static final String ATTRIBUTE_DATABASE_TABLE_NAME = "KREW_DOC_HDR_EXT_DT_T";
    private static final boolean DEFAULT_WILDCARD_ALLOWANCE_POLICY = false;
    private static final boolean ALLOWS_RANGE_SEARCH = true;
    private static final boolean ALLOWS_CASE_INSENSITIVE_SEARCH = false;
    private static final String ATTRIBUTE_XML_REPRESENTATION = "datetime";
    @Id
    @GeneratedValue(generator="KREW_SRCH_ATTR_S")
    @GenericGenerator(name="KREW_SRCH_ATTR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_SRCH_ATTR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_HDR_EXT_DT_ID")
    private String searchableAttributeValueId;
    @Column(name="KEY_CD")
    private String searchableAttributeKey;
    @Column(name="VAL")
    private Timestamp searchableAttributeValue;
    @Transient
    protected String ojbConcreteClass = this.getClass().getName();
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private DocumentRouteHeaderValue routeHeader;

    @Override
    public void setupAttributeValue(String value) {
        this.setSearchableAttributeValue(this.convertStringToTimestamp(value));
    }

    private Timestamp convertStringToTimestamp(String value) {
        Timestamp t;
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        try {
            t = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(value);
        }
        catch (ParseException e) {
            t = null;
        }
        if (t == null) {
            String errorMsg = "Error converting timestamp value '" + value + "' to valid timestamp object.";
            LOG.error((Object)("setupAttributeValue() " + errorMsg));
            throw new RuntimeException(errorMsg);
        }
        return t;
    }

    @Override
    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException {
        Calendar c = Calendar.getInstance();
        c.clear(10);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        this.setSearchableAttributeValue(resultSet.getTimestamp(columnName, c));
    }

    @Override
    public String getSearchableAttributeDisplayValue() {
        return this.formatAttributeValue(null);
    }

    private String formatAttributeValue(String formatPattern) {
        DateFormat df = this.getDateFormatToUse(formatPattern);
        return df.format(new Date(this.getSearchableAttributeValue().getTime()));
    }

    private DateFormat getDateFormatToUse(String parameterFormatPattern) {
        if (StringUtils.isNotBlank((String)parameterFormatPattern)) {
            return new SimpleDateFormat(parameterFormatPattern);
        }
        return RiceConstants.getDefaultDateFormat();
    }

    @Override
    public String getAttributeDataType() {
        return ATTRIBUTE_XML_REPRESENTATION;
    }

    @Override
    public String getAttributeTableName() {
        return ATTRIBUTE_DATABASE_TABLE_NAME;
    }

    @Override
    public boolean allowsWildcards() {
        return false;
    }

    @Override
    public boolean allowsCaseInsensitivity() {
        return false;
    }

    @Override
    public boolean allowsRangeSearches() {
        return true;
    }

    @Override
    public boolean isPassesDefaultValidation(String valueEntered) {
        return new SqlBuilder().isValidDate(valueEntered);
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue) {
        if (this.allowsRangeSearches()) {
            Timestamp lowerTime = this.convertStringToTimestamp(lowerValue);
            Timestamp upperTime = this.convertStringToTimestamp(upperValue);
            if (lowerTime != null && upperTime != null) {
                return lowerTime.compareTo(upperTime) <= 0;
            }
            return true;
        }
        return null;
    }

    @Override
    public String getOjbConcreteClass() {
        return this.ojbConcreteClass;
    }

    @Override
    public void setOjbConcreteClass(String ojbConcreteClass) {
        this.ojbConcreteClass = ojbConcreteClass;
    }

    @Override
    public DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    @Override
    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @Override
    public String getSearchableAttributeKey() {
        return this.searchableAttributeKey;
    }

    @Override
    public void setSearchableAttributeKey(String searchableAttributeKey) {
        this.searchableAttributeKey = searchableAttributeKey;
    }

    @Override
    public Timestamp getSearchableAttributeValue() {
        return this.searchableAttributeValue;
    }

    public void setSearchableAttributeValue(Timestamp searchableAttributeValue) {
        this.searchableAttributeValue = searchableAttributeValue;
    }

    @Override
    public String getSearchableAttributeValueId() {
        return this.searchableAttributeValueId;
    }

    @Override
    public void setSearchableAttributeValueId(String searchableAttributeValueId) {
        this.searchableAttributeValueId = searchableAttributeValueId;
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public DocumentAttributeDateTime toDocumentAttribute() {
        DateTime dateTime = null;
        if (this.getSearchableAttributeValue() != null) {
            dateTime = new DateTime(this.getSearchableAttributeValue().getTime());
        }
        return DocumentAttributeFactory.createDateTimeAttribute((String)this.getSearchableAttributeKey(), dateTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + (this.searchableAttributeKey == null ? 0 : this.searchableAttributeKey.hashCode());
        result = 31 * result + (this.searchableAttributeValue == null ? 0 : this.searchableAttributeValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchableAttributeDateTimeValue other = (SearchableAttributeDateTimeValue)obj;
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.searchableAttributeKey == null ? other.searchableAttributeKey != null : !this.searchableAttributeKey.equals(other.searchableAttributeKey)) {
            return false;
        }
        return !(this.searchableAttributeValue == null ? other.searchableAttributeValue != null : !this.searchableAttributeValue.equals(other.searchableAttributeValue));
    }
}

