/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeInteger;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_DOC_HDR_EXT_LONG_T")
@NamedQueries(value={@NamedQuery(name="SearchableAttributeLongValue.FindByDocumentId", query="select s from SearchableAttributeLongValue as s where s.documentId = :documentId"), @NamedQuery(name="SearchableAttributeLongValue.FindByKey", query="select s from SearchableAttributeLongValue as s where s.documentId = :documentId and s.searchableAttributeKey = :searchableAttributeKey")})
public class SearchableAttributeLongValue
implements SearchableAttributeValue,
Serializable {
    private static final long serialVersionUID = 5786144436732198346L;
    private static final String ATTRIBUTE_DATABASE_TABLE_NAME = "KREW_DOC_HDR_EXT_LONG_T";
    private static final boolean DEFAULT_WILDCARD_ALLOWANCE_POLICY = false;
    private static final boolean ALLOWS_RANGE_SEARCH = true;
    private static final boolean ALLOWS_CASE_INSENSITIVE_SEARCH = false;
    private static final String DEFAULT_VALIDATION_REGEX_EXPRESSION = "^-?[0-9]+$";
    private static final String ATTRIBUTE_XML_REPRESENTATION = "long";
    private static final String DEFAULT_FORMAT_PATTERN = "#";
    @Id
    @GeneratedValue(generator="KREW_SRCH_ATTR_S")
    @GenericGenerator(name="KREW_SRCH_ATTR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_SRCH_ATTR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_HDR_EXT_LONG_ID")
    private String searchableAttributeValueId;
    @Column(name="KEY_CD")
    private String searchableAttributeKey;
    @Column(name="VAL")
    private Long searchableAttributeValue;
    @Transient
    protected String ojbConcreteClass = this.getClass().getName();
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private DocumentRouteHeaderValue routeHeader;

    @Override
    public void setupAttributeValue(String value) {
        this.setSearchableAttributeValue(this.convertStringToLong(value));
    }

    private Long convertStringToLong(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value.trim());
    }

    @Override
    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException {
        this.setSearchableAttributeValue(resultSet.getLong(columnName));
    }

    @Override
    public String getSearchableAttributeDisplayValue() {
        NumberFormat format = DecimalFormat.getInstance();
        ((DecimalFormat)format).applyPattern(DEFAULT_FORMAT_PATTERN);
        return format.format(this.getSearchableAttributeValue());
    }

    @Override
    public String getAttributeDataType() {
        return ATTRIBUTE_XML_REPRESENTATION;
    }

    @Override
    public String getAttributeTableName() {
        return ATTRIBUTE_DATABASE_TABLE_NAME;
    }

    @Override
    public boolean allowsWildcards() {
        return false;
    }

    @Override
    public boolean allowsCaseInsensitivity() {
        return false;
    }

    @Override
    public boolean allowsRangeSearches() {
        return true;
    }

    @Override
    public boolean isPassesDefaultValidation(String valueEntered) {
        List<String> l;
        boolean bRet = true;
        boolean bSplit = false;
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.BETWEEN.op())) {
            l = Arrays.asList(valueEntered.split("\\.\\."));
            for (String value : l) {
                bSplit = true;
                if (this.isPassesDefaultValidation(value)) continue;
                bRet = false;
            }
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.OR.op())) {
            l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.OR.op()));
            for (String value : l) {
                bSplit = true;
                if (this.isPassesDefaultValidation(value)) continue;
                bRet = false;
            }
        }
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.AND.op())) {
            l = Arrays.asList(StringUtils.split((String)valueEntered, (String)SearchOperator.AND.op()));
            for (String value : l) {
                bSplit = true;
                if (this.isPassesDefaultValidation(value)) continue;
                bRet = false;
            }
        }
        if (bSplit) {
            return bRet;
        }
        Pattern pattern = Pattern.compile(DEFAULT_VALIDATION_REGEX_EXPRESSION);
        Matcher matcher = pattern.matcher(SQLUtils.cleanNumericOfValidOperators((String)valueEntered).trim());
        if (!matcher.matches()) {
            bRet = false;
        }
        return bRet;
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue) {
        if (this.allowsRangeSearches()) {
            Long lower = this.convertStringToLong(lowerValue);
            Long upper = this.convertStringToLong(upperValue);
            if (lower != null && upper != null) {
                return lower.compareTo(upper) <= 0;
            }
            return true;
        }
        return null;
    }

    @Override
    public String getOjbConcreteClass() {
        return this.ojbConcreteClass;
    }

    @Override
    public void setOjbConcreteClass(String ojbConcreteClass) {
        this.ojbConcreteClass = ojbConcreteClass;
    }

    @Override
    public DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    @Override
    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @Override
    public String getSearchableAttributeKey() {
        return this.searchableAttributeKey;
    }

    @Override
    public void setSearchableAttributeKey(String searchableAttributeKey) {
        this.searchableAttributeKey = searchableAttributeKey;
    }

    @Override
    public Long getSearchableAttributeValue() {
        return this.searchableAttributeValue;
    }

    public void setSearchableAttributeValue(Long searchableAttributeValue) {
        this.searchableAttributeValue = searchableAttributeValue;
    }

    @Override
    public String getSearchableAttributeValueId() {
        return this.searchableAttributeValueId;
    }

    @Override
    public void setSearchableAttributeValueId(String searchableAttributeValueId) {
        this.searchableAttributeValueId = searchableAttributeValueId;
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public DocumentAttributeInteger toDocumentAttribute() {
        BigInteger integer = null;
        if (this.getSearchableAttributeValue() != null) {
            integer = BigInteger.valueOf(this.getSearchableAttributeValue());
        }
        return DocumentAttributeFactory.createIntegerAttribute((String)this.getSearchableAttributeKey(), integer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + (this.searchableAttributeKey == null ? 0 : this.searchableAttributeKey.hashCode());
        result = 31 * result + (this.searchableAttributeValue == null ? 0 : this.searchableAttributeValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchableAttributeLongValue other = (SearchableAttributeLongValue)obj;
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.searchableAttributeKey == null ? other.searchableAttributeKey != null : !this.searchableAttributeKey.equals(other.searchableAttributeKey)) {
            return false;
        }
        return !(this.searchableAttributeValue == null ? other.searchableAttributeValue != null : !this.searchableAttributeValue.equals(other.searchableAttributeValue));
    }
}

