/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttribute;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_DOC_TYP_ATTR_T")
public class DocumentTypeAttributeBo
implements DocumentTypeAttributeContract,
Comparable,
Serializable {
    private static final long serialVersionUID = -4429421648373903566L;
    @Id
    @GeneratedValue(generator="KREW_DOC_TYP_ATTR_S")
    @GenericGenerator(name="KREW_DOC_TYP_ATTR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_DOC_TYP_ATTR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_TYP_ATTRIB_ID")
    private String id;
    @Column(name="RULE_ATTR_ID", insertable=false, updatable=false)
    private String ruleAttributeId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ATTR_ID")
    private RuleAttribute ruleAttribute;
    @Column(name="DOC_TYP_ID", insertable=false, updatable=false)
    private String documentTypeId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DOC_TYP_ID")
    private DocumentType documentType;
    @Column(name="ORD_INDX")
    private int orderIndex;
    @Transient
    private Integer lockVerNbr;

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setRuleAttributeId(String ruleAttributeId) {
        this.ruleAttributeId = ruleAttributeId;
        this.ruleAttribute = ruleAttributeId == null ? null : RuleAttribute.from(KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(ruleAttributeId));
    }

    public String getRuleAttributeId() {
        return this.ruleAttributeId;
    }

    public void setRuleAttribute(RuleAttribute ruleAttribute) {
        this.ruleAttribute = ruleAttribute;
    }

    public RuleAttribute getRuleAttribute() {
        return this.ruleAttribute;
    }

    public int compareTo(Object o) {
        if (o instanceof DocumentTypeAttributeBo) {
            return this.getRuleAttribute().getName().compareTo(((DocumentTypeAttributeBo)o).getRuleAttribute().getName());
        }
        return 0;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public void setOrderIndex(int orderIndex) {
        this.orderIndex = orderIndex;
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public static DocumentTypeAttribute to(DocumentTypeAttributeBo documentTypeAttributeBo) {
        if (documentTypeAttributeBo == null) {
            return null;
        }
        DocumentTypeAttribute.Builder builder = DocumentTypeAttribute.Builder.create((DocumentTypeAttributeContract)documentTypeAttributeBo);
        return builder.build();
    }

    public static DocumentTypeAttributeBo from(DocumentTypeAttribute dta) {
        DocumentTypeAttributeBo bo = new DocumentTypeAttributeBo();
        bo.setDocumentTypeId(dta.getDocumentTypeId());
        if (dta.getRuleAttribute() != null) {
            bo.setRuleAttributeId(dta.getRuleAttribute().getId());
            bo.setRuleAttribute(RuleAttribute.from(dta.getRuleAttribute()));
        }
        bo.setId(dta.getId());
        bo.setOrderIndex(dta.getOrderIndex());
        return bo;
    }
}

