/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ReportQueryRsIterator;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.springmodules.orm.ojb.OjbFactoryUtils;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class DocumentTypeDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements DocumentTypeDAO {
    public static final Logger LOG = Logger.getLogger(DocumentTypeDAOOjbImpl.class);

    @Override
    public void delete(DocumentType documentType) {
        this.getPersistenceBrokerTemplate().delete((Object)documentType);
    }

    @Override
    public DocumentType findById(String docTypeId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentTypeId", (Object)docTypeId);
        return (DocumentType)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(DocumentType.class, crit));
    }

    @Override
    public DocumentType findByName(String name) {
        return this.findByName(name, true);
    }

    @Override
    public DocumentType findByName(String name, boolean caseSensitive) {
        Criteria crit = new Criteria();
        if (!caseSensitive) {
            if (name.contains("*") || name.contains("%")) {
                name.replace("*", "%");
                crit.addLike((Object)"UPPER(name)", (Object)name.trim().toUpperCase());
            } else {
                crit.addEqualTo("UPPER(name)", (Object)name.trim().toUpperCase());
            }
        } else if (name.contains("*")) {
            name.replace("*", "%");
            crit.addLike((Object)"name", (Object)name.trim().toUpperCase());
        } else {
            crit.addEqualTo("name", (Object)name);
        }
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        DocumentType docType = (DocumentType)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(DocumentType.class, crit));
        return docType;
    }

    @Override
    public Integer getMaxVersionNumber(String docTypeName) {
        return this.getMostRecentDocType(docTypeName).getVersion();
    }

    @Override
    public List<String> getChildDocumentTypeIds(String parentDocumentTypeId) {
        ArrayList<String> childrenIds = new ArrayList<String>();
        PersistenceBroker broker = this.getPersistenceBroker(false);
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = broker.serviceConnectionManager().getConnection();
            st = conn.prepareStatement("select DOC_TYP_ID from KREW_DOC_TYP_T where CUR_IND = 1 and PARNT_ID = ?");
            st.setString(1, parentDocumentTypeId);
            rs = st.executeQuery();
            while (rs.next()) {
                childrenIds.add(rs.getString("DOC_TYP_ID"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error occured fetching children document type ids for document type " + parentDocumentTypeId), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                st.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to close Statement", (Throwable)e);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to close Resultset", (Throwable)e);
            }
            if (broker != null) {
                try {
                    OjbFactoryUtils.releasePersistenceBroker((PersistenceBroker)broker, (PBKey)this.getPersistenceBrokerTemplate().getPbKey());
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed closing connection: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return childrenIds;
    }

    protected DocumentType getMostRecentDocType(String docTypeName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)docTypeName);
        QueryByCriteria query = new QueryByCriteria(DocumentType.class, crit);
        query.addOrderByDescending("version");
        Iterator docTypes = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).iterator();
        if (docTypes.hasNext()) {
            return (DocumentType)docTypes.next();
        }
        return null;
    }

    @Override
    public void save(DocumentType documentType) {
        this.getPersistenceBrokerTemplate().store((Object)documentType);
    }

    @Override
    public List findByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(DocumentType.class, crit));
    }

    @Override
    public Collection<DocumentType> find(DocumentType documentType, DocumentType docTypeParent, boolean climbHierarchy) {
        DocumentType searchDocumentType;
        LOG.debug((Object)("documentType: " + documentType));
        LOG.debug((Object)("docTypeParent: " + docTypeParent));
        LOG.debug((Object)("climbHierarchy: " + climbHierarchy));
        Criteria crit = new Criteria();
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getLabel())) {
            crit.addLike((Object)"UPPER(label)", (Object)documentType.getLabel().trim().toUpperCase());
        }
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getName())) {
            String docTypeName = documentType.getName();
            crit.addLike((Object)"UPPER(name)", (Object)("%" + docTypeName.trim() + "%").toUpperCase());
        }
        if (documentType != null && documentType.getActive() != null) {
            crit.addEqualTo("active", (Object)documentType.getActive());
        }
        if (documentType != null && documentType.getDocumentTypeId() != null) {
            crit.addEqualTo("documentTypeId", (Object)documentType.getDocumentTypeId());
        }
        if (documentType != null && documentType.getActualApplicationId() != null) {
            crit.addEqualTo("actualApplicationIde", (Object)documentType.getActualApplicationId());
        }
        if (docTypeParent != null) {
            if (!"".equals(docTypeParent.getName()) && docTypeParent.getName() != null) {
                Criteria parentCrit = new Criteria();
                this.addParentIdOrCriteria(docTypeParent.getDocumentTypeId(), parentCrit);
                if (climbHierarchy) {
                    this.assembleChildrenCriteria(docTypeParent.getChildrenDocTypes(), parentCrit);
                }
                parentCrit.addEqualTo("currentInd", (Object)Boolean.TRUE);
                crit.addAndCriteria(parentCrit);
            }
        } else if (documentType != null && !StringUtils.isEmpty((String)documentType.getName()) && (searchDocumentType = this.findByName(documentType.getName())) != null && climbHierarchy) {
            LOG.debug((Object)("searchDocumentType: " + searchDocumentType));
            Criteria criteria = new Criteria();
            this.addParentIdOrCriteria(searchDocumentType.getDocumentTypeId(), criteria);
            this.assembleChildrenCriteria(searchDocumentType.getChildrenDocTypes(), criteria);
            criteria.addEqualTo("currentInd", (Object)Boolean.TRUE);
            crit.addOrCriteria(criteria);
        }
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(DocumentType.class, crit));
    }

    private void addParentIdOrCriteria(String parentId, Criteria mainCriteria) {
        Criteria parentCriteria = new Criteria();
        parentCriteria.addEqualTo("docTypeParentId", (Object)parentId);
        mainCriteria.addOrCriteria(parentCriteria);
    }

    private void assembleChildrenCriteria(Collection childrenDocTypes, Criteria crit) {
        if (childrenDocTypes != null) {
            for (DocumentType child : childrenDocTypes) {
                this.addParentIdOrCriteria(child.getDocumentTypeId(), crit);
                this.assembleChildrenCriteria(child.getChildrenDocTypes(), crit);
            }
        }
    }

    @Override
    public List<DocumentType> findAllCurrentRootDocuments() {
        Criteria crit = new Criteria();
        crit.addIsNull("docTypeParentId");
        return this.findAllCurrent(crit);
    }

    @Override
    public List<DocumentType> findAllCurrent() {
        return this.findAllCurrent(new Criteria());
    }

    @Override
    public List<DocumentType> findAllCurrentByName(String name) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)name);
        return this.findAllCurrent(crit);
    }

    @Override
    public List<DocumentType> findPreviousInstances(String documentTypeName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)documentTypeName);
        crit.addEqualTo("currentInd", (Object)Boolean.FALSE);
        return this.findAll(crit);
    }

    private List<DocumentType> findAllCurrent(Criteria crit) {
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        return this.findAll(crit);
    }

    private List<DocumentType> findAll(Criteria crit) {
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(DocumentType.class, crit));
    }

    @Override
    public List findDocumentTypeAttributes(RuleAttribute ruleAttribute) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleAttributeId", (Object)ruleAttribute.getId());
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(DocumentTypeAttributeBo.class, crit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findDocumentTypeIdByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentRouteHeaderValue.class, (Criteria)crit);
        query.setAttributes(new String[]{"documentTypeId"});
        ReportQueryRsIterator iter = (ReportQueryRsIterator)this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        try {
            if (iter.hasNext()) {
                Object[] row = (Object[])iter.next();
                String string = (String)row[0];
                return string;
            }
        }
        finally {
            iter.releaseDbResources();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findDocumentTypeIdByName(String documentTypeName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)documentTypeName);
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentType.class, (Criteria)crit);
        query.setAttributes(new String[]{"documentTypeId"});
        ReportQueryRsIterator iter = (ReportQueryRsIterator)this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        try {
            if (iter.hasNext()) {
                Object[] row = (Object[])iter.next();
                String string = (String)row[0];
                return string;
            }
        }
        finally {
            iter.releaseDbResources();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findDocumentTypeNameById(String documentTypeId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentTypeId", (Object)documentTypeId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentType.class, (Criteria)crit);
        query.setAttributes(new String[]{"name"});
        ReportQueryRsIterator iter = (ReportQueryRsIterator)this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        try {
            if (iter.hasNext()) {
                Object[] row = (Object[])iter.next();
                String string = (String)row[0];
                return string;
            }
        }
        finally {
            iter.releaseDbResources();
        }
        return null;
    }
}

