/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actions.BlanketApproveAction;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.OrchestrationConfig;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class DocumentOrchestrationQueueImpl
implements DocumentOrchestrationQueue {
    private static final Logger LOG = Logger.getLogger(DocumentOrchestrationQueueImpl.class);

    public void orchestrateDocument(String documentId, String principalId, OrchestrationConfig orchestrationConfig, DocumentProcessingOptions documentProcessingOptions) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is null or blank");
        }
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null");
        }
        if (orchestrationConfig == null) {
            throw new RiceIllegalArgumentException("orchestrationConfig is null");
        }
        if (documentProcessingOptions == null) {
            documentProcessingOptions = DocumentProcessingOptions.createDefault();
        }
        LOG.info((Object)("Performing document orchestration on documentId=" + documentId));
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId, true);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        ActionTakenValue actionTaken = KEWServiceLocator.getActionTakenService().findByActionTakenId(orchestrationConfig.getActionTakenId());
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        BlanketApproveAction blanketApprove = new BlanketApproveAction(document, (PrincipalContract)principal, "", orchestrationConfig.getNodeNames());
        try {
            blanketApprove.performDeferredBlanketApproveWork(actionTaken, documentProcessingOptions);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WorkflowRuntimeException((Throwable)e);
        }
        if (documentProcessingOptions.isIndexSearchAttributes()) {
            DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)document.getDocumentType().getApplicationId());
            queue.indexDocument(documentId);
        }
        LOG.info((Object)("Document orchestration complete against documentId=" + documentId));
    }
}

