/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.actionlist;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemCustomization;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationHandlerService;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationMediator;
import org.kuali.rice.kew.rule.bo.RuleAttribute;

public class ActionListCustomizationMediatorImpl
implements ActionListCustomizationMediator {
    private static final Logger LOG = Logger.getLogger(ActionListCustomizationMediatorImpl.class);
    private DocumentTypeService documentTypeService;
    private ActionListCustomizationHandlerServiceChooser actionListCustomizationHandlerServiceChooser = new ActionListCustomizationHandlerServiceChooser();

    public Map<String, ActionItemCustomization> getActionListCustomizations(String principalId, List<ActionItem> actionItems) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("invalid principalId: " + principalId);
        }
        if (actionItems == null) {
            actionItems = Collections.emptyList();
        }
        HashMap<String, ActionItemCustomization> results = new HashMap<String, ActionItemCustomization>();
        ArrayListMultimap itemsByApplicationId = ArrayListMultimap.create();
        for (ActionItem actionItem : actionItems) {
            DocumentType docType = this.getDocumentTypeService().findByName(actionItem.getDocName());
            if (docType == null) {
                LOG.error((Object)String.format("Action item %s has an invalid document type name of %s", actionItem.getId(), actionItem.getDocName()));
                itemsByApplicationId.put(null, (Object)actionItem);
                continue;
            }
            itemsByApplicationId.put((Object)this.getActionListCustomizationApplicationId(docType), (Object)actionItem);
        }
        for (String string : itemsByApplicationId.keySet()) {
            List customizations;
            ActionListCustomizationHandlerService actionListCustomizationHandler = this.getActionListCustomizationHandlerServiceChooser().getByApplicationId(string);
            if (actionListCustomizationHandler == null) {
                actionListCustomizationHandler = this.getActionListCustomizationHandlerServiceChooser().getByApplicationId(null);
            }
            if ((customizations = actionListCustomizationHandler.customizeActionList(principalId, itemsByApplicationId.get((Object)string))) == null) continue;
            for (ActionItemCustomization customization : customizations) {
                results.put(customization.getActionItemId(), customization);
            }
        }
        return results;
    }

    private String getActionListCustomizationApplicationId(DocumentType docType) {
        String applicationId = null;
        RuleAttribute ruleAttribute = docType.getCustomActionListRuleAttribute();
        if (ruleAttribute != null) {
            applicationId = ruleAttribute.getApplicationId();
        }
        return applicationId;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public ActionListCustomizationHandlerServiceChooser getActionListCustomizationHandlerServiceChooser() {
        return this.actionListCustomizationHandlerServiceChooser;
    }

    public void setActionListCustomizationHandlerServiceChooser(ActionListCustomizationHandlerServiceChooser actionListCustomizationHandlerServiceChooser) {
        this.actionListCustomizationHandlerServiceChooser = actionListCustomizationHandlerServiceChooser;
    }

    public static class ActionListCustomizationHandlerServiceChooser {
        public ActionListCustomizationHandlerService getByApplicationId(String applicationId) {
            return KewFrameworkServiceLocator.getActionListCustomizationHandlerService((String)applicationId);
        }
    }
}

