/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail.service.impl;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.feedback.web.FeedbackForm;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.mail.EmailStyleHelper;
import org.kuali.rice.kew.mail.service.impl.BaseEmailContentServiceImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.UserUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.core.io.DefaultResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StyleableEmailContentServiceImpl
extends BaseEmailContentServiceImpl {
    private static final Logger LOG = Logger.getLogger(StyleableEmailContentServiceImpl.class);
    protected final String DEFAULT_EMAIL_STYLESHEET_RESOURCE_LOC = "defaultEmailStyle.xsl";
    protected StyleService styleService;
    protected EmailStyleHelper styleHelper = new EmailStyleHelper();
    protected String globalEmailStyleSheet = "kew.email.style";
    protected RouteHeaderService routeHeaderService;

    public void setStyleService(StyleService styleService) {
        this.styleService = styleService;
    }

    public void setGlobalEmailStyleSheet(String globalEmailStyleSheet) {
        this.globalEmailStyleSheet = globalEmailStyleSheet;
    }

    protected static DocumentBuilder getDocumentBuilder(boolean coalesce) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setCoalescing(coalesce);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String message = "Error constructing document builder";
            LOG.error((Object)message, (Throwable)e);
            throw new WorkflowRuntimeException(message, (Throwable)e);
        }
    }

    protected static void addObjectXML(Document doc, Object o, Node node, String name) throws Exception {
        Element element = XmlHelper.propertiesToXml((Document)doc, (Object)o, (String)name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)XmlJotter.jotNode((Node)element));
        }
        if (node == null) {
            node = doc;
        }
        node.appendChild(element);
    }

    protected static void addTextElement(Document doc, Element baseElement, String elementName, Object elementData) {
        Element element = doc.createElement(elementName);
        String dataValue = "";
        if (elementData != null) {
            dataValue = elementData.toString();
        }
        element.appendChild(doc.createTextNode(dataValue));
        baseElement.appendChild(element);
    }

    protected static void addCDataElement(Document doc, Element baseElement, String elementName, Object elementData) {
        Element element = doc.createElement(elementName);
        String dataValue = "";
        if (elementData != null) {
            dataValue = elementData.toString();
        }
        element.appendChild(doc.createCDATASection(dataValue));
        baseElement.appendChild(element);
    }

    protected static void addTimestampElement(Document doc, Element baseElement, String elementName, Date elementData) {
        StyleableEmailContentServiceImpl.addTextElement(doc, baseElement, elementName, RiceConstants.getDefaultDateFormat().format(elementData));
    }

    protected static void addDelegatorElement(Document doc, Element baseElement, ActionItem actionItem) {
        Element delegatorElement = doc.createElement("delegator");
        if (actionItem.getDelegatorPrincipalId() != null && actionItem.getDelegatorPrincipalId() != null) {
            baseElement.appendChild(delegatorElement);
            return;
        }
        String delegatorType = "";
        String delegatorId = "";
        String delegatorDisplayValue = "";
        if (actionItem.getDelegatorPrincipalId() != null) {
            delegatorType = "user";
            delegatorId = actionItem.getDelegatorPrincipalId();
            Principal delegator = KimApiServiceLocator.getIdentityService().getPrincipal(delegatorId);
            if (delegator == null) {
                LOG.error((Object)("Cannot find user for id " + delegatorId));
                delegatorDisplayValue = "USER NOT FOUND";
            } else {
                delegatorDisplayValue = UserUtils.getTransposedName(GlobalVariables.getUserSession(), (PrincipalContract)delegator);
            }
        } else if (actionItem.getDelegatorPrincipalId() != null) {
            delegatorType = "workgroup";
            delegatorId = actionItem.getDelegatorGroupId().toString();
            delegatorDisplayValue = KimApiServiceLocator.getGroupService().getGroup(actionItem.getDelegatorGroupId()).getName();
        }
        delegatorElement.setAttribute("type", delegatorType);
        Element idElement = doc.createElement("id");
        idElement.appendChild(doc.createTextNode(delegatorId));
        delegatorElement.appendChild(idElement);
        Element displayValElement = doc.createElement("displayValue");
        displayValElement.appendChild(doc.createTextNode(delegatorDisplayValue));
        delegatorElement.appendChild(displayValElement);
        baseElement.appendChild(delegatorElement);
    }

    protected static void addWorkgroupRequestElement(Document doc, Element baseElement, ActionItem actionItem) {
        Element workgroupElement = doc.createElement("workgroupRequest");
        if (actionItem.getGroupId() != null) {
            Element idElement = doc.createElement("id");
            idElement.appendChild(doc.createTextNode(actionItem.getGroupId()));
            workgroupElement.appendChild(idElement);
            Element displayValElement = doc.createElement("displayValue");
            displayValElement.appendChild(doc.createTextNode(actionItem.getGroupId()));
            workgroupElement.appendChild(displayValElement);
        }
        baseElement.appendChild(workgroupElement);
    }

    protected void addSummarizedActionItem(Document doc, ActionItem actionItem, Person user, Node node, DocumentRouteHeaderValue routeHeader) throws Exception {
        if (node == null) {
            node = doc;
        }
        Element root = doc.createElement("summarizedActionItem");
        StyleableEmailContentServiceImpl.addTextElement(doc, root, "documentId", actionItem.getDocumentId());
        StyleableEmailContentServiceImpl.addTextElement(doc, root, "docName", actionItem.getDocName());
        StyleableEmailContentServiceImpl.addCDataElement(doc, root, "docLabel", actionItem.getDocLabel());
        StyleableEmailContentServiceImpl.addCDataElement(doc, root, "docTitle", actionItem.getDocTitle());
        StyleableEmailContentServiceImpl.addTextElement(doc, root, "docRouteStatus", routeHeader.getDocRouteStatus());
        StyleableEmailContentServiceImpl.addCDataElement(doc, root, "routeStatusLabel", routeHeader.getRouteStatusLabel());
        StyleableEmailContentServiceImpl.addTextElement(doc, root, "actionRequestCd", actionItem.getActionRequestCd());
        StyleableEmailContentServiceImpl.addTextElement(doc, root, "actionRequestLabel", CodeTranslator.getActionRequestLabel((String)actionItem.getActionRequestCd()));
        StyleableEmailContentServiceImpl.addDelegatorElement(doc, root, actionItem);
        StyleableEmailContentServiceImpl.addTimestampElement(doc, root, "createDate", routeHeader.getCreateDate());
        StyleableEmailContentServiceImpl.addWorkgroupRequestElement(doc, root, actionItem);
        if (actionItem.getDateTimeAssigned() != null) {
            StyleableEmailContentServiceImpl.addTimestampElement(doc, root, "dateAssigned", actionItem.getDateTimeAssigned().toDate());
        }
        node.appendChild(root);
    }

    public DocumentRouteHeaderValue getRouteHeader(ActionItem actionItem) {
        if (this.routeHeaderService == null) {
            this.routeHeaderService = KEWServiceLocator.getRouteHeaderService();
        }
        return this.routeHeaderService.getRouteHeader(actionItem.getDocumentId());
    }

    protected Map<String, DocumentRouteHeaderValue> getRouteHeaders(Collection<ActionItem> actionItems) {
        if (this.routeHeaderService == null) {
            this.routeHeaderService = KEWServiceLocator.getRouteHeaderService();
        }
        return this.routeHeaderService.getRouteHeadersForActionItems(actionItems);
    }

    protected static String transform(Templates style, Document doc) {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            style.newTransformer().transform(new DOMSource(doc), result);
            return writer.toString();
        }
        catch (TransformerException te) {
            String message = "Error transforming DOM";
            LOG.error((Object)message, (Throwable)te);
            throw new WorkflowRuntimeException(message, (Throwable)te);
        }
    }

    protected Templates getStyle(String styleName) {
        String message;
        Templates style = null;
        try {
            style = this.styleService.getStyleAsTranslet(styleName);
        }
        catch (TransformerConfigurationException tce) {
            message = "Error obtaining style '" + styleName + "', using default";
            LOG.error((Object)message, (Throwable)tce);
        }
        if (style == null) {
            LOG.warn((Object)("Could not find specified style, " + styleName + ", using default"));
            try {
                style = TransformerFactory.newInstance().newTemplates(new StreamSource(new DefaultResourceLoader().getResource("classpath:org/kuali/rice/kew/mail/defaultEmailStyle.xsl").getInputStream()));
            }
            catch (Exception tce) {
                message = "Error obtaining default style from resource: defaultEmailStyle.xsl";
                LOG.error((Object)message, (Throwable)tce);
                throw new WorkflowRuntimeException("Error obtaining style '" + styleName + "'", (Throwable)tce);
            }
        }
        return style;
    }

    protected EmailContent generateEmailContent(String styleName, Document doc) {
        Templates style = this.getStyle(styleName);
        return this.styleHelper.generateEmailContent(style, doc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EmailContent generateReminderForActionItems(Person user, Collection<ActionItem> actionItems, String name, String style) {
        DocumentBuilder db = StyleableEmailContentServiceImpl.getDocumentBuilder(false);
        Document doc = db.newDocument();
        Element element = doc.createElement(name);
        Map<String, DocumentRouteHeaderValue> routeHeaders = this.getRouteHeaders(actionItems);
        this.setStandardAttributes(element);
        doc.appendChild(element);
        try {
            StyleableEmailContentServiceImpl.addObjectXML(doc, user, element, "user");
            for (ActionItem actionItem : actionItems) {
                try {
                    this.addSummarizedActionItem(doc, actionItem, user, element, routeHeaders.get(actionItem.getDocumentId()));
                }
                catch (Exception e) {
                    String message = "Error generating XML for action item: " + actionItem;
                    LOG.error((Object)message, (Throwable)e);
                    throw new WorkflowRuntimeException((Throwable)e);
                    return this.generateEmailContent(style, doc);
                }
            }
        }
        catch (Exception e) {
            String message = "Error generating XML for action items: " + actionItems;
            LOG.error((Object)message, (Throwable)e);
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected void setStandardAttributes(Element e) {
        e.setAttribute("env", this.getDeploymentEnvironment());
        e.setAttribute("applicationEmailAddress", this.getApplicationEmailAddress());
        e.setAttribute("actionListUrl", this.getActionListUrl());
        e.setAttribute("preferencesUrl", this.getPreferencesUrl());
    }

    @Override
    public EmailContent generateImmediateReminder(Person user, ActionItem actionItem, DocumentType documentType) {
        if (user != null) {
            LOG.info((Object)"Starting generation of immediate email reminder...");
            LOG.info((Object)("Action Id: " + actionItem.getId() + ";  ActionRequestId: " + actionItem.getActionRequestId() + ";  Action Item Principal Id: " + actionItem.getPrincipalId()));
            LOG.info((Object)("User Principal Id: " + user.getPrincipalId()));
            String styleSheet = documentType.getCustomEmailStylesheet();
            LOG.debug((Object)(documentType.getName() + " style: " + styleSheet));
            if (styleSheet == null) {
                styleSheet = this.globalEmailStyleSheet;
            }
            LOG.info((Object)("generateImmediateReminder using style sheet: " + styleSheet + " for Document Type " + documentType.getName()));
            DocumentBuilder db = StyleableEmailContentServiceImpl.getDocumentBuilder(false);
            Document doc = db.newDocument();
            Element element = doc.createElement("immediateReminder");
            this.setStandardAttributes(element);
            doc.appendChild(element);
            try {
                StyleableEmailContentServiceImpl.addObjectXML(doc, user, element, "user");
                Node node = element;
                if (node == null) {
                    node = doc;
                }
                Element root = doc.createElement("actionItem");
                try {
                    CustomEmailAttribute customEmailAttribute = StyleableEmailContentServiceImpl.getCustomEmailAttribute(user, actionItem);
                    if (customEmailAttribute != null) {
                        String customEmailSubject;
                        String customBody = customEmailAttribute.getCustomEmailBody();
                        if (!StringUtils.isEmpty((String)customBody)) {
                            Element bodyElement = doc.createElement("customBody");
                            bodyElement.appendChild(doc.createTextNode(customBody));
                            root.appendChild(bodyElement);
                        }
                        if (!StringUtils.isEmpty((String)(customEmailSubject = customEmailAttribute.getCustomEmailSubject()))) {
                            Element subjectElement = doc.createElement("customSubject");
                            subjectElement.appendChild(doc.createTextNode(customEmailSubject));
                            root.appendChild(subjectElement);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when checking for custom email body and subject.", (Throwable)e);
                }
                Person person = KimApiServiceLocator.getPersonService().getPerson(actionItem.getPrincipalId());
                DocumentRouteHeaderValue header = this.getRouteHeader(actionItem);
                StyleableEmailContentServiceImpl.addObjectXML(doc, actionItem, root, "actionItem");
                StyleableEmailContentServiceImpl.addObjectXML(doc, person, root, "actionItemPerson");
                StyleableEmailContentServiceImpl.addTextElement(doc, root, "actionItemPrincipalId", person.getPrincipalId());
                StyleableEmailContentServiceImpl.addTextElement(doc, root, "actionItemPrincipalName", person.getPrincipalName());
                this.addDocumentHeaderXML(doc, header, root, "doc");
                StyleableEmailContentServiceImpl.addObjectXML(doc, header.getInitiatorPrincipal(), root, "docInitiator");
                StyleableEmailContentServiceImpl.addTextElement(doc, root, "docInitiatorDisplayName", header.getInitiatorDisplayName());
                StyleableEmailContentServiceImpl.addObjectXML(doc, header.getDocumentType(), root, "documentType");
                node.appendChild(root);
            }
            catch (Exception e) {
                String message = "Error generating immediate reminder XML for action item: " + actionItem;
                LOG.error((Object)message, (Throwable)e);
                throw new WorkflowRuntimeException((Throwable)e);
            }
            LOG.info((Object)"Leaving generation of immeidate email reminder...");
            return this.generateEmailContent(styleSheet, doc);
        }
        LOG.info((Object)"Skipping generation of immediate email reminder due to the user being null");
        return null;
    }

    protected void addDocumentHeaderXML(Document document, DocumentRouteHeaderValue documentHeader, Node node, String elementName) throws Exception {
        Element element = XmlHelper.propertiesToXml((Document)document, (Object)documentHeader, (String)elementName);
        Element docContentElement = (Element)element.getElementsByTagName("docContent").item(0);
        String documentContent = docContentElement.getTextContent();
        if (!StringUtils.isBlank((String)documentContent) && documentContent.startsWith("<")) {
            Document documentContentXML = XmlHelper.readXml((String)documentContent);
            Element documentContentElement = documentContentXML.getDocumentElement();
            documentContentElement = (Element)document.importNode(documentContentElement, true);
            docContentElement.removeChild(docContentElement.getFirstChild());
            docContentElement.appendChild(documentContentElement);
        } else {
            docContentElement.removeChild(docContentElement.getFirstChild());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)XmlJotter.jotNode((Node)element));
        }
        node.appendChild(element);
    }

    @Override
    public EmailContent generateWeeklyReminder(Person user, Collection<ActionItem> actionItems) {
        return this.generateReminderForActionItems(user, actionItems, "weeklyReminder", this.globalEmailStyleSheet);
    }

    @Override
    public EmailContent generateDailyReminder(Person user, Collection<ActionItem> actionItems) {
        return this.generateReminderForActionItems(user, actionItems, "dailyReminder", this.globalEmailStyleSheet);
    }

    @Override
    public EmailContent generateFeedback(FeedbackForm form) {
        DocumentBuilder db = StyleableEmailContentServiceImpl.getDocumentBuilder(true);
        Document doc = db.newDocument();
        String styleSheet = this.globalEmailStyleSheet;
        LOG.info((Object)("form: " + form.getDocumentId()));
        try {
            StyleableEmailContentServiceImpl.addObjectXML(doc, (Object)form, null, "feedback");
        }
        catch (Exception e) {
            String message = "Error generating XML for feedback form: " + (Object)((Object)form);
            LOG.error((Object)message, (Throwable)e);
            throw new WorkflowRuntimeException(message, (Throwable)e);
        }
        this.setStandardAttributes(doc.getDocumentElement());
        return this.generateEmailContent(styleSheet, doc);
    }
}

