/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginLoader;
import org.kuali.rice.kew.plugin.PluginRegistry;
import org.kuali.rice.kew.plugin.Reloadable;

public class PluginEnvironment
implements Reloadable {
    private boolean loaded = false;
    private Plugin plugin;
    private final PluginLoader loader;
    private final PluginRegistry registry;
    private boolean supressStartupFailure = true;

    public PluginEnvironment(PluginLoader loader, PluginRegistry registry) {
        this.loader = loader;
        this.registry = registry;
    }

    public PluginEnvironment(Plugin plugin, PluginLoader loader, PluginRegistry registry) {
        this(loader, registry);
        this.plugin = plugin;
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean isReloadable() {
        return true;
    }

    @Override
    public synchronized boolean isReloadNeeded() {
        return this.loader.isModified();
    }

    @Override
    public synchronized void reload() throws Exception {
        this.unload();
        this.load();
    }

    public synchronized void load() throws Exception {
        this.plugin = this.loader.load();
        this.plugin.setSupressStartupFailure(this.supressStartupFailure);
        this.registry.addResourceLoader((ResourceLoader)this.plugin);
        this.plugin.start();
        this.loaded = true;
    }

    public synchronized void unload() throws Exception {
        if (this.plugin != null) {
            this.plugin.stop();
            this.registry.removeResourceLoader(this.plugin.getName());
        }
        this.loaded = false;
    }

    public String getPluginName() {
        if (this.getPlugin() != null) {
            return this.getPlugin().getName().getLocalPart();
        }
        return this.loader.getPluginName();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public PluginLoader getLoader() {
        return this.loader;
    }

    public void setSupressStartupFailure(boolean supressStartupFailure) {
        this.supressStartupFailure = supressStartupFailure;
    }
}

