/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader.service.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.docsearch.dao.SearchableAttributeDAO;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.dao.DocumentRouteHeaderDAO;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RouteHeaderServiceImpl
implements RouteHeaderService {
    private static final Logger LOG = Logger.getLogger(RouteHeaderServiceImpl.class);
    private DocumentRouteHeaderDAO routeHeaderDAO;
    private SearchableAttributeDAO searchableAttributeDAO;

    @Override
    public DocumentRouteHeaderValue getRouteHeader(String documentId) {
        return this.getRouteHeaderDAO().findRouteHeader(documentId);
    }

    @Override
    public DocumentRouteHeaderValue getRouteHeader(String documentId, boolean clearCache) {
        return this.getRouteHeaderDAO().findRouteHeader(documentId, clearCache);
    }

    @Override
    public Collection<DocumentRouteHeaderValue> getRouteHeaders(Collection<String> documentIds) {
        return this.getRouteHeaderDAO().findRouteHeaders(documentIds);
    }

    @Override
    public Collection<DocumentRouteHeaderValue> getRouteHeaders(Collection<String> documentIds, boolean clearCache) {
        return this.getRouteHeaderDAO().findRouteHeaders(documentIds, clearCache);
    }

    @Override
    public Map<String, DocumentRouteHeaderValue> getRouteHeadersForActionItems(Collection<ActionItem> actionItems) {
        HashMap<String, DocumentRouteHeaderValue> routeHeaders = new HashMap<String, DocumentRouteHeaderValue>();
        ArrayList<String> documentIds = new ArrayList<String>(actionItems.size());
        for (ActionItem actionItem : actionItems) {
            documentIds.add(actionItem.getDocumentId());
        }
        Collection<DocumentRouteHeaderValue> actionItemRouteHeaders = this.getRouteHeaders(documentIds);
        if (actionItemRouteHeaders != null) {
            for (DocumentRouteHeaderValue routeHeader : actionItemRouteHeaders) {
                routeHeaders.put(routeHeader.getDocumentId(), routeHeader);
            }
        }
        return routeHeaders;
    }

    @Override
    public void lockRouteHeader(String documentId, boolean wait) {
        this.getRouteHeaderDAO().lockRouteHeader(documentId, wait);
        LOG.debug((Object)("Successfully locked document [docId=" + documentId + "]"));
    }

    @Override
    public void saveRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.getRouteHeaderDAO().saveRouteHeader(routeHeader);
    }

    @Override
    public void deleteRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.getRouteHeaderDAO().deleteRouteHeader(routeHeader);
    }

    @Override
    public String getNextDocumentId() {
        return this.getRouteHeaderDAO().getNextDocumentId();
    }

    @Override
    public Collection findPendingByResponsibilityIds(Set responsibilityIds) {
        return this.getRouteHeaderDAO().findPendingByResponsibilityIds(responsibilityIds);
    }

    @Override
    public void clearRouteHeaderSearchValues(String documentId) {
        this.getRouteHeaderDAO().clearRouteHeaderSearchValues(documentId);
    }

    @Override
    public void updateRouteHeaderSearchValues(String documentId, List<SearchableAttributeValue> searchAttributes) {
        this.getRouteHeaderDAO().clearRouteHeaderSearchValues(documentId);
        HashSet<String> uniqueAttributes = new HashSet<String>();
        for (SearchableAttributeValue searchAttribute : searchAttributes) {
            String fakeKey;
            if (searchAttribute == null || uniqueAttributes.contains(fakeKey = searchAttribute.getSearchableAttributeKey() + "-" + searchAttribute.getSearchableAttributeValue())) continue;
            this.getRouteHeaderDAO().save(searchAttribute);
            uniqueAttributes.add(fakeKey);
        }
        LOG.info((Object)("Deduplication adjusted incoming SearchableAttributeValue list from original: " + searchAttributes.size() + " entries into : " + (searchAttributes.size() - uniqueAttributes.size()) + " entries."));
    }

    @Override
    public void validateRouteHeader(DocumentRouteHeaderValue routeHeader) {
        DocumentType docType;
        LOG.debug((Object)"Enter validateRouteHeader(..)");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        if (routeHeader.getDocRouteStatus() == null || routeHeader.getDocRouteStatus().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader route status null.", "routeheader.routestatus.empty"));
        } else if (!KewApiConstants.DOCUMENT_STATUSES.containsKey(routeHeader.getDocRouteStatus())) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader route status invalid.", "routeheader.routestatus.invalid"));
        }
        if (routeHeader.getDocRouteLevel() == null || routeHeader.getDocRouteLevel() < 0) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader route level invalid.", "routeheader.routelevel.invalid"));
        }
        if (routeHeader.getDateLastModified() == null) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader status modification date empty.", "routeheader.statusmoddate.empty"));
        }
        if (routeHeader.getCreateDate() == null) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader status create date empty.", "routeheader.createdate.empty"));
        }
        if (routeHeader.getDocVersion() == null || routeHeader.getDocVersion() < 0) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader doc version invalid.", "routeheader.docversion.invalid"));
        }
        if (routeHeader.getInitiatorWorkflowId() == null || routeHeader.getInitiatorWorkflowId().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader initiator null.", "routeheader.initiator.empty"));
        } else {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(routeHeader.getInitiatorWorkflowId());
            if (principal == null) {
                errors.add(new WorkflowServiceErrorImpl("RouteHeader initiator id invalid.", "routeheader.initiator.invalid"));
            }
        }
        if (!StringUtils.isBlank((String)routeHeader.getDocumentTypeId()) && (docType = KEWServiceLocator.getDocumentTypeService().findById(routeHeader.getDocumentTypeId())) == null) {
            errors.add(new WorkflowServiceErrorImpl("RouteHeader document type id invalid.", "routeheader.doctypeid.invalid"));
        }
        LOG.debug((Object)"Exit validateRouteHeader(..) ");
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("RouteHeader Validation Error", errors);
        }
    }

    @Override
    public String getApplicationIdByDocumentId(String documentId) {
        return this.getRouteHeaderDAO().getApplicationIdByDocumentId(documentId);
    }

    @Override
    public DocumentRouteHeaderValueContent getContent(String documentId) {
        if (documentId == null) {
            return new DocumentRouteHeaderValueContent();
        }
        DocumentRouteHeaderValueContent content = this.getRouteHeaderDAO().getContent(documentId);
        if (content == null) {
            content = new DocumentRouteHeaderValueContent(documentId);
        }
        return content;
    }

    @Override
    public boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey, String searchableAttributeValue) {
        return this.getRouteHeaderDAO().hasSearchableAttributeValue(documentId, searchableAttributeKey, searchableAttributeValue);
    }

    @Override
    public String getDocumentStatus(String documentId) {
        return this.getRouteHeaderDAO().getDocumentStatus(documentId);
    }

    @Override
    public String getAppDocId(String documentId) {
        if (documentId == null) {
            return null;
        }
        return this.getRouteHeaderDAO().getAppDocId(documentId);
    }

    @Override
    public String getAppDocStatus(String documentId) {
        if (documentId == null) {
            return null;
        }
        return this.getRouteHeaderDAO().getAppDocStatus(documentId);
    }

    public DocumentRouteHeaderDAO getRouteHeaderDAO() {
        return this.routeHeaderDAO;
    }

    public void setRouteHeaderDAO(DocumentRouteHeaderDAO routeHeaderDAO) {
        this.routeHeaderDAO = routeHeaderDAO;
    }

    @Override
    public List<Timestamp> getSearchableAttributeDateTimeValuesByKey(String documentId, String key) {
        return this.getSearchableAttributeDAO().getSearchableAttributeDateTimeValuesByKey(documentId, key);
    }

    @Override
    public List<BigDecimal> getSearchableAttributeFloatValuesByKey(String documentId, String key) {
        return this.getSearchableAttributeDAO().getSearchableAttributeFloatValuesByKey(documentId, key);
    }

    @Override
    public List<Long> getSearchableAttributeLongValuesByKey(String documentId, String key) {
        return this.getSearchableAttributeDAO().getSearchableAttributeLongValuesByKey(documentId, key);
    }

    @Override
    public List<String> getSearchableAttributeStringValuesByKey(String documentId, String key) {
        return this.getSearchableAttributeDAO().getSearchableAttributeStringValuesByKey(documentId, key);
    }

    public void setSearchableAttributeDAO(SearchableAttributeDAO searchableAttributeDAO) {
        this.searchableAttributeDAO = searchableAttributeDAO;
    }

    public SearchableAttributeDAO getSearchableAttributeDAO() {
        return this.searchableAttributeDAO;
    }

    @Override
    public Collection findByDocTypeAndAppId(String documentTypeName, String appId) {
        return this.getRouteHeaderDAO().findByDocTypeAndAppId(documentTypeName, appId);
    }
}

