/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.dao.RuleDAO;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RuleDAOJpaImpl
implements RuleDAO {
    private static final Logger LOG = Logger.getLogger(RuleDAOJpaImpl.class);
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;
    private static final String OLD_DELEGATIONS_SQL = "select oldDel.dlgn_rule_id from krew_rule_rsp_t oldRsp, krew_dlgn_rsp_t oldDel where oldRsp.rule_id=? and oldRsp.rule_rsp_id=oldDel.rule_rsp_id and oldDel.dlgn_rule_base_val_id not in (select newDel.dlgn_rule_base_val_id from krew_rule_rsp_t newRsp, krew_dlgn_rsp_t newDel where newRsp.rule_id=? and newRsp.rule_rsp_id=newDel.rule_rsp_id)";

    @Override
    public void save(RuleBaseValues ruleBaseValues) {
        if (ruleBaseValues.getId() == null) {
            this.entityManager.persist((Object)ruleBaseValues);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)((Object)ruleBaseValues));
        }
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.in("docTypeName", (Collection)documentTypes);
        crit.eq("ruleTemplateId", (Object)ruleTemplateId);
        crit.eq("currentInd", (Object)Boolean.TRUE);
        crit.eq("active", (Object)Boolean.TRUE);
        crit.eq("delegateRule", (Object)Boolean.FALSE);
        crit.eq("templateRuleInd", (Object)Boolean.FALSE);
        crit.and(this.generateFromToDateCriteria(new Date()));
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes, Timestamp effectiveDate) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.in("docTypeName", (Collection)documentTypes);
        crit.eq("ruleTemplateId", (Object)ruleTemplateId);
        crit.eq("active", (Object)Boolean.TRUE);
        crit.eq("delegateRule", (Object)Boolean.FALSE);
        crit.eq("templateRuleInd", (Object)Boolean.FALSE);
        if (effectiveDate != null) {
            crit.lte("activationDate", (Object)effectiveDate);
            crit.gte("deactivationDate", (Object)effectiveDate);
        }
        crit.and(this.generateFromToDateCriteria(new Date()));
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    public Criteria generateFromToDateCriteria(Date date) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        Criteria fromCrit = new Criteria(RuleBaseValues.class.getName());
        Criteria fromNullCrit = new Criteria(RuleBaseValues.class.getName());
        fromNullCrit.isNull("fromDateValue");
        Criteria fromLessOrEqualCrit = new Criteria(RuleBaseValues.class.getName());
        fromLessOrEqualCrit.lte("fromDateValue", (Object)new Timestamp(date.getTime()));
        fromCrit.or(fromNullCrit);
        fromCrit.or(fromLessOrEqualCrit);
        Criteria toCrit = new Criteria(RuleBaseValues.class.getName());
        Criteria toNullCrit = new Criteria(RuleBaseValues.class.getName());
        toNullCrit.isNull("toDateValue");
        Criteria toGreaterOrEqualCrit = new Criteria(RuleBaseValues.class.getName());
        toGreaterOrEqualCrit.gte("toDateValue", (Object)new Timestamp(date.getTime()));
        toCrit.or(toNullCrit);
        toCrit.or(toGreaterOrEqualCrit);
        crit.and(fromCrit);
        crit.and(toCrit);
        return crit;
    }

    @Override
    public List<RuleBaseValues> fetchAllRules(boolean currentRules) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("currentInd", (Object)new Boolean(currentRules));
        crit.eq("templateRuleInd", (Object)Boolean.FALSE);
        crit.orderBy("activationDate", false);
        QueryByCriteria query = new QueryByCriteria(this.entityManager, crit);
        return query.toQuery().getResultList();
    }

    @Override
    public void delete(String ruleBaseValuesId) {
        this.entityManager.remove(this.entityManager.find(RuleBaseValues.class, (Object)ruleBaseValuesId));
    }

    @Override
    public List<RuleBaseValues> findByDocumentId(String documentId) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("documentId", (Object)documentId);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public RuleBaseValues findRuleBaseValuesByName(String name) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        if (name == null) {
            return null;
        }
        crit.eq("name", (Object)name);
        crit.eq("currentInd", (Object)Boolean.TRUE);
        return (RuleBaseValues)((Object)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult());
    }

    @Override
    public RuleBaseValues findRuleBaseValuesById(String ruleBaseValuesId) {
        if (ruleBaseValuesId == null) {
            return null;
        }
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("id", (Object)ruleBaseValuesId);
        return (RuleBaseValues)((Object)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult());
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewer(String reviewerName, String type) {
        Criteria crit = new Criteria(RuleResponsibilityBo.class.getName());
        crit.eq("ruleResponsibilityName", (Object)reviewerName);
        crit.eq("ruleResponsibilityType", (Object)type);
        List responsibilities = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewerTemplateDoc(String ruleTemplateName, String documentType, String reviewerName, String type) {
        Criteria crit = new Criteria(RuleResponsibilityBo.class.getName());
        crit.eq("ruleResponsibilityName", (Object)reviewerName);
        crit.eq("ruleResponsibilityType", (Object)type);
        crit.eq("ruleBaseValues.currentInd", (Object)Boolean.TRUE);
        if (!StringUtils.isBlank((String)ruleTemplateName)) {
            crit.like("ruleBaseValues.ruleTemplate.name", (Object)ruleTemplateName.replace("*", "%").concat("%"));
        }
        if (!StringUtils.isBlank((String)documentType)) {
            crit.like("ruleBaseValues.docTypeName", (Object)documentType.replace("*", "%").concat("%"));
        }
        List responsibilities = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public RuleResponsibilityBo findRuleResponsibility(String responsibilityId) {
        Criteria crit = new Criteria(RuleResponsibilityBo.class.getName());
        crit.eq("responsibilityId", (Object)responsibilityId);
        List responsibilities = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            if (!responsibility.getRuleBaseValues().getCurrentInd().booleanValue()) continue;
            return responsibility;
        }
        return null;
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String groupId, String principalId, Boolean delegateRule, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        if (ruleId != null) {
            crit.eq("id", (Object)ruleId);
        }
        if (groupId != null) {
            this.addResponsibilityCriteria(crit, groupId);
        }
        Collection<String> kimGroupIds = new HashSet<String>();
        Boolean searchUser = Boolean.FALSE;
        Boolean searchUserInWorkgroups = Boolean.FALSE;
        if ("group".equals(workflowIdDirective)) {
            searchUserInWorkgroups = Boolean.TRUE;
        } else if (StringUtils.isBlank((String)workflowIdDirective)) {
            searchUser = Boolean.TRUE;
            searchUserInWorkgroups = Boolean.TRUE;
        } else {
            searchUser = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)principalId) && searchUserInWorkgroups.booleanValue()) {
            Principal principal = null;
            principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new RiceRuntimeException("Failed to locate user for the given principal id: " + principalId);
            }
            kimGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        this.addResponsibilityCriteria(crit, kimGroupIds, principalId, searchUser, searchUserInWorkgroups);
        crit.distinct(true);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, Boolean delegateRule, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        this.addResponsibilityCriteria(crit, workgroupIds, workflowId, actionRequestCodes, workflowId != null, workgroupIds != null && !workgroupIds.isEmpty());
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    private void addResponsibilityCriteria(Criteria parentCrit, Collection<String> kimGroupIds, String principalId, Boolean searchUser, Boolean searchUserInWorkgroups) {
        ArrayList<String> workgroupIdStrings = new ArrayList<String>();
        for (String workgroupId : kimGroupIds) {
            workgroupIdStrings.add(workgroupId.toString());
        }
        this.addResponsibilityCriteria(parentCrit, workgroupIdStrings, principalId, new ArrayList(), searchUser, searchUserInWorkgroups);
    }

    private void addResponsibilityCriteria(Criteria parentCrit, Collection<String> workgroupIds, String workflowId, Collection actionRequestCodes, Boolean searchUser, Boolean searchUserInWorkgroups) {
        Criteria responsibilityCrit = null;
        Criteria ruleResponsibilityNameCrit = null;
        if (actionRequestCodes != null && !actionRequestCodes.isEmpty()) {
            responsibilityCrit = new Criteria(RuleBaseValues.class.getName(), false);
            responsibilityCrit.in("__JPA_ALIAS[['rr']]__.actionRequestedCd", new ArrayList(actionRequestCodes));
        }
        if (!StringUtils.isEmpty((String)workflowId)) {
            if (searchUser != null && searchUser.booleanValue()) {
                ruleResponsibilityNameCrit = new Criteria(RuleBaseValues.class.getName(), false);
                ruleResponsibilityNameCrit.like("__JPA_ALIAS[['rr']]__.ruleResponsibilityName", (Object)workflowId);
                ruleResponsibilityNameCrit.eq("__JPA_ALIAS[['rr']]__.ruleResponsibilityType", (Object)"F");
            }
            if (searchUserInWorkgroups != null && searchUserInWorkgroups.booleanValue() && workgroupIds != null && !workgroupIds.isEmpty()) {
                if (ruleResponsibilityNameCrit == null) {
                    ruleResponsibilityNameCrit = new Criteria(RuleBaseValues.class.getName(), false);
                }
                Criteria workgroupCrit = new Criteria(RuleBaseValues.class.getName(), false);
                workgroupCrit.in("__JPA_ALIAS[['rr']]__.ruleResponsibilityName", new ArrayList<String>(workgroupIds));
                workgroupCrit.eq("__JPA_ALIAS[['rr']]__.ruleResponsibilityType", (Object)"G");
                ruleResponsibilityNameCrit.or(workgroupCrit);
            }
        } else if (workgroupIds != null && workgroupIds.size() == 1) {
            ruleResponsibilityNameCrit = new Criteria(RuleBaseValues.class.getName(), false);
            ruleResponsibilityNameCrit.like("__JPA_ALIAS[['rr']]__.ruleResponsibilityName", (Object)workgroupIds.iterator().next());
            ruleResponsibilityNameCrit.eq("__JPA_ALIAS[['rr']]__.ruleResponsibilityType", (Object)"G");
        } else if (workgroupIds != null && workgroupIds.size() > 1) {
            ruleResponsibilityNameCrit = new Criteria(RuleBaseValues.class.getName(), false);
            ruleResponsibilityNameCrit.in("__JPA_ALIAS[['rr']]__.ruleResponsibilityName", new ArrayList<String>(workgroupIds));
            ruleResponsibilityNameCrit.eq("__JPA_ALIAS[['rr']]__.ruleResponsibilityType", (Object)"G");
        }
        if (ruleResponsibilityNameCrit != null) {
            if (responsibilityCrit == null) {
                responsibilityCrit = new Criteria(RuleBaseValues.class.getName(), false);
            }
            responsibilityCrit.and(ruleResponsibilityNameCrit);
        }
        if (responsibilityCrit != null) {
            if (parentCrit.getAliasIndex("rr") == -1) {
                parentCrit.join("responsibilities", "rr", false, true);
            }
            parentCrit.and(responsibilityCrit);
        }
    }

    private Criteria getSearchCriteria(String docTypeName, String ruleTemplateId, String ruleDescription, Boolean delegateRule, Boolean activeInd, Map extensionValues) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("currentInd", (Object)Boolean.TRUE);
        crit.eq("templateRuleInd", (Object)Boolean.FALSE);
        if (activeInd != null) {
            crit.eq("active", (Object)activeInd);
        }
        if (docTypeName != null) {
            crit.like("UPPER(__JPA_ALIAS[[0]]__.docTypeName)", (Object)docTypeName.toUpperCase());
        }
        if (ruleDescription != null && !ruleDescription.trim().equals("")) {
            crit.like("UPPER(__JPA_ALIAS[[0]]__.description)", (Object)ruleDescription.toUpperCase());
        }
        if (ruleTemplateId != null) {
            crit.eq("ruleTemplateId", (Object)ruleTemplateId);
        }
        if (delegateRule != null) {
            crit.eq("delegateRule", (Object)delegateRule);
        }
        if (extensionValues != null && !extensionValues.isEmpty()) {
            for (Map.Entry entry : extensionValues.entrySet()) {
                if (StringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                Criteria extensionCrit2 = new Criteria(RuleExtensionBo.class.getName());
                extensionCrit2.distinct(true);
                extensionCrit2.join("extensionValues", "extval", false, true);
                extensionCrit2.eq("__JPA_ALIAS[['extval']]__.key", entry.getKey());
                extensionCrit2.like("UPPER(__JPA_ALIAS[['extval']]__.value)", (Object)("%" + (String)entry.getValue() + "%").toUpperCase());
                extensionCrit2.memberOf("__JPA_ALIAS[[0]]__", "__JPA_ALIAS[[-1]]__.ruleExtensions");
                crit.exists(extensionCrit2);
            }
        }
        return crit;
    }

    private void addResponsibilityCriteria(Criteria parentCrit, String ruleResponsibilityName) {
        if (parentCrit.getAliasIndex("rr") == -1) {
            parentCrit.join("responsibilities", "rr", false, true);
        }
        parentCrit.like("__JPA_ALIAS[['rr']]__.ruleResponsibilityName", (Object)ruleResponsibilityName);
    }

    @Override
    public List<RuleBaseValues> findByPreviousRuleId(String previousRuleId) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("previousRuleId", (Object)previousRuleId);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public RuleBaseValues findDefaultRuleByRuleTemplateId(String ruleTemplateId) {
        Criteria crit = new Criteria(RuleBaseValues.class.getName());
        crit.eq("ruleTemplateId", (Object)ruleTemplateId);
        crit.eq("templateRuleInd", (Object)Boolean.TRUE);
        List rules = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        if (rules != null && !rules.isEmpty()) {
            return (RuleBaseValues)((Object)rules.get(0));
        }
        return null;
    }

    @Override
    public void retrieveAllReferences(RuleBaseValues rule) {
    }

    @Override
    public RuleBaseValues getParentRule(String ruleBaseValuesId) {
        Criteria criteria = new Criteria(RuleBaseValues.class.getName());
        criteria.eq("currentInd", (Object)Boolean.TRUE);
        criteria.eq("responsibilities.delegationRules.delegateRuleId", (Object)ruleBaseValuesId);
        List rules = new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
        RuleBaseValues rule = null;
        for (RuleBaseValues currentRule : rules) {
            if (rule != null && currentRule.getVersionNbr() <= rule.getVersionNbr()) continue;
            rule = currentRule;
        }
        return rule;
    }

    @Override
    public List findOldDelegations(RuleBaseValues oldRule, RuleBaseValues newRule) {
        Query q = this.entityManager.createNativeQuery(OLD_DELEGATIONS_SQL);
        q.setParameter(1, (Object)oldRule.getId());
        q.setParameter(2, (Object)newRule.getId());
        ArrayList<RuleBaseValues> oldDelegations = new ArrayList<RuleBaseValues>();
        for (Object l : q.getResultList()) {
            oldDelegations.add(this.findRuleBaseValuesById(String.valueOf(l)));
        }
        return oldDelegations;
    }

    @Override
    public String findResponsibilityIdForRule(String ruleName, String ruleResponsibilityName, String ruleResponsibilityType) {
        Iterator iter;
        Criteria crit = new Criteria(RuleResponsibilityBo.class.getName());
        crit.eq("ruleResponsibilityName", (Object)ruleResponsibilityName);
        crit.eq("ruleResponsibilityType", (Object)ruleResponsibilityType);
        crit.eq("ruleBaseValues.currentInd", (Object)Boolean.TRUE);
        crit.eq("ruleBaseValues.name", (Object)ruleName);
        List responsibilities = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        if (responsibilities != null && (iter = responsibilities.iterator()).hasNext()) {
            RuleResponsibilityBo responsibility = (RuleResponsibilityBo)((Object)iter.next());
            return responsibility.getResponsibilityId();
        }
        return null;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

