/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.Iterator;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermissionId;

@IdClass(value=KimDocumentRolePermissionId.class)
@Entity
@Table(name="KRIM_PND_ROLE_PERM_T")
public class KimDocumentRolePermission
extends KimDocumentBoActivatableBase {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="KRIM_ROLE_PERM_ID_S")
    @GenericGenerator(name="KRIM_ROLE_PERM_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ROLE_PERM_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ROLE_PERM_ID")
    protected String rolePermissionId;
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="PERM_ID")
    protected String permissionId;
    @Transient
    protected Permission permission;
    @Transient
    protected String name;
    @Transient
    protected String namespaceCode;

    public String getPermissionId() {
        return this.permissionId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getRolePermissionId() {
        return this.rolePermissionId;
    }

    public void setPermissionId(String permissionId) {
        this.permissionId = permissionId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setRolePermissionId(String rolePermissionId) {
        this.rolePermissionId = rolePermissionId;
    }

    public Permission getPermission() {
        if (!(null == this.permissionId || this.permission != null && StringUtils.equals((String)this.permission.getId(), (String)this.permissionId))) {
            this.permission = KimApiServiceLocator.getPermissionService().getPermission(this.permissionId);
        }
        return this.permission;
    }

    public String getPermissionDetailValues() {
        Permission perm = this.getPermission();
        StringBuffer sb = new StringBuffer();
        if (perm.getAttributes() != null) {
            Iterator keyIter = perm.getAttributes().keySet().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                sb.append(key).append('=').append((String)perm.getAttributes().get(key));
                if (!keyIter.hasNext()) continue;
                sb.append(", ").append(" ");
            }
        }
        return sb.toString();
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public String getName() {
        if (null == this.permission) {
            this.getPermission();
        }
        if (null == this.permission) {
            return "";
        }
        return this.permission.getName();
    }

    public String getNamespaceCode() {
        if (null == this.permission) {
            this.getPermission();
        }
        if (null == this.permission) {
            return "";
        }
        return this.permission.getNamespaceCode();
    }
}

