/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableEditableBase;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfoId;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;

@IdClass(value=PersonDocumentEmploymentInfoId.class)
@Entity
@Table(name="KRIM_PND_EMP_INFO_MT")
public class PersonDocumentEmploymentInfo
extends KimDocumentBoActivatableEditableBase {
    @Id
    @GeneratedValue(generator="KRIM_ENTITY_EMP_ID_S")
    @GenericGenerator(name="KRIM_ENTITY_EMP_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ENTITY_EMP_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ENTITY_EMP_ID")
    protected String entityEmploymentId;
    @Column(name="ENTITY_AFLTN_ID")
    protected String entityAffiliationId;
    @Column(name="EMP_STAT_CD")
    protected String employmentStatusCode;
    @Column(name="EMP_TYP_CD")
    protected String employmentTypeCode;
    @Column(name="PRMRY_DEPT_CD")
    protected String primaryDepartmentCode;
    @Column(name="BASE_SLRY_AMT")
    protected KualiDecimal baseSalaryAmount;
    @Column(name="EMP_ID")
    protected String employeeId;
    @Column(name="EMP_REC_ID")
    protected String employmentRecordId;
    @Type(type="yes_no")
    @Column(name="PRMRY_IND")
    protected boolean primary;
    @ManyToOne(targetEntity=EntityEmploymentTypeBo.class, fetch=FetchType.EAGER, cascade={})
    @JoinColumn(name="EMP_TYP_CD", insertable=false, updatable=false)
    protected EntityEmploymentTypeBo employmentType;
    @ManyToOne(targetEntity=EntityEmploymentStatusBo.class, fetch=FetchType.EAGER, cascade={})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="EMP_STAT_CD", insertable=false, updatable=false)
    protected EntityEmploymentStatusBo employmentStatus;
    @Transient
    protected PersonDocumentAffiliation affiliation;

    public PersonDocumentEmploymentInfo() {
        this.active = true;
    }

    public KualiDecimal getBaseSalaryAmount() {
        return this.baseSalaryAmount;
    }

    public String getEmploymentStatusCode() {
        return this.employmentStatusCode;
    }

    public String getEmploymentTypeCode() {
        return this.employmentTypeCode;
    }

    public String getEntityAffiliationId() {
        return this.entityAffiliationId;
    }

    public String getEntityEmploymentId() {
        return this.entityEmploymentId;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setEntityAffiliationId(String entityAffiliationId) {
        this.entityAffiliationId = entityAffiliationId;
    }

    public void setBaseSalaryAmount(KualiDecimal baseSalaryAmount) {
        this.baseSalaryAmount = baseSalaryAmount;
    }

    public void setEmploymentStatusCode(String employmentStatusCode) {
        this.employmentStatusCode = employmentStatusCode;
    }

    public void setEmploymentTypeCode(String employmentTypeCode) {
        this.employmentTypeCode = employmentTypeCode;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setEntityEmploymentId(String entityEmploymentId) {
        this.entityEmploymentId = entityEmploymentId;
    }

    public EntityEmploymentTypeBo getEmploymentType() {
        return this.employmentType;
    }

    public void setEmploymentType(EntityEmploymentTypeBo employmentType) {
        this.employmentType = employmentType;
    }

    public EntityEmploymentStatusBo getEmploymentStatus() {
        return this.employmentStatus;
    }

    public void setEmploymentStatus(EntityEmploymentStatusBo employmentStatus) {
        this.employmentStatus = employmentStatus;
    }

    public String getPrimaryDepartmentCode() {
        return this.primaryDepartmentCode;
    }

    public void setPrimaryDepartmentCode(String primaryDepartmentCode) {
        this.primaryDepartmentCode = primaryDepartmentCode;
    }

    public PersonDocumentAffiliation getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(PersonDocumentAffiliation affiliation) {
        this.affiliation = affiliation;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmploymentRecordId() {
        return this.employmentRecordId;
    }

    public void setEmploymentRecordId(String employmentRecordId) {
        this.employmentRecordId = employmentRecordId;
    }
}

