/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.GenericPermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class GenericPermissionMaintainable
extends KualiMaintainableImpl {
    private static final Logger LOG = Logger.getLogger(GenericPermissionMaintainable.class);
    private static final long serialVersionUID = -8102504656976243468L;
    protected transient SequenceAccessorService sequenceAccessorService;

    public void saveDataObject() {
        if (this.getDataObject() instanceof PersistableBusinessObject) {
            GenericPermissionBo genericPermissionBo = (GenericPermissionBo)this.getDataObject();
            boolean permissionExists = false;
            if (genericPermissionBo.getId() != null) {
                boolean bl = permissionExists = KimApiServiceLocator.getPermissionService().getPermission(genericPermissionBo.getId()) != null;
            }
            if (genericPermissionBo.getTemplateId() != null) {
                genericPermissionBo.setTemplate(PermissionTemplateBo.from((Template)KimApiServiceLocator.getPermissionService().getPermissionTemplate(genericPermissionBo.getTemplateId())));
            }
            PermissionBo perm = GenericPermissionBo.toPermissionBo((GenericPermissionBo)genericPermissionBo);
            if (permissionExists) {
                KimApiServiceLocator.getPermissionService().updatePermission(PermissionBo.to((PermissionBo)perm));
            } else {
                KimApiServiceLocator.getPermissionService().createPermission(PermissionBo.to((PermissionBo)perm));
            }
        } else {
            throw new RuntimeException("Cannot save object of type: " + this.getDataObjectClass() + " with permission service");
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        String newId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_PERM_ID_S").toString();
        ((GenericPermissionBo)document.getNewMaintainableObject().getDataObject()).setId(newId);
    }

    public Class<? extends PersistableBusinessObject> getBoClass() {
        return GenericPermissionBo.class;
    }

    public boolean isExternalBusinessObject() {
        return true;
    }

    public void prepareBusinessObject(BusinessObject businessObject) {
        try {
            if (businessObject == null) {
                throw new RuntimeException("Configuration ERROR: GenericPermissionMaintainable.prepareBusinessObject passed a null object.");
            }
            if (businessObject instanceof PermissionBo) {
                PermissionBo perm = (PermissionBo)this.getBusinessObjectService().findBySinglePrimaryKey(PermissionBo.class, (Object)((PermissionBo)businessObject).getId());
                businessObject = new GenericPermissionBo(perm);
            } else if (businessObject instanceof GenericPermissionBo) {
                PermissionBo perm = (PermissionBo)this.getBusinessObjectService().findBySinglePrimaryKey(PermissionBo.class, (Object)((GenericPermissionBo)businessObject).getId());
                ((GenericPermissionBo)businessObject).loadFromPermission(perm);
            } else {
                throw new RuntimeException("Configuration ERROR: GenericPermissionMaintainable passed an unsupported object type: " + businessObject.getClass());
            }
            if (businessObject instanceof PersistableBusinessObject) {
                this.setBusinessObject((PersistableBusinessObject)businessObject);
            }
            super.prepareBusinessObject(businessObject);
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Exception in prepareBusinessObject()", (Throwable)ex);
            throw ex;
        }
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        return this.sequenceAccessorService;
    }
}

