/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.permission.PermissionTypeService;
import org.kuali.rice.kim.impl.permission.GenericPermissionBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class GenericPermissionMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    protected static final String DETAIL_VALUES_PROPERTY = "detailValues";
    protected static final String NAMESPACE_CODE_PROPERTY = "namespaceCode";
    protected static final String ERROR_MESSAGE_PREFIX = "error.document.kim.genericpermission.";
    protected static final String ERROR_MISSING_TEMPLATE = "error.document.kim.genericpermission.missingtemplate";
    protected static final String ERROR_UNKNOWN_ATTRIBUTE = "error.document.kim.genericpermission.unknownattribute";
    protected static final String ERROR_ATTRIBUTE_VALIDATION = "error.document.kim.genericpermission.attributevalidation";
    protected static final String ERROR_NAMESPACE_AND_NAME_VALIDATION = "error.document.kim.genericpermission.namespaceandnamevalidation";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean rulesPassed = super.processCustomRouteDocumentBusinessRules(document);
        try {
            GenericPermissionBo perm = (GenericPermissionBo)this.getNewBo();
            GenericPermissionBo orgBo = (GenericPermissionBo)this.getOldBo();
            rulesPassed &= this.validateDetailValuesFormat(perm.getDetailValues());
            if (StringUtils.isNotBlank((String)perm.getNamespaceCode()) && StringUtils.isNotBlank((String)perm.getName()) && StringUtils.isBlank((String)perm.getId())) {
                rulesPassed &= this.validateNamespaceCodeAndName(perm.getNamespaceCode(), perm.getName());
            }
            if (StringUtils.isNotBlank((String)perm.getNamespaceCode()) && StringUtils.isNotBlank((String)perm.getName()) && StringUtils.isNotBlank((String)orgBo.getId()) && StringUtils.isNotBlank((String)perm.getId()) && !StringUtils.equals((String)orgBo.getId(), (String)perm.getId())) {
                rulesPassed &= this.validateNamespaceCodeAndName(perm.getNamespaceCode(), perm.getName());
            }
            if (StringUtils.isNotBlank((String)perm.getNamespaceCode()) && StringUtils.isNotBlank((String)perm.getName()) && StringUtils.isNotBlank((String)orgBo.getId()) && StringUtils.isNotBlank((String)perm.getId()) && StringUtils.equals((String)orgBo.getId(), (String)perm.getId()) && (!StringUtils.equals((String)orgBo.getNamespaceCode(), (String)perm.getNamespaceCode()) || !StringUtils.equals((String)orgBo.getName(), (String)perm.getName()))) {
                rulesPassed &= this.validateNamespaceCodeAndName(perm.getNamespaceCode(), perm.getName());
            }
            Template template = null;
            if (StringUtils.isNotBlank((String)perm.getTemplateId())) {
                template = KimApiServiceLocator.getPermissionService().getPermissionTemplate(perm.getTemplateId());
                if (template == null) {
                    GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
                    GlobalVariables.getMessageMap().putError(DETAIL_VALUES_PROPERTY, ERROR_MISSING_TEMPLATE, new String[]{perm.getTemplateId()});
                    GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
                    rulesPassed &= false;
                } else {
                    List validationErrors;
                    PermissionTypeService service;
                    KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(template.getKimTypeId());
                    Map details = perm.getDetails();
                    for (String attributeName : details.keySet()) {
                        if (kimType.getAttributeDefinitionByName(attributeName) != null) continue;
                        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
                        GlobalVariables.getMessageMap().putError(DETAIL_VALUES_PROPERTY, ERROR_UNKNOWN_ATTRIBUTE, new String[]{attributeName, template.getNamespaceCode(), template.getName()});
                        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
                        rulesPassed &= false;
                    }
                    if (!GlobalVariables.getMessageMap().hasErrors() && (service = this.getPermissionTypeService(kimType.getServiceName())) != null && (validationErrors = service.validateAttributes(kimType.getId(), details)) != null && !validationErrors.isEmpty()) {
                        for (RemotableAttributeError error : validationErrors) {
                            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
                            for (String errMsg : error.getErrors()) {
                                GlobalVariables.getMessageMap().putError(DETAIL_VALUES_PROPERTY, ERROR_ATTRIBUTE_VALIDATION, new String[]{error.getAttributeName(), errMsg});
                            }
                            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
                        }
                        rulesPassed &= false;
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Error in processCustomRouteDocumentBusinessRules()", (Throwable)ex);
            throw ex;
        }
        return rulesPassed;
    }

    protected boolean validateDetailValuesFormat(String permissionDetailValues) {
        if (permissionDetailValues != null) {
            String spacesPattern = "[\\s\\t]*";
            Pattern pattern = Pattern.compile(".+=.+");
            permissionDetailValues = permissionDetailValues.replace("\r\n", "\n");
            if (StringUtils.isNotBlank((String)(permissionDetailValues = permissionDetailValues.replace('\r', '\n')))) {
                String[] values;
                for (String attrib : values = permissionDetailValues.split("\n")) {
                    Matcher matcher = pattern.matcher(attrib);
                    if (matcher.matches()) continue;
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.detailValues", "error.invalidFormat", new String[]{"Detail Values", permissionDetailValues});
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean validateNamespaceCodeAndName(String namespaceCode, String name) {
        Permission permission = KimApiServiceLocator.getPermissionService().findPermByNamespaceCodeAndName(namespaceCode, name);
        if (null != permission) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.namespaceCode", ERROR_NAMESPACE_AND_NAME_VALIDATION, new String[]{namespaceCode, name});
            return false;
        }
        return true;
    }

    protected PermissionTypeService getPermissionTypeService(String serviceName) {
        if (StringUtils.isBlank((String)serviceName)) {
            return null;
        }
        try {
            Object service = GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
            if (service == null) {
                LOG.warn((Object)("null returned for permission type service for service name: " + serviceName));
            } else if (!(service instanceof PermissionTypeService)) {
                LOG.warn((Object)("Service " + serviceName + " was not a KimPermissionTypeService.  Was: " + service.getClass().getName()));
                service = null;
            }
            return (PermissionTypeService)service;
        }
        catch (Exception ex) {
            LOG.error((Object)("Error retrieving service: " + serviceName + " from the KimImplServiceLocator."), (Throwable)ex);
            return null;
        }
    }
}

