/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityQueryResults;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.responsibility.ReviewResponsibilityBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ReviewResponsibilityMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    protected static final String ERROR_MESSAGE_PREFIX = "error.document.kim.reviewresponsibility.";
    protected static final String ERROR_DUPLICATE_RESPONSIBILITY = "error.document.kim.reviewresponsibility.duplicateresponsibility";
    protected static final String ERROR_NAMESPACE_AND_NAME_VALIDATION = "error.document.kim.reviewresponsibility.namespaceandnamevalidation";
    protected static final String NAMESPACE_CODE_PROPERTY = "namespaceCode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean rulesPassed = true;
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        try {
            ReviewResponsibilityBo resp = (ReviewResponsibilityBo)document.getNewMaintainableObject().getDataObject();
            if (resp.getDocumentTypeName() != null && resp.getRouteNodeName() != null && !this.checkForDuplicateResponsibility(resp)) {
                GlobalVariables.getMessageMap().putError("documentTypeName", ERROR_DUPLICATE_RESPONSIBILITY, new String[0]);
                rulesPassed &= false;
            }
            if (StringUtils.isNotBlank((String)resp.getNamespaceCode()) && StringUtils.isNotBlank((String)resp.getName()) && StringUtils.isBlank((String)resp.getId())) {
                rulesPassed &= this.validateNamespaceCodeAndName(resp.getNamespaceCode(), resp.getName());
            }
        }
        finally {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        }
        return rulesPassed;
    }

    protected boolean checkForDuplicateResponsibility(ReviewResponsibilityBo resp) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        Predicate p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"template.namespaceCode", (Object)"KR-WKFLW"), PredicateFactory.equal((String)"template.name", (Object)"Review"), PredicateFactory.equal((String)"attributes[documentTypeName]", (Object)resp.getDocumentTypeName())});
        builder.setPredicates(new Predicate[]{p});
        ResponsibilityQueryResults results = KimApiServiceLocator.getResponsibilityService().findResponsibilities(builder.build());
        ArrayList<Responsibility> responsibilities = new ArrayList<Responsibility>();
        if (!results.getResults().isEmpty()) {
            for (Responsibility responsibility : results.getResults()) {
                String routeNodeName = (String)responsibility.getAttributes().get("routeNodeName");
                if (!StringUtils.isNotEmpty((String)routeNodeName) || !StringUtils.equals((String)routeNodeName, (String)resp.getRouteNodeName())) continue;
                responsibilities.add(responsibility);
            }
        }
        return responsibilities.isEmpty();
    }

    protected boolean validateNamespaceCodeAndName(String namespaceCode, String name) {
        Responsibility responsibility = KimApiServiceLocator.getResponsibilityService().findRespByNamespaceCodeAndName(namespaceCode, name);
        if (null != responsibility) {
            GlobalVariables.getMessageMap().putError(NAMESPACE_CODE_PROPERTY, ERROR_NAMESPACE_AND_NAME_VALIDATION, new String[]{namespaceCode, name});
            return false;
        }
        return true;
    }
}

