/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.workflow.attribute.QualifierResolverBase;

public class KimTypeQualifierResolver
extends QualifierResolverBase {
    private static final Logger LOG = Logger.getLogger(KimTypeQualifierResolver.class);
    protected static final String GROUP_ROUTE_LEVEL = "GroupType";
    protected static final String ROLE_ROUTE_LEVEL = "RoleType";
    private static KimTypeInfoService kimTypeInfoService;
    private static GroupService groupService;
    private static RoleService roleService;
    protected static Map<String, KimTypeService> typeServices;

    @Override
    public List<Map<String, String>> resolve(RouteContext context) {
        String routeLevel = context.getNodeInstance().getName();
        Document document = this.getDocument(context);
        ArrayList<Map<String, String>> qualifiers = new ArrayList<Map<String, String>>();
        String customDocTypeName = null;
        if (document instanceof IdentityManagementGroupDocument) {
            customDocTypeName = this.handleGroupDocument(qualifiers, (IdentityManagementGroupDocument)document, routeLevel);
        } else if (document instanceof IdentityManagementRoleDocument) {
            customDocTypeName = this.handleRoleDocument(qualifiers, (IdentityManagementRoleDocument)document, routeLevel);
        } else if (document instanceof IdentityManagementPersonDocument) {
            customDocTypeName = this.handlePersonDocument(qualifiers, (IdentityManagementPersonDocument)document, routeLevel);
        }
        this.decorateWithCommonQualifiers(qualifiers, context, customDocTypeName);
        return qualifiers;
    }

    protected KimTypeService getTypeService(String typeId) {
        KimTypeService typeService = typeServices.get(typeId);
        if (typeService == null) {
            KimType typeInfo = this.getKimTypeInfoService().getKimType(typeId);
            if (typeInfo != null) {
                typeService = KimFrameworkServiceLocator.getKimTypeService((KimType)typeInfo);
                typeServices.put(typeId, typeService);
            } else {
                LOG.warn((Object)("Unable to retrieve KIM Type Info object for id: " + typeId));
            }
        }
        return typeService;
    }

    protected void putMatchingAttributesIntoQualifier(Map<String, String> qualifier, Map<String, String> itemAttributes, List<String> routingAttributes) {
        if (routingAttributes != null && !routingAttributes.isEmpty()) {
            for (String attribName : routingAttributes) {
                qualifier.put(attribName, itemAttributes.get(attribName));
            }
        }
    }

    protected String handleGroupDocument(List<Map<String, String>> qualifiers, IdentityManagementGroupDocument groupDoc, String routeLevel) {
        String typeId = groupDoc.getGroupTypeId();
        qualifiers.add(this.getGroupQualifier(groupDoc.getGroupId(), typeId, groupDoc.getQualifiersAsAttributes(), routeLevel));
        String customDocTypeName = null;
        KimTypeService typeService = this.getTypeService(typeId);
        customDocTypeName = typeService.getWorkflowDocumentTypeName();
        return customDocTypeName;
    }

    protected String handleRoleDocument(List<Map<String, String>> qualifiers, IdentityManagementRoleDocument roleDoc, String routeLevel) {
        String customDocTypeName = null;
        String typeId = roleDoc.getRoleTypeId();
        KimTypeService typeService = this.getTypeService(typeId);
        if (typeService != null) {
            List currentRoleMembers = KimApiServiceLocator.getRoleService().getRoleMembers(Collections.singletonList(roleDoc.getRoleId()), Collections.emptyMap());
            for (KimDocumentRoleMember rm : roleDoc.getMembers()) {
                boolean foundMember = false;
                for (RoleMembership rmi : currentRoleMembers) {
                    if (!rmi.getId().equals(rm.getRoleMemberId())) continue;
                    foundMember = true;
                    if (rm.isActive()) break;
                    qualifiers.add(this.getRoleQualifier(rm.getRoleId(), typeId, typeService, rm.getQualifierAsMap(), routeLevel));
                    break;
                }
                if (foundMember) continue;
                qualifiers.add(this.getRoleQualifier(rm.getRoleId(), typeId, typeService, rm.getQualifierAsMap(), routeLevel));
            }
            customDocTypeName = typeService.getWorkflowDocumentTypeName();
        }
        return customDocTypeName;
    }

    protected String handlePersonDocument(List<Map<String, String>> qualifiers, IdentityManagementPersonDocument personDoc, String routeLevel) {
        block7: {
            block6: {
                String principalId = personDoc.getPrincipalId();
                if (!GROUP_ROUTE_LEVEL.equals(routeLevel)) break block6;
                List currentGroups = KimTypeQualifierResolver.getGroupService().getDirectGroupIdsByPrincipalId(principalId);
                List<PersonDocumentGroup> groups = personDoc.getGroups();
                for (PersonDocumentGroup group : groups) {
                    if (!group.isActive() || currentGroups.contains(group.getGroupId())) continue;
                    Group kimGroup = KimTypeQualifierResolver.getGroupService().getGroup(group.getGroupId());
                    qualifiers.add(this.getGroupQualifier(group.getGroupId(), kimGroup.getKimTypeId(), kimGroup.getAttributes(), routeLevel));
                }
                for (String groupId : currentGroups) {
                    for (PersonDocumentGroup group : groups) {
                        if (group.isActive()) continue;
                        Group kimGroup = KimTypeQualifierResolver.getGroupService().getGroup(groupId);
                        qualifiers.add(this.getGroupQualifier(groupId, kimGroup.getKimTypeId(), kimGroup.getAttributes(), routeLevel));
                    }
                }
                break block7;
            }
            if (!ROLE_ROUTE_LEVEL.equals(routeLevel)) break block7;
            for (PersonDocumentRole pdr : personDoc.getRoles()) {
                KimTypeService typeService = this.getTypeService(pdr.getKimTypeId());
                for (KimDocumentRoleMember rm : pdr.getRolePrncpls()) {
                    boolean foundMember = false;
                    for (RoleMembership rmi : KimTypeQualifierResolver.getRoleService().getRoleMembers(Collections.singletonList(rm.getRoleId()), Collections.emptyMap())) {
                        if (!StringUtils.equals((String)rmi.getId(), (String)rm.getRoleMemberId())) continue;
                        foundMember = true;
                        if (rm.isActive()) break;
                        qualifiers.add(this.getRoleQualifier(rm.getRoleId(), pdr.getKimRoleType().getId(), typeService, rm.getQualifierAsMap(), routeLevel));
                        break;
                    }
                    if (foundMember) continue;
                    qualifiers.add(this.getRoleQualifier(rm.getRoleId(), pdr.getKimRoleType().getId(), typeService, rm.getQualifierAsMap(), routeLevel));
                }
            }
        }
        return null;
    }

    protected Map<String, String> getGroupQualifier(String groupId, String kimTypeId, Map<String, String> groupAttributes, String routeLevel) {
        HashMap<String, String> qualifier = new HashMap<String, String>();
        qualifier.put("id", kimTypeId);
        qualifier.put("qualifierResolverProvidedIdentifier", kimTypeId);
        qualifier.put("id", groupId);
        KimTypeService typeService = this.getTypeService(kimTypeId);
        if (typeService != null) {
            String customDocTypeName = typeService.getWorkflowDocumentTypeName();
            if (StringUtils.isNotBlank((String)customDocTypeName)) {
                qualifier.put("documentTypeName", customDocTypeName);
            }
            this.putMatchingAttributesIntoQualifier(qualifier, groupAttributes, typeService.getWorkflowRoutingAttributes(routeLevel));
        }
        return qualifier;
    }

    protected Map<String, String> getRoleQualifier(String roleId, String kimTypeId, KimTypeService typeService, Map<String, String> roleAttributes, String routeLevel) {
        HashMap<String, String> qualifier = new HashMap<String, String>();
        qualifier.put("id", kimTypeId);
        qualifier.put("qualifierResolverProvidedIdentifier", kimTypeId);
        qualifier.put("roleId", roleId);
        String customDocTypeName = typeService.getWorkflowDocumentTypeName();
        if (StringUtils.isNotBlank((String)customDocTypeName)) {
            qualifier.put("documentTypeName", customDocTypeName);
        }
        this.putMatchingAttributesIntoQualifier(qualifier, roleAttributes, typeService.getWorkflowRoutingAttributes(routeLevel));
        return qualifier;
    }

    public KimTypeInfoService getKimTypeInfoService() {
        if (kimTypeInfoService == null) {
            kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return kimTypeInfoService;
    }

    public static GroupService getGroupService() {
        if (groupService == null) {
            groupService = KimApiServiceLocator.getGroupService();
        }
        return groupService;
    }

    public static RoleService getRoleService() {
        if (roleService == null) {
            roleService = KimApiServiceLocator.getRoleService();
        }
        return roleService;
    }

    static {
        typeServices = new HashMap<String, KimTypeService>();
    }
}

