/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.form;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.web.format.DateDisplayTimestampObjectFormatter;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kns.util.TableRenderUtil;

public class IdentityManagementRoleDocumentForm
extends IdentityManagementDocumentFormBase {
    protected static final long serialVersionUID = 7099079353241080483L;
    protected String delegationMemberRoleMemberId;
    protected String dmrmi;
    protected boolean canAssignRole;
    protected boolean canModifyAssignees;
    protected KimType kimType;
    protected String memberSearchValue;
    protected String id;
    protected KimDocumentRoleMember member;
    protected KimDocumentRolePermission permission;
    protected KimDocumentRoleResponsibility responsibility;
    protected RoleDocumentDelegationMember delegationMember;
    protected String roleId;

    public IdentityManagementRoleDocumentForm() {
        this.requiredNonEditableProperties.add("methodToCall");
        this.requiredNonEditableProperties.add("roleCommand");
        this.canAssignRole = true;
        this.canModifyAssignees = true;
        this.member = new KimDocumentRoleMember();
        this.member.getQualifiers().add(new KimDocumentRoleQualifier());
        this.permission = new KimDocumentRolePermission();
        this.responsibility = new KimDocumentRoleResponsibility();
        this.delegationMember = new RoleDocumentDelegationMember();
        this.delegationMember.getQualifiers().add(new RoleDocumentDelegationMemberQualifier());
        this.setFormatterType("document.members.activeFromDate", DateDisplayTimestampObjectFormatter.class);
        this.setFormatterType("document.delegationMembers.activeFromDate", DateDisplayTimestampObjectFormatter.class);
        this.setFormatterType("document.members.activeToDate", DateDisplayTimestampObjectFormatter.class);
        this.setFormatterType("document.delegationMembers.activeToDate", DateDisplayTimestampObjectFormatter.class);
    }

    public RoleDocumentDelegationMember getDelegationMember() {
        return this.delegationMember;
    }

    public void setDelegationMember(RoleDocumentDelegationMember delegationMember) {
        this.delegationMember = delegationMember;
    }

    public String getDefaultDocumentTypeName() {
        return "IdentityManagementRoleDocument";
    }

    public IdentityManagementRoleDocument getRoleDocument() {
        return (IdentityManagementRoleDocument)this.getDocument();
    }

    public KimDocumentRoleMember getMember() {
        return this.member;
    }

    public void setMember(KimDocumentRoleMember member) {
        this.member = member;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(this.id));
    }

    public KimDocumentRolePermission getPermission() {
        return this.permission;
    }

    public void setPermission(KimDocumentRolePermission permission) {
        this.permission = permission;
    }

    public KimDocumentRoleResponsibility getResponsibility() {
        return this.responsibility;
    }

    public void setResponsibility(KimDocumentRoleResponsibility responsibility) {
        this.responsibility = responsibility;
    }

    public String getMemberFieldConversions() {
        if (this.member == null) {
            return "";
        }
        return this.getMemberFieldConversions(this.member.getMemberTypeCode());
    }

    public String getMemberBusinessObjectName() {
        if (this.member == null) {
            return "";
        }
        return this.getMemberBusinessObjectName(this.member.getMemberTypeCode());
    }

    public String getDelegationMemberFieldConversions() {
        if (this.getDelegationMember() == null) {
            return "";
        }
        String memberTypeCode = this.getDelegationMember().getMemberTypeCode();
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return "principalId:delegationMember.memberId,principalName:delegationMember.memberName";
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return "id:delegationMember.memberId,name:delegationMember.memberName,namespaceCode:delegationMember.memberNamespaceCode";
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return "id:delegationMember.memberId,name:delegationMember.memberName,namespaceCode:delegationMember.memberNamespaceCode";
        }
        return "";
    }

    public String getDelegationMemberBusinessObjectName() {
        if (this.getDelegationMember() == null) {
            return "";
        }
        return this.getMemberBusinessObjectName(this.getDelegationMember().getMemberTypeCode());
    }

    protected String getMemberFieldConversions(String memberTypeCode) {
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return "principalId:member.memberId,principalName:member.memberName";
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return "id:member.memberId,name:member.memberName,namespaceCode:member.memberNamespaceCode";
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return "id:member.memberId,name:member.memberName,namespaceCode:member.memberNamespaceCode";
        }
        return "";
    }

    protected String getMemberBusinessObjectName(String memberTypeCode) {
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return PersonImpl.class.getName();
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return RoleBo.class.getName();
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return GroupBo.class.getName();
        }
        return "";
    }

    public KimType getKimType() {
        return this.kimType;
    }

    public void setKimType(KimType kimType) {
        this.kimType = kimType;
        if (kimType != null && this.getRoleDocument() != null) {
            this.getRoleDocument().setKimType(kimType);
        }
    }

    public boolean isCanAssignRole() {
        return this.canAssignRole;
    }

    public void setCanAssignRole(boolean canAssignRole) {
        this.canAssignRole = canAssignRole;
    }

    public boolean isCanModifyAssignees() {
        return this.canModifyAssignees;
    }

    public void setCanModifyAssignees(boolean canModifyAssignees) {
        this.canModifyAssignees = canModifyAssignees;
    }

    @Override
    public List<KimDocumentRoleMember> getMemberRows() {
        return this.getRoleDocument().getMembers();
    }

    public int getIndexOfRoleMemberFromMemberRows(String roleMemberId) {
        int index = 0;
        for (KimDocumentRoleMember roleMember : this.getMemberRows()) {
            if (StringUtils.equals((String)roleMember.getRoleMemberId(), (String)roleMemberId)) break;
            ++index;
        }
        return index;
    }

    public int getPageNumberOfRoleMemberId(String roleMemberId) {
        if (StringUtils.isEmpty((String)roleMemberId)) {
            return 1;
        }
        int index = this.getIndexOfRoleMemberFromMemberRows(roleMemberId);
        return TableRenderUtil.computeTotalNumberOfPages((int)(index + 1), (int)this.getRecordsPerPage()) - 1;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getDelegationMemberRoleMemberId() {
        return this.delegationMemberRoleMemberId;
    }

    public void setDelegationMemberRoleMemberId(String delegationMemberRoleMemberId) {
        this.delegationMemberRoleMemberId = delegationMemberRoleMemberId;
        this.getDelegationMember().setRoleMemberId(delegationMemberRoleMemberId);
        KimDocumentRoleMember roleMember = this.getRoleDocument().getMember(delegationMemberRoleMemberId);
        if (roleMember != null) {
            this.delegationMember.setRoleMemberId(roleMember.getRoleMemberId());
            this.delegationMember.setRoleMemberName(roleMember.getMemberName());
            this.delegationMember.setRoleMemberNamespaceCode(roleMember.getMemberNamespaceCode());
            for (KimDocumentRoleQualifier roleQualifier : roleMember.getQualifiers()) {
                RoleDocumentDelegationMemberQualifier delegationMemberQualifier = this.getDelegationMember().getQualifier(roleQualifier.getKimAttrDefnId());
                delegationMemberQualifier.setAttrVal(roleQualifier.getAttrVal());
            }
        }
    }

    public String getDmrmi() {
        return this.dmrmi;
    }

    public void setDmrmi(String dmrmi) {
        this.dmrmi = dmrmi;
    }

    public String getMemberSearchValue() {
        return this.memberSearchValue;
    }

    public void setMemberSearchValue(String memberSearchValue) {
        this.memberSearchValue = memberSearchValue;
    }
}

