/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kns.kim.permission.PermissionTypeServiceBase;

public class ViewActionPermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    protected List<String> getRequiredAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(super.getRequiredAttributes());
        attributes.add("viewId");
        return Collections.unmodifiableList(attributes);
    }

    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        String requestedFieldId = null;
        if (requestedDetails.containsKey("fieldId")) {
            requestedFieldId = requestedDetails.get("fieldId");
        }
        String requestedActionEvent = null;
        if (requestedDetails.containsKey("actionEvent")) {
            requestedActionEvent = requestedDetails.get("actionEvent");
        }
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)permission);
            String permissionFieldId = null;
            if (bo.getDetails().containsKey("fieldId")) {
                permissionFieldId = (String)bo.getDetails().get("fieldId");
            }
            String permissionActionEvent = null;
            if (bo.getDetails().containsKey("actionEvent")) {
                permissionActionEvent = (String)bo.getDetails().get("actionEvent");
            }
            if (requestedFieldId != null && permissionFieldId != null && StringUtils.equals((String)requestedFieldId, (String)permissionFieldId)) {
                matchingPermissions.add(permission);
                continue;
            }
            if (requestedActionEvent == null || permissionActionEvent == null || !StringUtils.equals((String)requestedActionEvent, (String)permissionActionEvent)) continue;
            matchingPermissions.add(permission);
        }
        return super.performPermissionMatches(requestedDetails, matchingPermissions);
    }
}

