/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kns.kim.permission.PermissionTypeServiceBase;

public class ViewLineActionPermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    protected List<String> getRequiredAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(super.getRequiredAttributes());
        attributes.add("viewId");
        return Collections.unmodifiableList(attributes);
    }

    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        String requestedGroupId = null;
        if (requestedDetails.containsKey("groupId")) {
            requestedGroupId = requestedDetails.get("groupId");
        }
        String requestedCollectionPropertyName = null;
        if (requestedDetails.containsKey("collectionPropertyName")) {
            requestedCollectionPropertyName = requestedDetails.get("collectionPropertyName");
        }
        String requestedFieldId = null;
        if (requestedDetails.containsKey("fieldId")) {
            requestedFieldId = requestedDetails.get("fieldId");
        }
        String requestedActionEvent = null;
        if (requestedDetails.containsKey("actionEvent")) {
            requestedActionEvent = requestedDetails.get("actionEvent");
        }
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)permission);
            String permissionGroupId = null;
            if (bo.getDetails().containsKey("groupId")) {
                permissionGroupId = (String)bo.getDetails().get("groupId");
            }
            String permissionCollectionPropertyName = null;
            if (bo.getDetails().containsKey("collectionPropertyName")) {
                permissionCollectionPropertyName = (String)bo.getDetails().get("collectionPropertyName");
            }
            String permissionFieldId = null;
            if (bo.getDetails().containsKey("fieldId")) {
                permissionFieldId = (String)bo.getDetails().get("fieldId");
            }
            String permissionActionEvent = null;
            if (bo.getDetails().containsKey("actionEvent")) {
                permissionActionEvent = (String)bo.getDetails().get("actionEvent");
            }
            boolean groupMatch = false;
            if (requestedGroupId != null && permissionGroupId != null && StringUtils.equals((String)requestedGroupId, (String)permissionGroupId)) {
                groupMatch = true;
            } else if (requestedCollectionPropertyName != null && permissionCollectionPropertyName != null && StringUtils.equals((String)requestedCollectionPropertyName, (String)permissionCollectionPropertyName)) {
                groupMatch = true;
            }
            if (!groupMatch) continue;
            if (requestedFieldId != null && permissionFieldId != null && StringUtils.equals((String)requestedFieldId, (String)permissionFieldId)) {
                matchingPermissions.add(permission);
                continue;
            }
            if (requestedActionEvent == null || permissionActionEvent == null || !StringUtils.equals((String)requestedActionEvent, (String)permissionActionEvent)) continue;
            matchingPermissions.add(permission);
        }
        return super.performPermissionMatches(requestedDetails, matchingPermissions);
    }
}

