/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.service.LookupService;

public class LookupServiceImpl
implements LookupService {
    private static final Logger LOG = Logger.getLogger(LookupServiceImpl.class);
    private LookupDao lookupDao;
    private ConfigurationService kualiConfigurationService;

    public <T> Collection<T> findCollectionBySearchUnbounded(Class<T> example, Map<String, String> formProps) {
        return this.findCollectionBySearchHelper(example, formProps, true);
    }

    public <T> Collection<T> findCollectionBySearch(Class<T> example, Map<String, String> formProps) {
        return this.findCollectionBySearchHelper(example, formProps, false);
    }

    public <T> Collection<T> findCollectionBySearchHelper(Class<T> example, Map<String, String> formProps, boolean unbounded) {
        return this.lookupDao.findCollectionBySearchHelper(example, formProps, unbounded, this.allPrimaryKeyValuesPresentAndNotWildcard(example, formProps));
    }

    public <T> T findObjectBySearch(Class<T> example, Map<String, String> formProps) {
        if (example == null || formProps == null) {
            throw new IllegalArgumentException("Object and Map must not be null");
        }
        Object obj = null;
        try {
            obj = example.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get new instance of " + example.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + example.getName(), e);
        }
        return this.lookupDao.findObjectByMap(obj, formProps);
    }

    public boolean allPrimaryKeyValuesPresentAndNotWildcard(Class<?> boClass, Map<String, String> formProps) {
        List pkFields = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(boClass);
        Iterator pkIter = pkFields.iterator();
        boolean returnVal = true;
        block0: while (returnVal && pkIter.hasNext()) {
            String pkName = (String)pkIter.next();
            String pkValue = formProps.get(pkName);
            if (StringUtils.isBlank((String)pkValue)) {
                returnVal = false;
                continue;
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                returnVal = false;
                continue block0;
            }
        }
        return returnVal;
    }

    public LookupDao getLookupDao() {
        return this.lookupDao;
    }

    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

