/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.metadata.EntityDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.core.framework.persistence.jpa.metadata.ObjectDescriptor;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.exception.IntrospectionException;
import org.kuali.rice.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.rice.krad.exception.ReferenceAttributeDoesntExistException;
import org.kuali.rice.krad.exception.ReferenceAttributeNotAnOjbReferenceException;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.impl.PersistenceServiceImplBase;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PersistenceServiceJpaImpl
extends PersistenceServiceImplBase
implements PersistenceService {
    private static Logger LOG = Logger.getLogger(PersistenceServiceJpaImpl.class);
    private PersistenceDao persistenceDao;

    public void setPersistenceDao(PersistenceDao persistenceDao) {
        this.persistenceDao = persistenceDao;
    }

    public boolean allForeignKeyValuesPopulatedForReference(PersistableBusinessObject bo, String referenceName) {
        boolean allFkeysHaveValues = true;
        if (bo == null) {
            throw new IllegalArgumentException("The Class passed in for the BusinessObject argument was null.");
        }
        if (StringUtils.isBlank((String)referenceName)) {
            throw new IllegalArgumentException("The String passed in for the referenceName argument was null or empty.");
        }
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bo, (String)referenceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + referenceName + "' does not exist " + "on class: '" + bo.getClass().getName() + "'.");
        }
        Class<Object> referenceClass = this.getBusinessObjectAttributeClass(bo.getClass(), referenceName);
        if (referenceClass == null) {
            referenceClass = propertyDescriptor.getPropertyType();
        }
        if (!PersistableBusinessObject.class.isAssignableFrom(referenceClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + referenceName + ") is of class: " + "'" + referenceClass.getName() + "' and is not a " + "descendent of BusinessObject.  Only descendents of BusinessObject " + "can be used.");
        }
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor(bo.getClass());
        ObjectDescriptor objectDescriptor = descriptor.getObjectDescriptorByName(referenceName);
        if (objectDescriptor == null) {
            throw new ReferenceAttributeNotAnOjbReferenceException("Attribute requested (" + referenceName + ") is not listed " + "in OJB as a reference-descriptor for class: '" + bo.getClass().getName() + "'");
        }
        List fkFields = objectDescriptor.getForeignKeyFields();
        for (String fkFieldName : fkFields) {
            Object fkFieldValue = null;
            try {
                fkFieldValue = PropertyUtils.getSimpleProperty((Object)bo, (String)fkFieldName);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (fkFieldValue == null) {
                return false;
            }
            if (!String.class.isAssignableFrom(fkFieldValue.getClass()) || !StringUtils.isBlank((String)((String)fkFieldValue))) continue;
            return false;
        }
        return allFkeysHaveValues;
    }

    public void clearCache() {
        this.persistenceDao.clearCache();
    }

    public String getFlattenedPrimaryKeyFieldValues(Object persistableObject) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        Map primaryKeyValues = this.getPrimaryKeyFieldValues(persistableObject, true);
        StringBuffer flattened = new StringBuffer(persistableObject.getClass().getName());
        flattened.append("(");
        Iterator i = primaryKeyValues.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String fieldName = (String)e.getKey();
            Object fieldValue = e.getValue();
            flattened.append(fieldName + "=" + fieldValue);
            if (!i.hasNext()) continue;
            flattened.append(",");
        }
        flattened.append(")");
        return flattened.toString();
    }

    public void linkObjects(Object persistableObject) {
        this.linkObjectsWithCircularReferenceCheck(persistableObject, new HashSet());
    }

    public void loadRepositoryDescriptor(String ojbRepositoryFilePath) {
    }

    public void refreshAllNonUpdatingReferences(PersistableBusinessObject bo) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor(bo.getClass());
        List objectDescriptors = descriptor.getObjectRelationships();
        for (ObjectDescriptor od : objectDescriptors) {
            if (od.getCascade().length != 0) continue;
            this.retrieveReferenceObject(bo, od.getAttributeName());
        }
    }

    public Object resolveProxy(Object o) {
        return this.persistenceDao.resolveProxy(o);
    }

    public void retrieveNonKeyFields(Object persistableObject) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        LOG.debug((Object)("retrieving non-key fields for " + persistableObject));
        this.persistenceDao.retrieveAllReferences(persistableObject);
    }

    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        LOG.debug((Object)("retrieving reference object " + referenceObjectName + " for " + persistableObject));
        this.persistenceDao.retrieveReference(persistableObject, referenceObjectName);
    }

    public void retrieveReferenceObjects(Object persistableObject, List referenceObjectNames) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        if (referenceObjectNames == null) {
            throw new IllegalArgumentException("invalid (null) referenceObjectNames");
        }
        if (referenceObjectNames.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) referenceObjectNames");
        }
        int index = 0;
        for (String referenceObjectName : referenceObjectNames) {
            if (StringUtils.isBlank((String)referenceObjectName)) {
                throw new IllegalArgumentException("invalid (blank) name at position " + index);
            }
            this.retrieveReferenceObject(persistableObject, referenceObjectName);
            ++index;
        }
    }

    public void retrieveReferenceObjects(List persistableObjects, List referenceObjectNames) {
        if (persistableObjects == null) {
            throw new IllegalArgumentException("invalid (null) persistableObjects");
        }
        if (persistableObjects.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) persistableObjects");
        }
        if (referenceObjectNames == null) {
            throw new IllegalArgumentException("invalid (null) referenceObjectNames");
        }
        if (referenceObjectNames.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) referenceObjectNames");
        }
        for (Object persistableObject : persistableObjects) {
            this.retrieveReferenceObjects(persistableObject, referenceObjectNames);
        }
    }

    private void linkObjectsWithCircularReferenceCheck(Object persistableObject, Set referenceSet) {
        if (ObjectUtils.isNull((Object)persistableObject) || referenceSet.contains(persistableObject)) {
            return;
        }
        referenceSet.add(persistableObject);
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor(persistableObject.getClass());
        String className = null;
        String fieldName = null;
        try {
            List objectDescriptors = descriptor.getObjectRelationships();
            for (ObjectDescriptor od : objectDescriptors) {
                className = persistableObject.getClass().getName();
                fieldName = od.getAttributeName();
                Object referenceObject = PropertyUtils.getProperty((Object)persistableObject, (String)fieldName);
                if (ObjectUtils.isNull((Object)referenceObject) || referenceSet.contains(referenceObject)) continue;
                this.linkObjectsWithCircularReferenceCheck(referenceObject, referenceSet);
                List refFkNames = od.getForeignKeyFields();
                EntityDescriptor refCld = MetadataManager.getEntityDescriptor((Class)od.getTargetEntity());
                Set refPkNames = refCld.getPrimaryKeys();
                try {
                    for (String fk : refFkNames) {
                        Field f = referenceObject.getClass().getDeclaredField(fk);
                        f.setAccessible(true);
                        if (!ObjectUtils.isNull((Object)f.get(referenceObject))) continue;
                        Field f2 = persistableObject.getClass().getDeclaredField(fk);
                        f2.setAccessible(true);
                        f.set(referenceObject, f2.get(persistableObject));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IntrospectionException("no setter for property '" + className + "." + fieldName + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionException("problem accessing property '" + className + "." + fieldName + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionException("problem invoking getter for property '" + className + "." + fieldName + "'", e);
        }
    }

    public boolean isProxied(Object object) {
        return this.persistenceDao.isProxied(object);
    }
}

