/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.framework.persistence.jpa.metadata.CollectionDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.EntityDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.FieldDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.JoinColumnDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.core.framework.persistence.jpa.metadata.ObjectDescriptor;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.rice.krad.exception.ReferenceAttributeDoesntExistException;
import org.kuali.rice.krad.exception.ReferenceAttributeNotAnOjbReferenceException;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.service.impl.PersistenceServiceImplBase;
import org.kuali.rice.krad.util.ForeignKeyFieldsPopulationState;

public class PersistenceStructureServiceJpaImpl
extends PersistenceServiceImplBase
implements PersistenceStructureService {
    public static Map<Class, Class> referenceConversionMap = new HashMap<Class, Class>();

    public boolean isPersistable(Class clazz) {
        boolean isPersistable = false;
        if (MetadataManager.getEntityDescriptor((Class)clazz) != null) {
            isPersistable = true;
        }
        return isPersistable;
    }

    public List getPrimaryKeys(Class clazz) {
        ArrayList<String> pkList = new ArrayList<String>();
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)clazz);
        for (FieldDescriptor field : descriptor.getPrimaryKeys()) {
            pkList.add(field.getName());
        }
        return pkList;
    }

    public List listFieldNames(Class clazz) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)clazz);
        for (FieldDescriptor field : descriptor.getFields()) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public Object clearPrimaryKeyFields(Object persistableObject) {
        return persistableObject;
    }

    public List listPersistableSubclasses(Class superclazz) {
        ArrayList persistableSubclasses = new ArrayList();
        return persistableSubclasses;
    }

    public Map<String, DataObjectRelationship> getRelationshipMetadata(Class persistableClass, String attributeName, String attributePrefix) {
        if (persistableClass == null) {
            throw new IllegalArgumentException("invalid (null) persistableClass");
        }
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        HashMap<String, DataObjectRelationship> relationships = new HashMap<String, DataObjectRelationship>();
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)persistableClass);
        for (ObjectDescriptor objectDescriptor : descriptor.getObjectRelationships()) {
            List fks = objectDescriptor.getForeignKeyFields();
            if (!fks.contains(attributeName) && !objectDescriptor.getAttributeName().equals(attributeName)) continue;
            Map fkToPkRefs = this.getForeignKeysForReference(persistableClass, objectDescriptor.getAttributeName());
            DataObjectRelationship rel = new DataObjectRelationship(persistableClass, objectDescriptor.getAttributeName(), objectDescriptor.getTargetEntity());
            for (Map.Entry ref : fkToPkRefs.entrySet()) {
                if (StringUtils.isBlank((String)attributePrefix)) {
                    rel.getParentToChildReferences().put(ref.getKey(), ref.getValue());
                    continue;
                }
                rel.getParentToChildReferences().put(attributePrefix + "." + (String)ref.getKey(), ref.getValue());
            }
            relationships.put(objectDescriptor.getAttributeName(), rel);
        }
        return relationships;
    }

    public Map<String, DataObjectRelationship> getRelationshipMetadata(Class persistableClass, String attributeName) {
        return this.getRelationshipMetadata(persistableClass, attributeName, null);
    }

    public String getForeignKeyFieldName(Class persistableObjectClass, String attributeName, String pkName) {
        String fkName = null;
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)persistableObjectClass);
        ObjectDescriptor objectDescriptor = descriptor.getObjectDescriptorByName(attributeName);
        if (objectDescriptor == null) {
            throw new RuntimeException("Attribute name " + attributeName + " is not a valid reference to class " + persistableObjectClass.getName());
        }
        ArrayList<FieldDescriptor> matches = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor field : descriptor.getFields()) {
            String column = field.getColumn();
            for (JoinColumnDescriptor join : objectDescriptor.getJoinColumnDescriptors()) {
                if (column == null || !column.equals(join.getName())) continue;
                matches.add(field);
            }
        }
        if (matches.size() != 1) {
            throw new RuntimeException("Implement me!");
        }
        fkName = ((FieldDescriptor)matches.get(0)).getName();
        return fkName;
    }

    public Map getReferencesForForeignKey(Class persistableObjectClass, String attributeName) {
        HashMap<String, Class> referenceClasses = new HashMap<String, Class>();
        if (PersistableBusinessObject.class.isAssignableFrom(persistableObjectClass)) {
            EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)persistableObjectClass);
            for (ObjectDescriptor objectDescriptor : descriptor.getObjectRelationships()) {
                List refFkNames = objectDescriptor.getForeignKeyFields();
                for (String fk : refFkNames) {
                    if (!fk.equals(attributeName)) continue;
                    referenceClasses.put(objectDescriptor.getAttributeName(), objectDescriptor.getTargetEntity());
                }
            }
        }
        return referenceClasses;
    }

    public Map getForeignKeysForReference(Class clazz, String attributeName) {
        if (clazz == null) {
            throw new IllegalArgumentException("The Class passed in for the clazz argument was null.");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("The String passed in for the attributeName argument was null.");
        }
        Class<? extends PersistableBusinessObjectExtension> attributeClass = this.getBusinessObjectAttributeClass(clazz, attributeName);
        if (attributeClass == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + attributeName + "' does not exist on class: '" + clazz.getName() + "'.");
        }
        if (!PersistableBusinessObject.class.isAssignableFrom(attributeClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + attributeName + ") is of class: '" + attributeClass.getName() + "' and is not a descendent of BusinessObject.  Only descendents of BusinessObject can be used.");
        }
        return this.determineFkMap(clazz, attributeName, attributeClass);
    }

    private Map determineFkMap(Class clazz, String attributeName, Class attributeClass) {
        HashMap<String, String> fkMap = new HashMap<String, String>();
        EntityDescriptor entityDescriptor = MetadataManager.getEntityDescriptor((Class)clazz);
        ObjectDescriptor objectDescriptor = entityDescriptor.getObjectDescriptorByName(attributeName);
        if (objectDescriptor == null) {
            throw new ReferenceAttributeNotAnOjbReferenceException("Attribute requested (" + attributeName + ") is not defined in JPA annotations for class: '" + clazz.getName() + "'");
        }
        if (!attributeClass.equals(objectDescriptor.getTargetEntity())) {
            if (referenceConversionMap.containsKey(attributeClass)) {
                attributeClass = referenceConversionMap.get(attributeClass);
            } else {
                throw new RuntimeException("The Class of the Java member [" + attributeClass.getName() + "] '" + attributeName + "' does not match the class of the reference [" + objectDescriptor.getTargetEntity().getName() + "]. " + "This is an unhandled special case for which special code needs to be written in this class.");
            }
        }
        List fkFields = objectDescriptor.getForeignKeyFields();
        Iterator fkIterator = fkFields.iterator();
        List pkFields = this.getPrimaryKeys(attributeClass);
        Iterator pkIterator = pkFields.iterator();
        if (pkFields.size() != fkFields.size()) {
            throw new RuntimeException("KualiPersistenceStructureService Error: The number of foreign keys doesnt match the number of primary keys.");
        }
        while (fkIterator.hasNext()) {
            if (!pkIterator.hasNext()) {
                throw new RuntimeException("The number of foriegn keys dont match the number of primary keys for the reference '" + attributeName + "', on BO of type '" + clazz.getName() + "'.  " + "This should never happen under normal circumstances.");
            }
            String fkFieldName = (String)fkIterator.next();
            String pkFieldName = (String)pkIterator.next();
            fkMap.put(fkFieldName, pkFieldName);
        }
        return fkMap;
    }

    public Map<String, String> getInverseForeignKeysForCollection(Class boClass, String collectionName) {
        Object classInstance;
        if (boClass == null) {
            throw new IllegalArgumentException("The Class passed in for the boClass argument was null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("The String passed in for the attributeName argument was null.");
        }
        PropertyDescriptor propertyDescriptor = null;
        try {
            classInstance = boClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor(classInstance, (String)collectionName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + collectionName + "' does not exist " + "on class: '" + boClass.getName() + "'. GFK");
        }
        Class<?> attributeClass = propertyDescriptor.getPropertyType();
        if (!Collection.class.isAssignableFrom(attributeClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + collectionName + ") is of class: " + "'" + attributeClass.getName() + "' and is not a " + "descendent of Collection");
        }
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        CollectionDescriptor cd = descriptor.getCollectionDescriptorByName(collectionName);
        List childPrimaryKeys = cd.getForeignKeyFields();
        List parentForeignKeys = this.getPrimaryKeys(boClass);
        if (parentForeignKeys.size() != childPrimaryKeys.size()) {
            throw new RuntimeException("The number of keys in the class descriptor and the inverse foreign key mapping for the collection descriptors do not match.");
        }
        HashMap<String, String> fkToPkMap = new HashMap<String, String>();
        Iterator pFKIter = parentForeignKeys.iterator();
        Iterator cPKIterator = childPrimaryKeys.iterator();
        while (pFKIter.hasNext()) {
            String parentForeignKey = (String)pFKIter.next();
            String childPrimaryKey = (String)cPKIterator.next();
            fkToPkMap.put(parentForeignKey, childPrimaryKey);
        }
        return fkToPkMap;
    }

    public Map getNestedForeignKeyMap(Class persistableObjectClass) {
        HashMap fkMap = new HashMap();
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)persistableObjectClass);
        for (ObjectDescriptor objectReferenceDescriptor : descriptor.getObjectRelationships()) {
            EntityDescriptor referenceDescriptor = MetadataManager.getEntityDescriptor((Class)objectReferenceDescriptor.getTargetEntity());
            List fkFields = objectReferenceDescriptor.getForeignKeyFields();
            Set pkFields = referenceDescriptor.getPrimaryKeys();
            int i = 0;
            for (FieldDescriptor fd : pkFields) {
                fkMap.put(objectReferenceDescriptor.getAttributeName() + "." + fd.getName(), fkFields.get(i));
                ++i;
            }
        }
        return fkMap;
    }

    public boolean hasPrimaryKeyFieldValues(Object persistableObject) {
        Map keyFields = this.getPrimaryKeyFieldValues(persistableObject);
        boolean emptyField = false;
        Iterator i = keyFields.entrySet().iterator();
        while (!emptyField && i.hasNext()) {
            Map.Entry e = i.next();
            Object fieldValue = e.getValue();
            if (fieldValue == null) {
                emptyField = true;
                continue;
            }
            if (!(fieldValue instanceof String)) continue;
            if (StringUtils.isEmpty((String)((String)fieldValue))) {
                emptyField = true;
                continue;
            }
            emptyField = false;
        }
        return !emptyField;
    }

    public ForeignKeyFieldsPopulationState getForeignKeyFieldsPopulationState(PersistableBusinessObject bo, String referenceName) {
        boolean allFieldsPopulated = true;
        boolean anyFieldsPopulated = false;
        ArrayList<String> unpopulatedFields = new ArrayList<String>();
        if (bo == null) {
            throw new IllegalArgumentException("The Class passed in for the BusinessObject argument was null.");
        }
        if (StringUtils.isBlank((String)referenceName)) {
            throw new IllegalArgumentException("The String passed in for the referenceName argument was null or empty.");
        }
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bo, (String)referenceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + referenceName + "' does not exist " + "on class: '" + bo.getClass().getName() + "'.");
        }
        Class<?> referenceClass = propertyDescriptor.getPropertyType();
        if (!PersistableBusinessObject.class.isAssignableFrom(referenceClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + referenceName + ") is of class: " + "'" + referenceClass.getName() + "' and is not a " + "descendent of BusinessObject.  Only descendents of BusinessObject " + "can be used.");
        }
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor(bo.getClass());
        ObjectDescriptor objectDescriptor = descriptor.getObjectDescriptorByName(referenceName);
        if (objectDescriptor == null) {
            throw new ReferenceAttributeNotAnOjbReferenceException("Attribute requested (" + referenceName + ") is not listed " + "in OJB as a reference-descriptor for class: '" + bo.getClass().getName() + "'");
        }
        List fkFields = objectDescriptor.getForeignKeyFields();
        for (String fkFieldName : fkFields) {
            Object fkFieldValue = null;
            try {
                fkFieldValue = PropertyUtils.getSimpleProperty((Object)bo, (String)fkFieldName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (fkFieldValue == null) {
                allFieldsPopulated = false;
                unpopulatedFields.add(fkFieldName);
                continue;
            }
            if (fkFieldValue instanceof String) {
                if (StringUtils.isBlank((String)((String)fkFieldValue))) {
                    allFieldsPopulated = false;
                    unpopulatedFields.add(fkFieldName);
                    continue;
                }
                anyFieldsPopulated = true;
                continue;
            }
            anyFieldsPopulated = true;
        }
        if (allFieldsPopulated && !unpopulatedFields.isEmpty()) {
            throw new RuntimeException("The flag is set that indicates all fields are populated, but there are fields present in the unpopulatedFields list.  This should never happen, and indicates that the logic in this method is broken.");
        }
        return new ForeignKeyFieldsPopulationState(allFieldsPopulated, anyFieldsPopulated, unpopulatedFields);
    }

    public Map<String, Class> listReferenceObjectFields(Class boClass) {
        if (boClass == null) {
            throw new IllegalArgumentException("Class specified in the parameter was null.");
        }
        if (!PersistableBusinessObject.class.isAssignableFrom(boClass)) {
            throw new IllegalArgumentException("Class specified [" + boClass.getName() + "] must be a class that " + "inherits from BusinessObject.");
        }
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        HashMap<String, Class> references = new HashMap<String, Class>();
        for (ObjectDescriptor od : descriptor.getObjectRelationships()) {
            references.put(od.getAttributeName(), od.getTargetEntity());
        }
        return references;
    }

    public Map<String, Class> listCollectionObjectTypes(Class boClass) {
        if (boClass == null) {
            throw new IllegalArgumentException("Class specified in the parameter was null.");
        }
        HashMap<String, Class> references = new HashMap<String, Class>();
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        if (descriptor == null) {
            return references;
        }
        for (CollectionDescriptor cd : descriptor.getCollectionRelationships()) {
            references.put(cd.getAttributeName(), cd.getTargetEntity());
        }
        return references;
    }

    public Map<String, Class> listCollectionObjectTypes(PersistableBusinessObject bo) {
        if (bo == null) {
            throw new IllegalArgumentException("BO specified in the parameter was null.");
        }
        if (!(bo instanceof PersistableBusinessObject)) {
            throw new IllegalArgumentException("BO specified [" + bo.getClass().getName() + "] must be a class that " + "inherits from BusinessObject.");
        }
        return this.listCollectionObjectTypes(bo.getClass());
    }

    public Map<String, Class> listReferenceObjectFields(PersistableBusinessObject bo) {
        if (bo == null) {
            throw new IllegalArgumentException("BO specified in the parameter was null.");
        }
        if (!(bo instanceof PersistableBusinessObject)) {
            throw new IllegalArgumentException("BO specified [" + bo.getClass().getName() + "] must be a class that " + "inherits from BusinessObject.");
        }
        return this.listReferenceObjectFields(bo.getClass());
    }

    public boolean isReferenceUpdatable(Class boClass, String referenceName) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        return descriptor.getObjectDescriptorByName(referenceName).isUpdateable();
    }

    public boolean isCollectionUpdatable(Class boClass, String collectionName) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        return descriptor.getCollectionDescriptorByName(collectionName).isUpdateable();
    }

    public boolean hasCollection(Class boClass, String collectionName) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        return descriptor.getCollectionDescriptorByName(collectionName) != null;
    }

    public boolean hasReference(Class boClass, String referenceName) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor((Class)boClass);
        return descriptor.getObjectDescriptorByName(referenceName) != null;
    }

    public String getTableName(Class<? extends PersistableBusinessObject> boClass) {
        EntityDescriptor descriptor = MetadataManager.getEntityDescriptor(boClass);
        return descriptor.getTable();
    }
}

