/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.OptimisticLockException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.exception.PessimisticLockingException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PessimisticLockServiceImpl
implements PessimisticLockService {
    private static final Logger LOG = Logger.getLogger(PessimisticLockServiceImpl.class);
    private PersonService personService;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private PermissionService permissionService;

    public void delete(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("An invalid blank id was passed to delete a Pessimistic Lock.");
        }
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", Long.valueOf(id));
        PessimisticLock lock = (PessimisticLock)this.getBusinessObjectService().findByPrimaryKey(PessimisticLock.class, primaryKeys);
        if (ObjectUtils.isNull((Object)lock)) {
            throw new IllegalArgumentException("Pessimistic Lock with id " + id + " cannot be found in the database.");
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!lock.isOwnedByUser(user) && !this.isPessimisticLockAdminUser(user)) {
            throw new AuthorizationException(user.getName(), "delete", "Pessimistick Lock (id " + id + ")");
        }
        this.delete(lock);
    }

    private void delete(PessimisticLock lock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting lock: " + lock));
        }
        this.getBusinessObjectService().delete((PersistableBusinessObject)lock);
    }

    public PessimisticLock generateNewLock(String documentNumber) {
        return this.generateNewLock(documentNumber, GlobalVariables.getUserSession().getPerson());
    }

    public PessimisticLock generateNewLock(String documentNumber, String lockDescriptor) {
        return this.generateNewLock(documentNumber, lockDescriptor, GlobalVariables.getUserSession().getPerson());
    }

    public PessimisticLock generateNewLock(String documentNumber, Person user) {
        return this.generateNewLock(documentNumber, PessimisticLock.DEFAULT_LOCK_DESCRIPTOR, user);
    }

    public PessimisticLock generateNewLock(String documentNumber, String lockDescriptor, Person user) {
        PessimisticLock lock = new PessimisticLock(documentNumber, lockDescriptor, user, GlobalVariables.getUserSession());
        lock = this.save(lock);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated new lock: " + lock));
        }
        return lock;
    }

    public List<PessimisticLock> getPessimisticLocksForDocument(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        return (List)this.getBusinessObjectService().findMatching(PessimisticLock.class, fieldValues);
    }

    public List<PessimisticLock> getPessimisticLocksForSession(String sessionId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("sessionId", sessionId);
        return (List)this.getBusinessObjectService().findMatching(PessimisticLock.class, fieldValues);
    }

    public boolean isPessimisticLockAdminUser(Person user) {
        return this.getPermissionService().isAuthorized(user.getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap());
    }

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user)) continue;
            try {
                this.delete(lock);
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof OptimisticLockException) {
                    LOG.warn((Object)("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber()));
                    continue;
                }
                throw ex;
            }
        }
    }

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user, String lockDescriptor) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user) || !lockDescriptor.equals(lock.getLockDescriptor())) continue;
            try {
                this.delete(lock);
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof OptimisticLockException) {
                    LOG.warn((Object)("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber()));
                    continue;
                }
                throw ex;
            }
        }
    }

    public PessimisticLock save(PessimisticLock lock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving lock: " + lock));
        }
        return (PessimisticLock)this.getBusinessObjectService().save((PersistableBusinessObject)lock);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public Set getDocumentActions(Document document, Person user, Set<String> documentActions) {
        if (documentActions.contains("canCancel") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canCancel");
        }
        if (documentActions.contains("canSave") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canSave");
        }
        if (documentActions.contains("canRoute") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canRoute");
        }
        if (documentActions.contains("canBlanketApprove") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canBlanketApprove");
        }
        return documentActions;
    }

    protected boolean hasPreRouteEditAuthorization(Document document, Person user) {
        if (document.getPessimisticLocks().isEmpty()) {
            return true;
        }
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!lock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }

    protected boolean usesPessimisticLocking(Document document) {
        return this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking();
    }

    public void establishWorkflowPessimisticLocking(Document document) {
        PessimisticLock lock = this.createNewPessimisticLock(document, new HashMap(), this.getWorkflowPessimisticLockOwnerUser());
        document.addPessimisticLock(lock);
    }

    public void releaseWorkflowPessimisticLocking(Document document) {
        this.releaseAllLocksForUser(document.getPessimisticLocks(), this.getWorkflowPessimisticLockOwnerUser());
        document.refreshPessimisticLocks();
    }

    protected Person getWorkflowPessimisticLockOwnerUser() {
        String networkId = "kr";
        return this.getPersonService().getPersonByPrincipalName(networkId);
    }

    public Map establishLocks(Document document, Map editMode, Person user) {
        String customLockDescriptor;
        Map editModeMap = new HashMap();
        ArrayList<String> givenUserLockDescriptors = new ArrayList<String>();
        HashMap lockDescriptorUsers = new HashMap();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(user)) {
                givenUserLockDescriptors.add(lock.getLockDescriptor());
                continue;
            }
            if (!lockDescriptorUsers.containsKey(lock.getLockDescriptor())) {
                lockDescriptorUsers.put(lock.getLockDescriptor(), new HashSet());
            }
            ((Set)lockDescriptorUsers.get(lock.getLockDescriptor())).add(lock.getOwnedByUser());
        }
        for (String givenUserLockDescriptor : givenUserLockDescriptors) {
            Set users;
            if (!lockDescriptorUsers.containsKey(givenUserLockDescriptor) || ((Set)lockDescriptorUsers.get(givenUserLockDescriptor)).size() <= 0 || (users = (Set)lockDescriptorUsers.get(givenUserLockDescriptor)).size() == 1 && this.getWorkflowPessimisticLockOwnerUser().getPrincipalId().equals(((Person)users.iterator().next()).getPrincipalId())) continue;
            String descriptorText = document.useCustomLockDescriptors() ? " using lock descriptor '" + givenUserLockDescriptor + "'" : "";
            String errorMsg = "Found an invalid lock status on document number " + document.getDocumentNumber() + "with current user and other user both having locks" + descriptorText + " concurrently";
            LOG.debug((Object)errorMsg);
            throw new PessimisticLockingException(errorMsg);
        }
        if (givenUserLockDescriptors.isEmpty()) {
            if (lockDescriptorUsers.isEmpty()) {
                if (this.isLockRequiredByUser(document, editMode, user)) {
                    document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                }
                editModeMap.putAll(editMode);
            } else if (document.useCustomLockDescriptors()) {
                customLockDescriptor = document.getCustomLockDescriptor(user);
                if (lockDescriptorUsers.containsKey(customLockDescriptor)) {
                    editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
                } else {
                    if (this.isLockRequiredByUser(document, editMode, user)) {
                        document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                    }
                    editModeMap.putAll(editMode);
                }
            } else {
                editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
            }
        } else if (document.useCustomLockDescriptors()) {
            customLockDescriptor = document.getCustomLockDescriptor(user);
            if (givenUserLockDescriptors.contains(customLockDescriptor)) {
                editModeMap.putAll(editMode);
            } else if (lockDescriptorUsers.containsKey(customLockDescriptor)) {
                editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
            } else {
                if (this.isLockRequiredByUser(document, editMode, user)) {
                    document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                }
                editModeMap.putAll(editMode);
            }
        } else {
            editModeMap.putAll(editMode);
        }
        return editModeMap;
    }

    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry)) continue;
            return true;
        }
        return false;
    }

    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : currentEditMode.entrySet()) {
            if (this.isEntryEditMode(entry)) {
                editModeMap.putAll(this.getEntryEditModeReplacementMode(entry));
                continue;
            }
            editModeMap.put(entry.getKey(), entry.getValue());
        }
        return editModeMap;
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return StringUtils.equalsIgnoreCase((String)"true", (String)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEntryEditModeReplacementMode(Map.Entry entry) {
        HashMap<String, String> editMode = new HashMap<String, String>();
        editMode.put("viewOnly", "true");
        return editMode;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            return this.generateNewLock(document.getDocumentNumber(), document.getCustomLockDescriptor(user), user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }
}

