/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewTypeService;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.springframework.beans.PropertyValues;

public class MaintenanceViewTypeServiceImpl
implements ViewTypeService {
    private DocumentService documentService;
    private DocumentDictionaryService documentDictionaryService;

    public UifConstants.ViewType getViewTypeName() {
        return UifConstants.ViewType.MAINTENANCE;
    }

    public Map<String, String> getParametersFromViewConfiguration(PropertyValues propertyValues) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String viewName = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, (String)"viewName");
        String dataObjectClassName = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, (String)"dataObjectClassName");
        parameters.put("viewName", viewName);
        parameters.put("dataObjectClassName", dataObjectClassName);
        return parameters;
    }

    public Map<String, String> getParametersFromRequest(Map<String, String> requestParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (requestParameters.containsKey("viewName")) {
            parameters.put("viewName", requestParameters.get("viewName"));
        } else {
            parameters.put("viewName", "default");
        }
        if (requestParameters.containsKey("dataObjectClassName")) {
            parameters.put("dataObjectClassName", requestParameters.get("dataObjectClassName"));
        } else if (requestParameters.containsKey("docId")) {
            String documentNumber = requestParameters.get("docId");
            boolean objectClassFound = false;
            try {
                Document document = this.documentService.getByDocumentHeaderId(documentNumber);
                if (!this.documentService.documentExists(documentNumber)) {
                    parameters = new HashMap();
                    parameters.put("viewId", "InitiatedDocumentView");
                    return parameters;
                }
                if (document != null) {
                    String docTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
                    Class objectClassName = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(docTypeName);
                    if (objectClassName != null) {
                        objectClassFound = true;
                        parameters.put("dataObjectClassName", objectClassName.getName());
                    }
                }
                if (!objectClassFound) {
                    throw new RuntimeException("Could not determine object class for maintenance document with id: " + documentNumber);
                }
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Encountered workflow exception while retrieving document with id: " + documentNumber, e);
            }
        }
        return parameters;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

