/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kcb.util.BeanFactoryInvocationHandler;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;

public class BeanFactoryInvocationHandlerTest {
    private BadInterface bad;

    @Before
    public void createBadInstance() {
        StaticListableBeanFactory bf = new StaticListableBeanFactory();
        bf.addBean("bean", (Object)"This is a bean");
        this.bad = (BadInterface)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{BadInterface.class}, (InvocationHandler)new BeanFactoryInvocationHandler((BeanFactory)bf));
    }

    @Test(expected=RuntimeException.class)
    public void testRandomMethod() {
        int result = this.bad.add(2, 2);
    }

    @Test(expected=RuntimeException.class)
    public void testNotAGetter() {
        this.bad.notAGetter();
    }

    @Test(expected=RuntimeException.class)
    public void testAnotherBadGetter() {
        this.bad.get();
    }

    @Test
    public void testGoodGetter() {
        Assert.assertEquals((Object)"This is a bean", (Object)this.bad.getBean());
    }

    private static interface BadInterface {
        public int add(int var1, int var2);

        public void notAGetter();

        public void get();

        public Object getBean();
    }
}

