/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.ken.api.notification.NotificationListRecipient;
import org.kuali.rice.ken.api.notification.NotificationListRecipientContract;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREN_RECIP_LIST_T")
public class NotificationRecipientListBo
extends PersistableBusinessObjectBase
implements NotificationListRecipientContract {
    @Id
    @GeneratedValue(generator="KREN_RECIP_LIST_S")
    @GenericGenerator(name="KREN_RECIP_LIST_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREN_RECIP_LIST_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RECIP_LIST_ID")
    private Long id;
    @Column(name="RECIP_TYP_CD", nullable=false)
    private String recipientType;
    @Column(name="RECIP_ID", nullable=false)
    private String recipientId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinColumn(name="CHNL_ID", insertable=false, updatable=false)
    private NotificationChannelBo channel;

    public NotificationChannelBo getChannel() {
        return this.channel;
    }

    public void setChannel(NotificationChannelBo channel) {
        this.channel = channel;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public String getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(String recipientType) {
        this.recipientType = recipientType;
    }

    public static NotificationListRecipient to(NotificationRecipientListBo bo) {
        if (bo == null) {
            return null;
        }
        return NotificationListRecipient.Builder.create((NotificationListRecipientContract)bo).build();
    }

    public static NotificationRecipientListBo from(NotificationListRecipient im) {
        if (im == null) {
            return null;
        }
        NotificationRecipientListBo bo = new NotificationRecipientListBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setRecipientType(im.getRecipientType());
        bo.setRecipientId(im.getRecipientId());
        bo.setChannel(im.getChannel() == null ? null : NotificationChannelBo.from(im.getChannel()));
        return bo;
    }
}

