/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.dao.GenericDao;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.document.kew.NotificationWorkflowDocument;
import org.kuali.rice.ken.exception.ErrorList;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.ken.web.spring.BaseSendNotificationController;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.rule.GenericAttributeContent;
import org.kuali.rice.kim.api.KimConstants;
import org.springframework.web.servlet.ModelAndView;

public class SendEventNotificationMessageController
extends BaseSendNotificationController {
    private static final Logger LOG = Logger.getLogger(SendEventNotificationMessageController.class);
    private static final String NONE_CHANNEL = "___NONE___";
    private static final long REASONABLE_IMMEDIATE_TIME_THRESHOLD = 300000L;
    protected NotificationService notificationService;
    protected NotificationWorkflowDocumentService notificationWorkflowDocService;
    protected NotificationChannelService notificationChannelService;
    protected NotificationRecipientService notificationRecipientService;
    protected NotificationMessageContentService messageContentService;
    protected GenericDao businessObjectDao;

    private boolean timeIsInTheFuture(long time) {
        boolean future = time - System.currentTimeMillis() > 300000L;
        LOG.info((Object)("Time: " + new Date(time) + " is in the future? " + future));
        return future;
    }

    private boolean hasPotentialRecipients(NotificationBo notification) {
        LOG.info((Object)("notification channel " + (Object)((Object)notification.getChannel()) + " is subscribable: " + notification.getChannel().isSubscribable()));
        return notification.getChannel().getRecipientLists().size() > 0 || notification.getChannel().getSubscriptions().size() > 0 || notification.getChannel().isSubscribable() && this.timeIsInTheFuture(notification.getSendDateTimeValue().getTime());
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNotificationWorkflowDocumentService(NotificationWorkflowDocumentService s) {
        this.notificationWorkflowDocService = s;
    }

    public void setNotificationChannelService(NotificationChannelService notificationChannelService) {
        this.notificationChannelService = notificationChannelService;
    }

    public void setNotificationRecipientService(NotificationRecipientService notificationRecipientService) {
        this.notificationRecipientService = notificationRecipientService;
    }

    public void setMessageContentService(NotificationMessageContentService notificationMessageContentService) {
        this.messageContentService = notificationMessageContentService;
    }

    public void setBusinessObjectDao(GenericDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    public ModelAndView sendEventNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "SendEventNotificationMessage";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        Map<String, Object> model = this.setupModelForSendEventNotification(request);
        model.put("errors", new ErrorList());
        return new ModelAndView(view, model);
    }

    private Map<String, Object> setupModelForSendEventNotification(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("defaultSender", request.getRemoteUser());
        model.put("channels", this.notificationChannelService.getAllNotificationChannels());
        model.put("priorities", this.businessObjectDao.findAll(NotificationPriorityBo.class));
        String sendDateTime = request.getParameter("sendDateTime");
        String currentDateTime = Util.getCurrentDateTime();
        if (StringUtils.isEmpty((String)sendDateTime)) {
            sendDateTime = currentDateTime;
        }
        model.put("sendDateTime", sendDateTime);
        if (request.getParameter("originalDateTime") == null) {
            model.put("originalDateTime", currentDateTime);
        } else {
            model.put("originalDateTime", request.getParameter("originalDateTime"));
        }
        model.put("summary", request.getParameter("summary"));
        model.put("description", request.getParameter("description"));
        model.put("location", request.getParameter("location"));
        model.put("startDateTime", request.getParameter("startDateTime"));
        model.put("stopDateTime", request.getParameter("stopDateTime"));
        model.put("userRecipients", request.getParameter("userRecipients"));
        model.put("workgroupRecipients", request.getParameter("workgroupRecipients"));
        model.put("workgroupNamespaceCodes", request.getParameter("workgroupNamespaceCodes"));
        return model;
    }

    public ModelAndView submitEventNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view;
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        String initiatorId = this.getPrincipalIdFromIdOrName(request.getRemoteUser());
        LOG.debug((Object)("initiatorId=" + initiatorId));
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            WorkflowDocument document = NotificationWorkflowDocument.createNotificationDocument(initiatorId, "SendNotificationRequest");
            NotificationBo notification = this.populateNotificationInstance(request, model);
            String notificationAsXml = this.messageContentService.generateNotificationMessage(notification);
            HashMap<String, String> attrFields = new HashMap<String, String>();
            List<NotificationChannelReviewerBo> reviewers = notification.getChannel().getReviewers();
            int ui = 0;
            int gi = 0;
            for (NotificationChannelReviewerBo reviewer : reviewers) {
                int index;
                String prefix;
                if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.equals((Object)reviewer.getReviewerType())) {
                    prefix = "user";
                    index = ui++;
                } else if (KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.equals((Object)reviewer.getReviewerType())) {
                    prefix = "group";
                    index = gi++;
                } else {
                    LOG.error((Object)("Invalid type for reviewer " + reviewer.getReviewerId() + ": " + reviewer.getReviewerType()));
                    continue;
                }
                attrFields.put(prefix + index, reviewer.getReviewerId());
            }
            GenericAttributeContent gac = new GenericAttributeContent("channelReviewers");
            document.setApplicationContent(notificationAsXml);
            document.setAttributeContent("<attributeContent>" + gac.generateContent(attrFields) + "</attributeContent>");
            document.setTitle(notification.getTitle());
            document.route("This message was submitted via the event notification message submission form by user " + initiatorId);
            view = "SendEventNotificationMessage";
            ErrorList el = new ErrorList();
            el.addError("Notification(s) sent.");
            model.put("errors", el);
        }
        catch (ErrorList el) {
            Map<String, Object> model2 = this.setupModelForSendEventNotification(request);
            model.putAll(model2);
            model.put("errors", el);
            view = "SendEventNotificationMessage";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ModelAndView(view, model);
    }

    private NotificationBo populateNotificationInstance(HttpServletRequest request, Map<String, Object> model) throws IllegalArgumentException, ErrorList {
        ErrorList errors = new ErrorList();
        NotificationBo notification = new NotificationBo();
        String channelName = request.getParameter("channelName");
        if (StringUtils.isEmpty((String)channelName) || StringUtils.equals((String)channelName, (String)NONE_CHANNEL)) {
            errors.addError("You must choose a channel.");
        } else {
            model.put("channelName", channelName);
        }
        String priorityName = request.getParameter("priorityName");
        if (StringUtils.isEmpty((String)priorityName)) {
            errors.addError("You must choose a priority.");
        } else {
            model.put("priorityName", priorityName);
        }
        String senderNames = request.getParameter("senderNames");
        String[] senders = null;
        if (StringUtils.isEmpty((String)senderNames)) {
            errors.addError("You must enter at least one sender.");
        } else {
            senders = StringUtils.split((String)senderNames, (String)",");
            model.put("senderNames", senderNames);
        }
        String deliveryType = request.getParameter("deliveryType");
        if (StringUtils.isEmpty((String)deliveryType)) {
            errors.addError("You must choose a type.");
        } else {
            deliveryType = deliveryType.equalsIgnoreCase("FYI") ? "FYI" : "ACK";
            model.put("deliveryType", deliveryType);
        }
        String originalDateTime = request.getParameter("originalDateTime");
        Date origdate = null;
        Date senddate = null;
        Date removedate = null;
        try {
            origdate = Util.parseUIDateTime(originalDateTime);
        }
        catch (ParseException pe) {
            errors.addError("Original date is invalid.");
        }
        String sendDateTime = request.getParameter("sendDateTime");
        if (StringUtils.isBlank((String)sendDateTime)) {
            sendDateTime = Util.getCurrentDateTime();
        }
        try {
            senddate = Util.parseUIDateTime(sendDateTime);
        }
        catch (ParseException pe) {
            errors.addError("You specified an invalid Send Date/Time.  Please use the calendar picker.");
        }
        if (senddate != null && senddate.before(origdate)) {
            errors.addError("Send Date/Time cannot be in the past.");
        }
        model.put("sendDateTime", sendDateTime);
        String autoRemoveDateTime = request.getParameter("autoRemoveDateTime");
        if (StringUtils.isNotBlank((String)autoRemoveDateTime)) {
            try {
                removedate = Util.parseUIDateTime(autoRemoveDateTime);
            }
            catch (ParseException pe) {
                errors.addError("You specified an invalid Auto-Remove Date/Time.  Please use the calendar picker.");
            }
            if (removedate != null) {
                if (removedate.before(origdate)) {
                    errors.addError("Auto-Remove Date/Time cannot be in the past.");
                } else if (senddate != null && removedate.before(senddate)) {
                    errors.addError("Auto-Remove Date/Time cannot be before the Send Date/Time.");
                }
            }
        }
        model.put("autoRemoveDateTime", autoRemoveDateTime);
        String[] userRecipients = this.parseUserRecipients(request);
        String[] workgroupRecipients = this.parseWorkgroupRecipients(request);
        String[] workgroupNamespaceCodes = this.parseWorkgroupNamespaceCodes(request);
        String title = request.getParameter("title");
        if (!StringUtils.isEmpty((String)title)) {
            model.put("title", title);
        } else {
            errors.addError("You must fill in a title");
        }
        String message = request.getParameter("message");
        if (StringUtils.isEmpty((String)message)) {
            errors.addError("You must fill in a message.");
        } else {
            model.put("message", message);
        }
        String startDateTime = request.getParameter("startDateTime");
        if (StringUtils.isEmpty((String)startDateTime)) {
            errors.addError("You must fill in a start date/time.");
        } else {
            model.put("startDateTime", startDateTime);
        }
        String stopDateTime = request.getParameter("stopDateTime");
        if (StringUtils.isEmpty((String)stopDateTime)) {
            errors.addError("You must fill in a stop date/time.");
        } else {
            model.put("stopDateTime", stopDateTime);
        }
        String summary = request.getParameter("summary");
        if (StringUtils.isEmpty((String)summary)) {
            errors.addError("You must fill in a summary.");
        } else {
            model.put("summary", summary);
        }
        String description = request.getParameter("description");
        if (StringUtils.isEmpty((String)description)) {
            errors.addError("You must fill in a description.");
        } else {
            model.put("description", description);
        }
        String location = request.getParameter("location");
        if (StringUtils.isEmpty((String)location)) {
            errors.addError("You must fill in a location.");
        } else {
            model.put("location", location);
        }
        if (errors.getErrors().size() > 0) {
            throw errors;
        }
        NotificationChannelBo channel = (NotificationChannelBo)((Object)Util.retrieveFieldReference("channel", "name", channelName, NotificationChannelBo.class, this.businessObjectDao));
        notification.setChannel(channel);
        NotificationPriorityBo priority = (NotificationPriorityBo)((Object)Util.retrieveFieldReference("priority", "name", priorityName, NotificationPriorityBo.class, this.businessObjectDao));
        notification.setPriority(priority);
        NotificationContentTypeBo contentType = (NotificationContentTypeBo)((Object)Util.retrieveFieldReference("contentType", "name", "Event", NotificationContentTypeBo.class, this.businessObjectDao));
        notification.setContentType(contentType);
        NotificationProducerBo producer = (NotificationProducerBo)((Object)Util.retrieveFieldReference("producer", "name", "Notification System", NotificationProducerBo.class, this.businessObjectDao));
        notification.setProducer(producer);
        for (String senderName : senders) {
            if (StringUtils.isEmpty((String)senderName)) {
                errors.addError("A sender's name cannot be blank.");
                continue;
            }
            NotificationSenderBo ns = new NotificationSenderBo();
            ns.setSenderName(senderName.trim());
            notification.addSender(ns);
        }
        boolean recipientsExist = false;
        if (userRecipients != null && userRecipients.length > 0) {
            recipientsExist = true;
            for (String userRecipientId : userRecipients) {
                if (!this.isUserRecipientValid(userRecipientId, errors)) continue;
                NotificationRecipientBo recipient = new NotificationRecipientBo();
                recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
                recipient.setRecipientId(userRecipientId);
                notification.addRecipient(recipient);
            }
        }
        if (workgroupRecipients != null && workgroupRecipients.length > 0) {
            recipientsExist = true;
            if (workgroupNamespaceCodes != null && workgroupNamespaceCodes.length > 0) {
                if (workgroupNamespaceCodes.length == workgroupRecipients.length) {
                    for (int i = 0; i < workgroupRecipients.length; ++i) {
                        if (!this.isWorkgroupRecipientValid(workgroupRecipients[i], workgroupNamespaceCodes[i], errors)) continue;
                        NotificationRecipientBo recipient = new NotificationRecipientBo();
                        recipient.setRecipientType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
                        recipient.setRecipientId(SendEventNotificationMessageController.getGroupService().getGroupByNamespaceCodeAndName(workgroupNamespaceCodes[i], workgroupRecipients[i]).getId());
                        notification.addRecipient(recipient);
                    }
                } else {
                    errors.addError("The number of groups must match the number of namespace codes");
                }
            } else {
                errors.addError("You must specify a namespace code for every group name");
            }
        } else if (workgroupNamespaceCodes != null && workgroupNamespaceCodes.length > 0) {
            errors.addError("You must specify a group name for every namespace code");
        }
        if (errors.getErrors().size() > 0) {
            throw errors;
        }
        notification.setTitle(title);
        notification.setDeliveryType(deliveryType);
        Date startDate = null;
        Date stopDate = null;
        Date d = null;
        if (StringUtils.isNotBlank((String)sendDateTime)) {
            try {
                d = Util.parseUIDateTime(sendDateTime);
            }
            catch (ParseException pe) {
                errors.addError("You specified an invalid send date and time.  Please use the calendar picker.");
            }
            notification.setSendDateTimeValue(new Timestamp(d.getTime()));
        }
        Date d2 = null;
        if (StringUtils.isNotBlank((String)autoRemoveDateTime)) {
            try {
                d2 = Util.parseUIDateTime(autoRemoveDateTime);
                if (d2.before(d)) {
                    errors.addError("Auto Remove Date/Time cannot be before Send Date/Time.");
                }
            }
            catch (ParseException pe) {
                errors.addError("You specified an invalid auto-remove date and time.  Please use the calendar picker.");
            }
            notification.setAutoRemoveDateTimeValue(new Timestamp(d2.getTime()));
        }
        if (StringUtils.isNotBlank((String)startDateTime)) {
            try {
                startDate = Util.parseUIDateTime(startDateTime);
            }
            catch (ParseException pe) {
                errors.addError("You specified an invalid start date and time.  Please use the calendar picker.");
            }
        }
        if (StringUtils.isNotBlank((String)stopDateTime)) {
            try {
                stopDate = Util.parseUIDateTime(stopDateTime);
            }
            catch (ParseException pe) {
                errors.addError("You specified an invalid stop date and time.  Please use the calendar picker.");
            }
        }
        if (stopDate != null && startDate != null && stopDate.before(startDate)) {
            errors.addError("Event Stop Date/Time cannot be before Event Start Date/Time.");
        }
        if (!recipientsExist && !this.hasPotentialRecipients(notification)) {
            errors.addError("You must specify at least one user or group recipient.");
        }
        if (errors.getErrors().size() > 0) {
            throw errors;
        }
        notification.setContent("<content xmlns=\"ns:notification/ContentTypeEvent\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeEvent resource:notification/ContentTypeEvent\"><message><![CDATA[" + message + "]]></message>" + "<event>\n" + "  <summary>" + summary + "</summary>\n" + "  <description>" + description + "</description>\n" + "  <location>" + location + "</location>\n" + "  <startDateTime>" + Util.toUIDateTimeString(startDate) + "</startDateTime>\n" + "  <stopDateTime>" + Util.toUIDateTimeString(stopDate) + "</stopDateTime>\n" + "</event>" + "</content>");
        return notification;
    }
}

