/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class UserPreferencesController
extends MultiActionController {
    private static String view = "";
    private static final Logger LOG = Logger.getLogger(UserPreferencesController.class);
    protected NotificationChannelService notificationChannelService;
    protected UserPreferenceService userPreferenceService;
    protected Object notificationMessageDelivererRegistryService;

    public void setNotificationChannelService(NotificationChannelService notificationChannelService) {
        this.notificationChannelService = notificationChannelService;
    }

    public void setUserPreferenceService(UserPreferenceService userPreferenceService) {
        this.userPreferenceService = userPreferenceService;
    }

    public void setNotificationMessageDelivererRegistryService(Object notificationMessageDelivererRegistryService) {
        this.notificationMessageDelivererRegistryService = notificationMessageDelivererRegistryService;
    }

    public ModelAndView displayActionListPreferences(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "ActionListPreferences";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        HashMap model = new HashMap();
        return new ModelAndView(view, model);
    }

    public ModelAndView displayUserPreferences(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug((Object)("remoteUser: " + userid));
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug((Object)("currently subscribed to: " + sub.getChannel().getId()));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }

    public ModelAndView subscribeToChannel(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug((Object)("remoteUser: " + userid));
        String channelid = request.getParameter("channelid");
        NotificationChannelBo newChannel = this.notificationChannelService.getNotificationChannel(channelid);
        LOG.debug((Object)("newChannel name:" + newChannel.getName()));
        UserChannelSubscriptionBo newSub = new UserChannelSubscriptionBo();
        newSub.setUserId(userid);
        newSub.setChannel(newChannel);
        LOG.debug((Object)("Calling service to subscribe to channel: " + newChannel.getName()));
        this.userPreferenceService.subscribeToChannel(newSub);
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug((Object)("currently subscribed to: " + sub.getChannel().getId()));
        }
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }

    public ModelAndView unsubscribeFromChannel(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        view = "UserPreferencesForm";
        String userid = request.getRemoteUser();
        LOG.debug((Object)("remoteUser: " + userid));
        String channelid = request.getParameter("channelid");
        NotificationChannelBo newChannel = this.notificationChannelService.getNotificationChannel(channelid);
        LOG.debug((Object)("getting channel (id, user): " + channelid + "," + userid));
        UserChannelSubscriptionBo oldsub = this.userPreferenceService.getSubscription(channelid, userid);
        oldsub.setChannel(newChannel);
        LOG.debug((Object)("Calling service to unsubscribe: " + newChannel.getName()));
        this.userPreferenceService.unsubscribeFromChannel(oldsub);
        LOG.debug((Object)("Finished unsubscribe service: " + newChannel.getName()));
        Collection<UserChannelSubscriptionBo> subscriptions = this.userPreferenceService.getCurrentSubscriptions(userid);
        HashMap<String, String> currentsubs = new HashMap<String, String>();
        for (UserChannelSubscriptionBo sub : subscriptions) {
            String subid = Long.toString(sub.getChannel().getId());
            currentsubs.put(subid, subid);
            LOG.debug((Object)("currently subscribed to: " + sub.getChannel().getId()));
        }
        Collection<NotificationChannelBo> channels = this.notificationChannelService.getSubscribableChannels();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channels", channels);
        model.put("currentsubs", currentsubs);
        return new ModelAndView(view, model);
    }
}

