/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionitem.ActionItemActionListExtension;
import org.kuali.rice.kew.actionitem.OutboxItemActionListExtension;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.dao.ActionListDAO;
import org.kuali.rice.kew.actionlist.dao.impl.ActionListPriorityComparator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ActionListDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements ActionListDAO {
    private static final Logger LOG = Logger.getLogger(ActionListDAOOjbImpl.class);
    private static final String ACTION_LIST_COUNT_QUERY = "select count(distinct(ai.doc_hdr_id)) from krew_actn_itm_t ai where ai.PRNCPL_ID = ? and (ai.dlgn_typ is null or ai.dlgn_typ = 'P')";
    private static final String MAX_ACTION_ITEM_DATE_ASSIGNED_AND_ACTION_LIST_COUNT_AND_QUERY = "select max(ASND_DT) as max_date, count(distinct(doc_hdr_id)) as total_records  from (       select ASND_DT,doc_hdr_id           from KREW_ACTN_ITM_T   where    prncpl_id=?          group by  ASND_DT,doc_hdr_id        ) T";

    @Override
    public Collection<ActionItemActionListExtension> getActionList(String principalId, ActionListFilter filter) {
        return this.getActionItemsInActionList(ActionItemActionListExtension.class, principalId, filter);
    }

    @Override
    public Collection<ActionItemActionListExtension> getActionListForSingleDocument(String documentId) {
        LOG.debug((Object)("getting action list for document id " + documentId));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        Collection collection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionItemActionListExtension.class, crit));
        LOG.debug((Object)("found " + collection.size() + " action items for document id " + documentId));
        return this.createActionListForRouteHeader(collection);
    }

    private Criteria setUpActionListCriteria(String principalId, ActionListFilter filter) {
        Criteria orCrit;
        Criteria groupCrit;
        Criteria userCrit;
        LOG.debug((Object)"setting up Action List criteria");
        Criteria crit = new Criteria();
        boolean filterOn = false;
        String filteredByItems = "";
        if (filter.getActionRequestCd() != null && !"".equals(filter.getActionRequestCd().trim()) && !filter.getActionRequestCd().equals("All")) {
            if (filter.isExcludeActionRequestCd()) {
                crit.addNotEqualTo((Object)"actionRequestCd", (Object)filter.getActionRequestCd());
            } else {
                crit.addEqualTo("actionRequestCd", (Object)filter.getActionRequestCd());
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Action Requested";
        }
        if (filter.getCreateDateFrom() != null || filter.getCreateDateTo() != null) {
            if (filter.isExcludeCreateDate()) {
                if (filter.getCreateDateFrom() != null && filter.getCreateDateTo() != null) {
                    crit.addNotBetween((Object)"routeHeader.createDate", (Object)new Timestamp(this.beginningOfDay(filter.getCreateDateFrom()).getTime()), (Object)new Timestamp(this.endOfDay(filter.getCreateDateTo()).getTime()));
                } else if (filter.getCreateDateFrom() != null && filter.getCreateDateTo() == null) {
                    crit.addLessOrEqualThan((Object)"routeHeader.createDate", (Object)new Timestamp(this.beginningOfDay(filter.getCreateDateFrom()).getTime()));
                } else if (filter.getCreateDateFrom() == null && filter.getCreateDateTo() != null) {
                    crit.addGreaterOrEqualThan((Object)"routeHeader.createDate", (Object)new Timestamp(this.endOfDay(filter.getCreateDateTo()).getTime()));
                }
            } else if (filter.getCreateDateFrom() != null && filter.getCreateDateTo() != null) {
                crit.addBetween((Object)"routeHeader.createDate", (Object)new Timestamp(this.beginningOfDay(filter.getCreateDateFrom()).getTime()), (Object)new Timestamp(this.endOfDay(filter.getCreateDateTo()).getTime()));
            } else if (filter.getCreateDateFrom() != null && filter.getCreateDateTo() == null) {
                crit.addGreaterOrEqualThan((Object)"routeHeader.createDate", (Object)new Timestamp(this.beginningOfDay(filter.getCreateDateFrom()).getTime()));
            } else if (filter.getCreateDateFrom() == null && filter.getCreateDateTo() != null) {
                crit.addLessOrEqualThan((Object)"routeHeader.createDate", (Object)new Timestamp(this.endOfDay(filter.getCreateDateTo()).getTime()));
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Date Created";
        }
        if (filter.getDocRouteStatus() != null && !"".equals(filter.getDocRouteStatus().trim()) && !filter.getDocRouteStatus().equals("All")) {
            if (filter.isExcludeRouteStatus()) {
                crit.addNotEqualTo((Object)"routeHeader.docRouteStatus", (Object)filter.getDocRouteStatus());
            } else {
                crit.addEqualTo("routeHeader.docRouteStatus", (Object)filter.getDocRouteStatus());
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Document Route Status";
        }
        if (filter.getDocumentTitle() != null && !"".equals(filter.getDocumentTitle().trim())) {
            String docTitle = filter.getDocumentTitle();
            if (docTitle.trim().endsWith("*")) {
                docTitle = docTitle.substring(0, docTitle.length() - 1);
            }
            if (filter.isExcludeDocumentTitle()) {
                crit.addNotLike("docTitle", (Object)("%" + docTitle + "%"));
            } else {
                crit.addLike((Object)"docTitle", (Object)("%" + docTitle + "%"));
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Document Title";
        }
        if (filter.getDocumentType() != null && !"".equals(filter.getDocumentType().trim())) {
            if (filter.isExcludeDocumentType()) {
                crit.addNotLike("docName", (Object)("%" + filter.getDocumentType() + "%"));
            } else {
                String documentTypeName = filter.getDocumentType();
                DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
                if (documentType == null) {
                    crit.addLike((Object)"docName", (Object)("%" + filter.getDocumentType() + "%"));
                } else {
                    Criteria docTypeCrit = new Criteria();
                    this.constructDocumentTypeCriteria(docTypeCrit, documentType);
                    crit.addAndCriteria(docTypeCrit);
                }
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Document Type";
        }
        if (filter.getLastAssignedDateFrom() != null || filter.getLastAssignedDateTo() != null) {
            if (filter.isExcludeLastAssignedDate()) {
                if (filter.getLastAssignedDateFrom() != null && filter.getLastAssignedDateTo() != null) {
                    crit.addNotBetween((Object)"dateAssigned", (Object)new Timestamp(this.beginningOfDay(filter.getLastAssignedDateFrom()).getTime()), (Object)new Timestamp(this.endOfDay(filter.getLastAssignedDateTo()).getTime()));
                } else if (filter.getLastAssignedDateFrom() != null && filter.getLastAssignedDateTo() == null) {
                    crit.addLessOrEqualThan((Object)"dateAssigned", (Object)new Timestamp(this.beginningOfDay(filter.getLastAssignedDateFrom()).getTime()));
                } else if (filter.getLastAssignedDateFrom() == null && filter.getLastAssignedDateTo() != null) {
                    crit.addGreaterOrEqualThan((Object)"dateAssigned", (Object)new Timestamp(this.endOfDay(filter.getLastAssignedDateTo()).getTime()));
                }
            } else if (filter.getLastAssignedDateFrom() != null && filter.getLastAssignedDateTo() != null) {
                crit.addBetween((Object)"dateAssigned", (Object)new Timestamp(this.beginningOfDay(filter.getLastAssignedDateFrom()).getTime()), (Object)new Timestamp(this.endOfDay(filter.getLastAssignedDateTo()).getTime()));
            } else if (filter.getLastAssignedDateFrom() != null && filter.getLastAssignedDateTo() == null) {
                crit.addGreaterOrEqualThan((Object)"dateAssigned", (Object)new Timestamp(this.beginningOfDay(filter.getLastAssignedDateFrom()).getTime()));
            } else if (filter.getLastAssignedDateFrom() == null && filter.getLastAssignedDateTo() != null) {
                crit.addLessOrEqualThan((Object)"dateAssigned", (Object)new Timestamp(this.endOfDay(filter.getLastAssignedDateTo()).getTime()));
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Date Last Assigned";
        }
        filter.setGroupId(null);
        if (filter.getGroupIdString() != null && !"".equals(filter.getGroupIdString().trim()) && !filter.getGroupIdString().trim().equals("No Filtering")) {
            filter.setGroupId(filter.getGroupIdString().trim());
            if (filter.isExcludeGroupId()) {
                Criteria critNotEqual = new Criteria();
                critNotEqual.addNotEqualTo((Object)"groupId", (Object)filter.getGroupId());
                Criteria critNull = new Criteria();
                critNull.addIsNull("groupId");
                critNotEqual.addOrCriteria(critNull);
                crit.addAndCriteria(critNotEqual);
            } else {
                crit.addEqualTo("groupId", (Object)filter.getGroupId());
            }
            filteredByItems = filteredByItems + (filteredByItems.length() > 0 ? ", " : "");
            filteredByItems = filteredByItems + "Action Request Workgroup";
        }
        if (filteredByItems.length() > 0) {
            filterOn = true;
        }
        boolean addedDelegationCriteria = false;
        if (StringUtils.isBlank((String)filter.getDelegationType()) && StringUtils.isBlank((String)filter.getPrimaryDelegateId()) && StringUtils.isBlank((String)filter.getDelegatorId())) {
            crit.addEqualTo("principalId", (Object)principalId);
            addedDelegationCriteria = true;
        } else if (StringUtils.isNotBlank((String)filter.getDelegationType()) && DelegationType.PRIMARY.getCode().equals(filter.getDelegationType()) || StringUtils.isNotBlank((String)filter.getPrimaryDelegateId())) {
            List delegatorGroupIds;
            if (StringUtils.isBlank((String)filter.getPrimaryDelegateId()) || filter.getPrimaryDelegateId().trim().equals("All")) {
                userCrit = new Criteria();
                groupCrit = new Criteria();
                orCrit = new Criteria();
                userCrit.addEqualTo("delegatorPrincipalId", (Object)principalId);
                delegatorGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
                if (delegatorGroupIds != null && !delegatorGroupIds.isEmpty()) {
                    groupCrit.addIn("delegatorGroupId", (Collection)delegatorGroupIds);
                }
                orCrit.addOrCriteria(userCrit);
                orCrit.addOrCriteria(groupCrit);
                crit.addAndCriteria(orCrit);
                crit.addEqualTo("delegationType", (Object)DelegationType.PRIMARY.getCode());
                filter.setDelegationType(DelegationType.PRIMARY.getCode());
                filter.setExcludeDelegationType(false);
                this.addToFilterDescription(filteredByItems, "Primary Delegator Id");
                addedDelegationCriteria = true;
                filterOn = true;
            } else if (!filter.getPrimaryDelegateId().trim().equals("Choose Primary Delegate")) {
                crit.addEqualTo("principalId", (Object)filter.getPrimaryDelegateId());
                userCrit = new Criteria();
                groupCrit = new Criteria();
                orCrit = new Criteria();
                userCrit.addEqualTo("delegatorPrincipalId", (Object)principalId);
                delegatorGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
                if (delegatorGroupIds != null && !delegatorGroupIds.isEmpty()) {
                    groupCrit.addIn("delegatorGroupId", (Collection)delegatorGroupIds);
                }
                orCrit.addOrCriteria(userCrit);
                orCrit.addOrCriteria(groupCrit);
                crit.addAndCriteria(orCrit);
                crit.addEqualTo("delegationType", (Object)DelegationType.PRIMARY.getCode());
                filter.setDelegationType(DelegationType.PRIMARY.getCode());
                filter.setExcludeDelegationType(false);
                this.addToFilterDescription(filteredByItems, "Primary Delegator Id");
                addedDelegationCriteria = true;
                filterOn = true;
            }
        }
        if (!addedDelegationCriteria && (StringUtils.isNotBlank((String)filter.getDelegationType()) && DelegationType.SECONDARY.getCode().equals(filter.getDelegationType()) || StringUtils.isNotBlank((String)filter.getDelegatorId()))) {
            crit.addEqualTo("principalId", (Object)principalId);
            if (StringUtils.isBlank((String)filter.getDelegatorId())) {
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                if (!filter.isExcludeDelegationType()) {
                    crit.addEqualTo("delegationType", (Object)DelegationType.SECONDARY.getCode());
                    this.addToFilterDescription(filteredByItems, "Secondary Delegator Id");
                    addedDelegationCriteria = true;
                    filterOn = true;
                }
            } else if (filter.getDelegatorId().trim().equals("All")) {
                crit.addEqualTo("delegationType", (Object)DelegationType.SECONDARY.getCode());
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                filter.setExcludeDelegationType(false);
                this.addToFilterDescription(filteredByItems, "Secondary Delegator Id");
                addedDelegationCriteria = true;
                filterOn = true;
            } else if (!filter.getDelegatorId().trim().equals("Choose Secondary Delegation")) {
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                filter.setExcludeDelegationType(false);
                userCrit = new Criteria();
                groupCrit = new Criteria();
                if (filter.isExcludeDelegatorId()) {
                    Criteria userNull = new Criteria();
                    userCrit.addNotEqualTo((Object)"delegatorPrincipalId", (Object)filter.getDelegatorId());
                    userNull.addIsNull("delegatorPrincipalId");
                    userCrit.addOrCriteria(userNull);
                    Criteria groupNull = new Criteria();
                    groupCrit.addNotEqualTo((Object)"delegatorGroupId", (Object)filter.getDelegatorId());
                    groupNull.addIsNull("delegatorGroupId");
                    groupCrit.addOrCriteria(groupNull);
                    crit.addAndCriteria(userCrit);
                    crit.addAndCriteria(groupCrit);
                } else {
                    orCrit = new Criteria();
                    userCrit.addEqualTo("delegatorPrincipalId", (Object)filter.getDelegatorId());
                    groupCrit.addEqualTo("delegatorGroupId", (Object)filter.getDelegatorId());
                    orCrit.addOrCriteria(userCrit);
                    orCrit.addOrCriteria(groupCrit);
                    crit.addAndCriteria(orCrit);
                }
                this.addToFilterDescription(filteredByItems, "Secondary Delegator Id");
                addedDelegationCriteria = true;
                filterOn = true;
            }
        }
        if (!addedDelegationCriteria) {
            crit.addEqualTo("principalId", (Object)principalId);
            filter.setDelegationType(DelegationType.SECONDARY.getCode());
            filter.setExcludeDelegationType(true);
            Criteria critNotEqual = new Criteria();
            Criteria critNull = new Criteria();
            critNotEqual.addNotEqualTo((Object)"delegationType", (Object)DelegationType.SECONDARY.getCode());
            critNull.addIsNull("delegationType");
            critNotEqual.addOrCriteria(critNull);
            crit.addAndCriteria(critNotEqual);
        }
        if (!"".equals(filteredByItems)) {
            filteredByItems = "Filtered by " + filteredByItems;
        }
        filter.setFilterLegend(filteredByItems);
        filter.setFilterOn(filterOn);
        LOG.debug((Object)"returning from Action List criteria");
        return crit;
    }

    private void constructDocumentTypeCriteria(Criteria criteria, DocumentType documentType) {
        Criteria docTypeBaseCrit = new Criteria();
        docTypeBaseCrit.addEqualTo("docName", (Object)documentType.getName());
        criteria.addOrCriteria(docTypeBaseCrit);
        Collection children = documentType.getChildrenDocTypes();
        if (children != null) {
            for (DocumentType childDocumentType : children) {
                this.constructDocumentTypeCriteria(criteria, childDocumentType);
            }
        }
    }

    private void addToFilterDescription(String filterDescription, String labelToAdd) {
        filterDescription = filterDescription + (filterDescription.length() > 0 ? ", " : "");
        filterDescription = filterDescription + labelToAdd;
    }

    @Override
    public int getCount(final String workflowId) {
        return (Integer)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    statement = connection.prepareStatement(ActionListDAOOjbImpl.ACTION_LIST_COUNT_QUERY);
                    statement.setString(1, workflowId);
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) {
                        throw new WorkflowRuntimeException("Error determining Action List Count.");
                    }
                    Integer n = resultSet.getInt(1);
                    return n;
                }
                catch (SQLException e) {
                    throw new WorkflowRuntimeException("Error determining Action List Count.", (Throwable)e);
                }
                catch (LookupException e) {
                    throw new WorkflowRuntimeException("Error determining Action List Count.", (Throwable)e);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    @Override
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(final String principalId) {
        return (List)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement statement = null;
                ResultSet resultSet = null;
                ArrayList<Comparable<Date>> result = new ArrayList<Comparable<Date>>();
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    statement = connection.prepareStatement(ActionListDAOOjbImpl.MAX_ACTION_ITEM_DATE_ASSIGNED_AND_ACTION_LIST_COUNT_AND_QUERY);
                    statement.setString(1, principalId);
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) {
                        throw new WorkflowRuntimeException("Error determining Action List Count and Max Action Item Id.");
                    }
                    result.add(resultSet.getTimestamp(1));
                    result.add(Integer.valueOf(resultSet.getInt(2)));
                    ArrayList<Comparable<Date>> arrayList = result;
                    return arrayList;
                }
                catch (SQLException e) {
                    throw new WorkflowRuntimeException("Error determining Action List Count and Max Action Item Id.", (Throwable)e);
                }
                catch (LookupException e) {
                    throw new WorkflowRuntimeException("Error determining Action List Count and Max Action Item Id.", (Throwable)e);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    private <T extends ActionItemActionListExtension> Collection<T> createActionListForUser(Collection<T> actionItems) {
        HashMap<String, ActionItemActionListExtension> actionItemMap = new HashMap<String, ActionItemActionListExtension>();
        ActionListPriorityComparator comparator = new ActionListPriorityComparator();
        for (ActionItemActionListExtension potentialActionItem : actionItems) {
            ActionItemActionListExtension existingActionItem = (ActionItemActionListExtension)actionItemMap.get(potentialActionItem.getDocumentId());
            if (existingActionItem != null && comparator.compare(potentialActionItem, existingActionItem) <= 0) continue;
            actionItemMap.put(potentialActionItem.getDocumentId(), potentialActionItem);
        }
        return actionItemMap.values();
    }

    private Collection<ActionItemActionListExtension> createActionListForRouteHeader(Collection<ActionItemActionListExtension> actionItems) {
        HashMap<String, ActionItemActionListExtension> actionItemMap = new HashMap<String, ActionItemActionListExtension>();
        ActionListPriorityComparator comparator = new ActionListPriorityComparator();
        for (ActionItemActionListExtension potentialActionItem : actionItems) {
            ActionItemActionListExtension existingActionItem = (ActionItemActionListExtension)actionItemMap.get(potentialActionItem.getPrincipalId());
            if (existingActionItem != null && comparator.compare(potentialActionItem, existingActionItem) <= 0) continue;
            actionItemMap.put(potentialActionItem.getPrincipalId(), potentialActionItem);
        }
        return actionItemMap.values();
    }

    private <T extends ActionItemActionListExtension> Collection<T> getActionItemsInActionList(Class<T> objectsToRetrieve, String principalId, ActionListFilter filter) {
        LOG.debug((Object)("getting action list for user " + principalId));
        Criteria crit = null;
        if (filter == null) {
            crit = new Criteria();
            crit.addEqualTo("principalId", (Object)principalId);
        } else {
            crit = this.setUpActionListCriteria(principalId, filter);
        }
        LOG.debug((Object)("running query to get action list for criteria " + crit));
        Collection collection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(objectsToRetrieve, crit));
        LOG.debug((Object)("found " + collection.size() + " action items for user " + principalId));
        return this.createActionListForUser(collection);
    }

    @Override
    public Collection<OutboxItemActionListExtension> getOutbox(String principalId, ActionListFilter filter) {
        return this.getActionItemsInActionList(OutboxItemActionListExtension.class, principalId, filter);
    }

    @Override
    public void removeOutboxItems(String principalId, List<String> outboxItems) {
        Criteria crit = new Criteria();
        crit.addIn("id", outboxItems);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(OutboxItemActionListExtension.class, crit));
    }

    @Override
    public void saveOutboxItem(OutboxItemActionListExtension outboxItem) {
        this.getPersistenceBrokerTemplate().store((Object)outboxItem);
    }

    @Override
    public OutboxItemActionListExtension getOutboxByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return (OutboxItemActionListExtension)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(OutboxItemActionListExtension.class, crit));
    }

    @Override
    public OutboxItemActionListExtension getOutboxByDocumentIdUserId(String documentId, String userId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("principalId", (Object)userId);
        return (OutboxItemActionListExtension)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(OutboxItemActionListExtension.class, crit));
    }

    private Date beginningOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private Date endOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }
}

