/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class AcknowledgeAction
extends ActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(AcknowledgeAction.class);

    public AcknowledgeAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super("K", rh, principal);
    }

    public AcknowledgeAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super("K", rh, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be acknowledged";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "K");
        if (!this.isActionCompatibleRequest((List)filteredActionRequests)) {
            return "No request for the user is compatible with the ACKNOWLEDGE action";
        }
        return "";
    }

    public boolean isActionCompatibleRequest(List requests) {
        if (requests.isEmpty()) {
            return true;
        }
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = (ActionRequestValue)ars.next();
            String request = actionRequest.getActionRequested();
            if (!"K".equals(request) && !"F".equals(request)) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        DocumentTypePolicy allowUnrequested;
        MDC.put((String)"docId", (Object)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug((Object)("Acknowledging document : " + this.annotation));
        LOG.debug((Object)"Checking to see if the action is legal");
        List actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.routeHeader.getDocumentId(), "K");
        if ((actionRequests == null || actionRequests.isEmpty()) && (allowUnrequested = this.getRouteHeader().getDocumentType().getAllowUnrequestedActionPolicy()) != null && !allowUnrequested.getPolicyValue().booleanValue()) {
            throw new InvalidActionTakenException("No request for the user is compatible with the ACKNOWLEDGE action. Doctype policy ALLOW_UNREQUESTED_ACTION is set to false and someone else likely just took action on the document.");
        }
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug((Object)"Record the acknowledge action");
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        LOG.debug((Object)"Deactivate all pending action requests");
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
    }
}

