/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kew.docsearch.CaseAwareSearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_DOC_HDR_EXT_T")
@NamedQueries(value={@NamedQuery(name="SearchableAttributeStringValue.FindByDocumentId", query="select s from SearchableAttributeStringValue as s where s.documentId = :documentId"), @NamedQuery(name="SearchableAttributeStringValue.FindByKey", query="select s from SearchableAttributeStringValue as s where s.documentId = :documentId and s.searchableAttributeKey = :searchableAttributeKey")})
public class SearchableAttributeStringValue
implements CaseAwareSearchableAttributeValue,
Serializable {
    private static final long serialVersionUID = 8696089933682052078L;
    private static final String ATTRIBUTE_DATABASE_TABLE_NAME = "KREW_DOC_HDR_EXT_T";
    private static final boolean DEFAULT_WILDCARD_ALLOWANCE_POLICY = true;
    private static final boolean ALLOWS_RANGE_SEARCH = true;
    private static final boolean ALLOWS_CASE_INSENSITIVE_SEARCH = true;
    private static final String ATTRIBUTE_XML_REPRESENTATION = "string";
    private static final int STRING_MAX_LENGTH = 2000;
    @Id
    @GeneratedValue(generator="KREW_SRCH_ATTR_S")
    @GenericGenerator(name="KREW_SRCH_ATTR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_SRCH_ATTR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_HDR_EXT_ID")
    private String searchableAttributeValueId;
    @Column(name="KEY_CD")
    private String searchableAttributeKey;
    @Column(name="VAL")
    private String searchableAttributeValue;
    @Transient
    protected String ojbConcreteClass = this.getClass().getName();
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private DocumentRouteHeaderValue routeHeader;

    @Override
    public void setupAttributeValue(String value) {
        this.setSearchableAttributeValue(value);
    }

    @Override
    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException {
        this.setSearchableAttributeValue(resultSet.getString(columnName));
    }

    @Override
    public String getSearchableAttributeDisplayValue() {
        return this.getSearchableAttributeValue();
    }

    @Override
    public String getAttributeDataType() {
        return ATTRIBUTE_XML_REPRESENTATION;
    }

    @Override
    public String getAttributeTableName() {
        return ATTRIBUTE_DATABASE_TABLE_NAME;
    }

    @Override
    public boolean allowsWildcards() {
        return true;
    }

    @Override
    public boolean allowsCaseInsensitivity() {
        return true;
    }

    @Override
    public boolean allowsRangeSearches() {
        return true;
    }

    @Override
    public boolean isPassesDefaultValidation(String valueEntered) {
        return valueEntered == null || valueEntered.length() <= 2000;
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue) {
        return this.isRangeValid(lowerValue, upperValue, true);
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue, boolean caseSensitive) {
        if (this.allowsRangeSearches()) {
            return StringUtils.isBlank((String)lowerValue) || StringUtils.isBlank((String)upperValue) || (caseSensitive ? ObjectUtils.compare((Comparable)((Object)lowerValue), (Comparable)((Object)upperValue)) <= 0 : String.CASE_INSENSITIVE_ORDER.compare(lowerValue, upperValue) <= 0);
        }
        return null;
    }

    @Override
    public String getOjbConcreteClass() {
        return this.ojbConcreteClass;
    }

    @Override
    public void setOjbConcreteClass(String ojbConcreteClass) {
        this.ojbConcreteClass = ojbConcreteClass;
    }

    @Override
    public DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    @Override
    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @Override
    public String getSearchableAttributeKey() {
        return this.searchableAttributeKey;
    }

    @Override
    public void setSearchableAttributeKey(String searchableAttributeKey) {
        this.searchableAttributeKey = searchableAttributeKey;
    }

    @Override
    public String getSearchableAttributeValue() {
        return this.searchableAttributeValue;
    }

    public void setSearchableAttributeValue(String searchableAttributeValue) {
        this.searchableAttributeValue = searchableAttributeValue;
    }

    @Override
    public String getSearchableAttributeValueId() {
        return this.searchableAttributeValueId;
    }

    @Override
    public void setSearchableAttributeValueId(String searchableAttributeValueId) {
        this.searchableAttributeValueId = searchableAttributeValueId;
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public DocumentAttributeString toDocumentAttribute() {
        return DocumentAttributeFactory.createStringAttribute((String)this.getSearchableAttributeKey(), (String)this.getSearchableAttributeValue());
    }
}

