/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.bo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttribute;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatusCategory;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.DocumentTypeSecurity;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.notes.CustomNoteAttribute;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_DOC_TYP_T")
@NamedQueries(value={@NamedQuery(name="DocumentType.QuickLinks.FindLabelByTypeName", query="SELECT label FROM DocumentType WHERE name = :docTypeName AND currentInd = 1"), @NamedQuery(name="DocumentType.QuickLinks.FindInitiatedDocumentTypesListByInitiatorWorkflowId", query="SELECT DISTINCT dt.name, dt.label FROM DocumentType dt, DocumentRouteHeaderValue drhv WHERE drhv.initiatorWorkflowId = :initiatorWorkflowId AND drhv.documentTypeId = dt.documentTypeId AND dt.active = 1 AND dt.currentInd = 1 ORDER BY UPPER(dt.label)")})
public class DocumentType
extends PersistableBusinessObjectBase
implements MutableInactivatable,
DocumentTypeEBO,
DocumentTypeContract {
    private static final Logger LOG = Logger.getLogger(DocumentType.class);
    private static final long serialVersionUID = 1312830153583125069L;
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @GenericGenerator(name="KREW_DOC_HDR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_DOC_HDR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_TYP_ID")
    private String documentTypeId;
    @Column(name="PARNT_ID")
    private String docTypeParentId;
    @Column(name="DOC_TYP_NM")
    private String name;
    @Column(name="DOC_TYP_VER_NBR")
    private Integer version = new Integer(0);
    @Column(name="ACTV_IND")
    private Boolean active;
    @Column(name="CUR_IND")
    private Boolean currentInd;
    @Column(name="DOC_TYP_DESC")
    private String description;
    @Column(name="LBL")
    private String label = null;
    @Column(name="PREV_DOC_TYP_VER_NBR")
    private String previousVersionId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="HELP_DEF_URL")
    private String unresolvedHelpDefinitionUrl;
    @Column(name="DOC_SEARCH_HELP_URL")
    private String unresolvedDocSearchHelpUrl;
    @Column(name="DOC_HDLR_URL")
    private String unresolvedDocHandlerUrl;
    @Column(name="POST_PRCSR")
    private String postProcessorName;
    @Column(name="GRP_ID")
    private String workgroupId;
    @Column(name="BLNKT_APPR_GRP_ID")
    private String blanketApproveWorkgroupId;
    @Column(name="BLNKT_APPR_PLCY")
    private String blanketApprovePolicy;
    @Column(name="RPT_GRP_ID")
    private String reportingWorkgroupId;
    @Column(name="APPL_ID")
    private String actualApplicationId;
    @Column(name="AUTHORIZER")
    private String authorizer;
    @Transient
    private String returnUrl;
    @Transient
    private String actionsUrl;
    @Transient
    private Boolean applyRetroactively = Boolean.FALSE;
    @Transient
    private Group defaultExceptionWorkgroup;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, mappedBy="documentType")
    @Fetch(value=FetchMode.SELECT)
    private Collection<DocumentTypePolicy> documentTypePolicies;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, mappedBy="documentType")
    @Fetch(value=FetchMode.SELECT)
    private List<ApplicationDocumentStatus> validApplicationStatuses;
    private List<ApplicationDocumentStatusCategory> applicationStatusCategories;
    @Transient
    private List routeLevels;
    @Transient
    private Collection childrenDocTypes;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, mappedBy="documentType")
    @OrderBy(value="orderIndex ASC")
    private List<DocumentTypeAttributeBo> documentTypeAttributes;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST}, mappedBy="documentType")
    private List<ProcessDefinitionBo> processes = new ArrayList<ProcessDefinitionBo>();
    @Column(name="RTE_VER_NBR")
    private String routingVersion = "2";
    @Column(name="NOTIFY_ADDR")
    private String actualNotificationFromAddress;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="SEC_XML")
    private String documentTypeSecurityXml;
    @Transient
    private DocumentTypeSecurity documentTypeSecurity;
    @Column(name="EMAIL_XSL")
    private String customEmailStylesheet;

    public DocumentType() {
        this.routeLevels = new ArrayList();
        this.documentTypeAttributes = new ArrayList<DocumentTypeAttributeBo>();
        this.documentTypePolicies = new ArrayList<DocumentTypePolicy>();
        this.version = new Integer(0);
    }

    public void populateDataDictionaryEditableFields(Set<String> propertyNamesEditableViaUI, DocumentType dataDictionaryEditedType) {
        String currentPropertyName = "";
        try {
            Iterator<String> iterator = propertyNamesEditableViaUI.iterator();
            while (iterator.hasNext()) {
                String propertyName;
                currentPropertyName = propertyName = iterator.next();
                if ("parentDocType.name".equals(propertyName)) {
                    String parentDocumentTypeName = (String)org.kuali.rice.krad.util.ObjectUtils.getPropertyValue((Object)dataDictionaryEditedType, (String)propertyName);
                    if (!StringUtils.isNotBlank((String)parentDocumentTypeName)) continue;
                    DocumentType parentDocType = KEWServiceLocator.getDocumentTypeService().findByName(parentDocumentTypeName);
                    if (org.kuali.rice.krad.util.ObjectUtils.isNull((Object)parentDocType)) {
                        throw new WorkflowRuntimeException("Could not find valid document type for document type name '" + parentDocumentTypeName + "' to set as Parent Document Type");
                    }
                    this.setDocTypeParentId(parentDocType.getDocumentTypeId());
                    continue;
                }
                LOG.info((Object)("*** COPYING PROPERTY NAME FROM OLD BO TO NEW BO: " + propertyName));
                org.kuali.rice.krad.util.ObjectUtils.setObjectProperty((Object)this, (String)propertyName, (Object)org.kuali.rice.krad.util.ObjectUtils.getPropertyValue((Object)dataDictionaryEditedType, (String)propertyName));
            }
        }
        catch (FormatException e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error setting property '" + currentPropertyName + "' in Document Type", (Throwable)e);
        }
    }

    public DocumentTypePolicy getAllowUnrequestedActionPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_UNREQUESTED_ACTION.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getDefaultApprovePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DEFAULT_APPROVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getUseWorkflowSuperUserDocHandlerUrl() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.USE_KEW_SUPERUSER_DOCHANDLER.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustRoutePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustSavePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustCancelPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_CANCEL.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getInitiatorMustBlanketApprovePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_BLANKET_APPROVE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getLookIntoFuturePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.LOOK_FUTURE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getSuperUserApproveNotificationPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SEND_NOTIFICATION_ON_SU_APPROVE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getSupportsQuickInitiatePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SUPPORTS_QUICK_INITIATE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getNotifyOnSavePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.NOTIFY_ON_SAVE.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getDocumentStatusPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW");
    }

    public DocumentTypePolicy getSuPostprocessorOverridePolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_POSTPROCESSOR_OVERRIDE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getFailOnInactiveGroup() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.FAIL_ON_INACTIVE_GROUP.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getEnrouteErrorSuppression() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getRegenerateActionRequestsOnChange() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.REGENERATE_ACTION_REQUESTS_ON_CHANGE.getCode(), Boolean.TRUE);
    }

    public DocumentTypePolicy getRecallNotification() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.RECALL_NOTIFICATION.getCode(), (String)null);
    }

    public DocumentTypePolicy getSuppressImmediateEmailsOnSuActionPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.SUPPRESS_IMMEDIATE_EMAILS_ON_SU_ACTION.getCode(), Boolean.FALSE);
    }

    public DocumentTypePolicy getAllowSuperUserFinalApprovalPolicy() {
        return this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL.getCode(), Boolean.TRUE);
    }

    public Boolean isKEWStatusInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return policyValue == null || "".equals(policyValue) || "KEW".equalsIgnoreCase(policyValue) || "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isAppDocStatusInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return "APP".equalsIgnoreCase(policyValue) || "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean areBothStatusesInUse() {
        if (this.isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY)) {
            String policyValue = this.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOCUMENT_STATUS_POLICY.getCode(), "KEW").getPolicyStringValue();
            return "BOTH".equalsIgnoreCase(policyValue) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public String getUseWorkflowSuperUserDocHandlerUrlValue() {
        if (this.getUseWorkflowSuperUserDocHandlerUrl() != null) {
            return this.getUseWorkflowSuperUserDocHandlerUrl().getPolicyDisplayValue();
        }
        return null;
    }

    public String getAllowUnrequestedActionPolicyDisplayValue() {
        if (this.getAllowUnrequestedActionPolicy() != null) {
            return this.getAllowUnrequestedActionPolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getDefaultApprovePolicyDisplayValue() {
        if (this.getDefaultApprovePolicy() != null) {
            return this.getDefaultApprovePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getInitiatorMustRouteDisplayValue() {
        if (this.getInitiatorMustRoutePolicy() != null) {
            return this.getInitiatorMustRoutePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public String getInitiatorMustSaveDisplayValue() {
        if (this.getInitiatorMustSavePolicy() != null) {
            return this.getInitiatorMustSavePolicy().getPolicyDisplayValue();
        }
        return null;
    }

    public boolean isPolicyDefined(org.kuali.rice.kew.api.doctype.DocumentTypePolicy policyToCheck) {
        for (DocumentTypePolicy policy : this.getDocumentTypePolicies()) {
            if (!policyToCheck.getCode().equals(policy.getPolicyName())) continue;
            return true;
        }
        return this.getParentDocType() != null && this.getParentDocType().isPolicyDefined(policyToCheck);
    }

    public List<DocumentTypeAttributeBo> getDocumentTypeAttributes(String ... attributeTypes) {
        ArrayList<DocumentTypeAttributeBo> filteredAttributes = new ArrayList<DocumentTypeAttributeBo>();
        if (CollectionUtils.isNotEmpty(this.documentTypeAttributes)) {
            if (attributeTypes == null) {
                filteredAttributes.addAll(this.documentTypeAttributes);
            } else {
                List<String> attributeTypeList = Arrays.asList(attributeTypes);
                for (DocumentTypeAttributeBo documentTypeAttribute : this.documentTypeAttributes) {
                    RuleAttribute ruleAttribute = documentTypeAttribute.getRuleAttribute();
                    if (!attributeTypeList.contains(ruleAttribute.getType())) continue;
                    filteredAttributes.add(documentTypeAttribute);
                }
            }
        }
        if (filteredAttributes.isEmpty() && this.getParentDocType() != null) {
            return this.getParentDocType().getDocumentTypeAttributes(attributeTypes);
        }
        return Collections.unmodifiableList(filteredAttributes);
    }

    public boolean hasSearchableAttributes() {
        return !this.getSearchableAttributes().isEmpty();
    }

    public List<DocumentTypeAttributeBo> getSearchableAttributes() {
        return this.getDocumentTypeAttributes("SearchableAttribute", "SearchableXmlAttribute");
    }

    public DocumentTypeAttributeBo getCustomizerAttribute() {
        List<DocumentTypeAttributeBo> documentTypeAttributes = this.getDocumentTypeAttributes("DocumentSearchCustomizer");
        if (documentTypeAttributes.size() > 1) {
            throw new IllegalStateException("Encountered more than one DocumentSearchCustomizer attribute on this document type: " + this.getName());
        }
        if (documentTypeAttributes.isEmpty()) {
            return null;
        }
        return documentTypeAttributes.get(0);
    }

    public RuleAttribute getCustomActionListRuleAttribute() {
        List<DocumentTypeAttributeBo> documentTypeAttributes = this.getDocumentTypeAttributes("ActionListAttribute");
        if (documentTypeAttributes.size() > 1) {
            throw new IllegalStateException("Encountered more than one ActionListAttribute on this document type: " + this.getName());
        }
        if (documentTypeAttributes.isEmpty()) {
            return null;
        }
        return documentTypeAttributes.get(0).getRuleAttribute();
    }

    public List<ExtensionHolder<SearchableAttribute>> loadSearchableAttributes() {
        List<DocumentTypeAttributeBo> searchableAttributes = this.getSearchableAttributes();
        ArrayList<ExtensionHolder<SearchableAttribute>> loadedAttributes = new ArrayList<ExtensionHolder<SearchableAttribute>>();
        for (DocumentTypeAttributeBo documentTypeAttribute : searchableAttributes) {
            RuleAttribute ruleAttribute = documentTypeAttribute.getRuleAttribute();
            try {
                ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(ruleAttribute.getId());
                SearchableAttribute attributeService = (SearchableAttribute)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition, (String)this.getApplicationId());
                loadedAttributes.add(new ExtensionHolder<SearchableAttribute>(extensionDefinition, attributeService));
            }
            catch (RiceRemoteServiceConnectionException e) {
                LOG.warn((Object)("Unable to connect to load searchable attribute for " + (Object)((Object)ruleAttribute)), (Throwable)e);
            }
        }
        return loadedAttributes;
    }

    public DocumentTypeAttributeBo getDocumentTypeAttribute(int index) {
        while (this.getDocumentTypeAttributes().size() <= index) {
            DocumentTypeAttributeBo attribute = new DocumentTypeAttributeBo();
            this.getDocumentTypeAttributes().add(attribute);
        }
        return this.getDocumentTypeAttributes().get(index);
    }

    public void setDocumentTypeAttribute(int index, DocumentTypeAttributeBo documentTypeAttribute) {
        this.documentTypeAttributes.set(index, documentTypeAttribute);
    }

    public String getDocTypeActiveIndicatorDisplayValue() {
        if (this.getActive() == null) {
            return "Inactive";
        }
        return CodeTranslator.getActiveIndicatorLabel((Boolean)this.getActive());
    }

    public Collection getChildrenDocTypes() {
        if (this.childrenDocTypes == null) {
            this.childrenDocTypes = KEWServiceLocator.getDocumentTypeService().getChildDocumentTypes(this.getDocumentTypeId());
        }
        return this.childrenDocTypes;
    }

    @Override
    public String getDocTypeParentId() {
        return this.docTypeParentId;
    }

    public void setDocTypeParentId(String docTypeParentId) {
        this.docTypeParentId = docTypeParentId;
    }

    public DocumentType getParentDocType() {
        return KEWServiceLocator.getDocumentTypeService().findById(this.docTypeParentId);
    }

    public Collection<DocumentTypePolicy> getDocumentTypePolicies() {
        return this.documentTypePolicies;
    }

    public void setDocumentTypePolicies(Collection<DocumentTypePolicy> policies) {
        this.documentTypePolicies = policies;
    }

    public Map<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> getPolicies() {
        HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> policies = new HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String>();
        if (this.documentTypePolicies != null) {
            for (DocumentTypePolicy policy : this.documentTypePolicies) {
                policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policy.getPolicyName()), policy.getPolicyValue().toString());
            }
        }
        return policies;
    }

    public List<ApplicationDocumentStatus> getValidApplicationStatuses() {
        if ((org.kuali.rice.krad.util.ObjectUtils.isNull(this.validApplicationStatuses) || this.validApplicationStatuses.isEmpty()) && org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)this.getParentDocType()) && this.isAppDocStatusInUse().booleanValue()) {
            return this.getParentDocType().getValidApplicationStatuses();
        }
        return this.validApplicationStatuses;
    }

    public void setValidApplicationStatuses(List<ApplicationDocumentStatus> validApplicationStatuses) {
        this.validApplicationStatuses = validApplicationStatuses;
    }

    public List<ApplicationDocumentStatusCategory> getApplicationStatusCategories() {
        if ((org.kuali.rice.krad.util.ObjectUtils.isNull(this.validApplicationStatuses) || this.validApplicationStatuses.isEmpty()) && org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)this.getParentDocType()) && this.isAppDocStatusInUse().booleanValue()) {
            return this.getParentDocType().getApplicationStatusCategories();
        }
        return this.applicationStatusCategories;
    }

    public void setApplicationStatusCategories(List<ApplicationDocumentStatusCategory> applicationStatusCategories) {
        this.applicationStatusCategories = applicationStatusCategories;
    }

    public String getDocumentTypeSecurityXml() {
        return this.documentTypeSecurityXml;
    }

    public void setDocumentTypeSecurityXml(String documentTypeSecurityXml) {
        this.documentTypeSecurityXml = documentTypeSecurityXml;
        this.documentTypeSecurity = StringUtils.isNotBlank((String)documentTypeSecurityXml) ? new DocumentTypeSecurity(this.getApplicationId(), documentTypeSecurityXml) : null;
    }

    public DocumentTypeSecurity getDocumentTypeSecurity() {
        if (this.documentTypeSecurity == null && this.documentTypeSecurityXml != null && !StringUtils.isEmpty((String)this.documentTypeSecurityXml.trim())) {
            this.documentTypeSecurity = new DocumentTypeSecurity(this.getApplicationId(), this.documentTypeSecurityXml);
        }
        if (this.documentTypeSecurity == null && this.getParentDocType() != null) {
            return this.getParentDocType().getDocumentTypeSecurity();
        }
        return this.documentTypeSecurity;
    }

    public List getRouteLevels() {
        if (this.routeLevels.isEmpty() && this.getParentDocType() != null) {
            return this.getParentRouteLevels(this.getParentDocType());
        }
        return this.routeLevels;
    }

    private List getParentRouteLevels(DocumentType parent) {
        if (parent.getRouteLevels() == null) {
            return this.getParentRouteLevels(parent.getParentDocType());
        }
        return parent.getRouteLevels();
    }

    public void setRouteLevels(List routeLevels) {
        this.routeLevels = routeLevels;
    }

    public String getActionsUrl() {
        return this.actionsUrl;
    }

    public void setActionsUrl(String actions) {
        this.actionsUrl = actions;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean activeInd) {
        this.active = activeInd;
    }

    public Boolean getCurrentInd() {
        return this.currentInd;
    }

    public boolean isCurrent() {
        if (this.currentInd == null) {
            return true;
        }
        return this.currentInd;
    }

    public void setCurrentInd(Boolean currentInd) {
        this.currentInd = currentInd;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResolvedDocumentHandlerUrl() {
        return this.resolveDocHandlerUrl(this.getUnresolvedInheritedDocHandlerUrl(false));
    }

    protected String getUnresolvedInheritedDocHandlerUrl(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getUnresolvedDocHandlerUrl())) {
            return this.getUnresolvedDocHandlerUrl();
        }
        DocumentType docType = this.getParentDocType();
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)docType)) {
            String parentValue = docType.getUnresolvedDocHandlerUrl();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return docType.getUnresolvedInheritedDocHandlerUrl(forDisplayPurposes);
        }
        return null;
    }

    public String getDisplayableUnresolvedDocHandlerUrl() {
        return this.getUnresolvedInheritedDocHandlerUrl(true);
    }

    public void setDisplayableUnresolvedDocHandlerUrl(String displayableUnresolvedDocHandlerUrl) {
    }

    public String getUnresolvedDocHandlerUrl() {
        return this.unresolvedDocHandlerUrl;
    }

    public void setUnresolvedDocHandlerUrl(String unresolvedDocHandlerUrl) {
        this.unresolvedDocHandlerUrl = unresolvedDocHandlerUrl;
    }

    protected String resolveDocHandlerUrl(String docHandlerUrl) {
        if (StringUtils.isBlank((String)docHandlerUrl)) {
            return "";
        }
        return Utilities.substituteConfigParameters(this.getApplicationId(), docHandlerUrl);
    }

    public void setDocHandlerUrl(String docHandlerUrl) {
        this.setUnresolvedDocHandlerUrl(docHandlerUrl);
    }

    public String getUnresolvedHelpDefinitionUrl() {
        return this.unresolvedHelpDefinitionUrl;
    }

    public void setUnresolvedHelpDefinitionUrl(String unresolvedHelpDefinitionUrl) {
        this.unresolvedHelpDefinitionUrl = unresolvedHelpDefinitionUrl;
    }

    @Override
    public String getHelpDefinitionUrl() {
        return this.resolveHelpUrl(this.getUnresolvedHelpDefinitionUrl());
    }

    protected String resolveHelpUrl(String helpDefinitionUrl) {
        if (StringUtils.isBlank((String)helpDefinitionUrl)) {
            return "";
        }
        return Utilities.substituteConfigParameters(helpDefinitionUrl);
    }

    public String getUnresolvedDocSearchHelpUrl() {
        return this.unresolvedDocSearchHelpUrl;
    }

    public void setUnresolvedDocSearchHelpUrl(String unresolvedDocSearchHelpUrl) {
        this.unresolvedDocSearchHelpUrl = unresolvedDocSearchHelpUrl;
    }

    public String getDocSearchHelpUrl() {
        return this.resolveHelpUrl(this.getUnresolvedDocSearchHelpUrl());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PostProcessor getPostProcessor() {
        String pname = this.getPostProcessorName();
        if (StringUtils.equals((String)pname, (String)"none")) {
            return new DefaultPostProcessor();
        }
        if (StringUtils.isBlank((String)pname)) {
            if (this.getParentDocType() != null) {
                return this.getParentDocType().getPostProcessor();
            }
            return new DefaultPostProcessor();
        }
        ObjectDefinition objDef = this.getObjectDefinition(pname);
        Object postProcessor = GlobalResourceLoader.getObject((ObjectDefinition)objDef);
        if (postProcessor == null) {
            throw new WorkflowRuntimeException("Could not locate PostProcessor in this JVM or at application id " + this.getApplicationId() + ": " + pname);
        }
        return (PostProcessor)postProcessor;
    }

    protected String getInheritedPostProcessorName(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getPostProcessorName())) {
            return this.getPostProcessorName();
        }
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)this.getParentDocType())) {
            String parentValue = this.getParentDocType().getPostProcessorName();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return this.getParentDocType().getInheritedPostProcessorName(forDisplayPurposes);
        }
        return null;
    }

    public String getPostProcessorName() {
        return this.postProcessorName;
    }

    public void setPostProcessorName(String postProcessorName) {
        this.postProcessorName = postProcessorName;
    }

    public String getDisplayablePostProcessorName() {
        return this.getInheritedPostProcessorName(true);
    }

    public void setDisplayablePostProcessorName(String displayablePostProcessorName) {
    }

    public String getPreviousVersionId() {
        return this.previousVersionId;
    }

    public void setPreviousVersionId(String previousVersionId) {
        this.previousVersionId = previousVersionId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setDocumentTypeId(String docTypeGrpId) {
        this.documentTypeId = docTypeGrpId;
    }

    public String getId() {
        return this.getDocumentTypeId();
    }

    public Object copy(boolean preserveKeys) {
        throw new UnsupportedOperationException("The copy method is deprecated and unimplemented!");
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public DocumentTypePolicy getPolicyByName(String policyName, Boolean defaultValue) {
        DocumentTypePolicy policy2;
        for (DocumentTypePolicy policy2 : this.getDocumentTypePolicies()) {
            if (!policyName.equals(policy2.getPolicyName())) continue;
            policy2.setInheritedFlag(Boolean.FALSE);
            return policy2;
        }
        if (this.getParentDocType() != null) {
            policy2 = this.getParentDocType().getPolicyByName(policyName, defaultValue);
            policy2.setInheritedFlag(Boolean.TRUE);
            if (policy2.getPolicyValue() == null) {
                policy2.setPolicyValue(Boolean.TRUE);
            }
            return policy2;
        }
        policy2 = new DocumentTypePolicy();
        policy2.setPolicyName(policyName);
        policy2.setInheritedFlag(Boolean.FALSE);
        policy2.setPolicyValue(defaultValue);
        return policy2;
    }

    public DocumentTypePolicy getPolicyByName(String policyName, String defaultValue) {
        DocumentTypePolicy policy2;
        for (DocumentTypePolicy policy2 : this.getDocumentTypePolicies()) {
            if (!policyName.equals(policy2.getPolicyName())) continue;
            policy2.setInheritedFlag(Boolean.FALSE);
            return policy2;
        }
        if (this.getParentDocType() != null) {
            policy2 = this.getParentDocType().getPolicyByName(policyName, defaultValue);
            policy2.setInheritedFlag(Boolean.TRUE);
            if (policy2.getPolicyValue() == null) {
                policy2.setPolicyValue(Boolean.TRUE);
            }
            return policy2;
        }
        policy2 = new DocumentTypePolicy();
        policy2.setPolicyName(policyName);
        policy2.setInheritedFlag(Boolean.FALSE);
        policy2.setPolicyValue(Boolean.TRUE);
        policy2.setPolicyStringValue(defaultValue);
        return policy2;
    }

    private DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    public Group getSuperUserWorkgroup() {
        Group superUserWorkgroup = this.getSuperUserWorkgroupNoInheritence();
        if (superUserWorkgroup == null && this.getParentDocType() != null) {
            return this.getParentDocType().getSuperUserWorkgroup();
        }
        return superUserWorkgroup;
    }

    public Group getSuperUserWorkgroupNoInheritence() {
        if (this.workgroupId == null) {
            return null;
        }
        return this.getGroupService().getGroup(this.workgroupId);
    }

    public void setSuperUserWorkgroupNoInheritence(Group suWorkgroup) {
        this.workgroupId = null;
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)suWorkgroup)) {
            this.workgroupId = suWorkgroup.getId();
        }
    }

    public void setSuperUserWorkgroupIdNoInheritence(String suWorkgroupId) {
        this.workgroupId = suWorkgroupId;
    }

    public boolean isSuperUserGroupDefined() {
        if (this.workgroupId == null) {
            return this.getParentDocType() != null && this.getParentDocType().isSuperUserGroupDefined();
        }
        return true;
    }

    public DocumentType getPreviousVersion() {
        return this.getDocumentTypeService().findById(this.previousVersionId);
    }

    public Group getBlanketApproveWorkgroup() {
        if (StringUtils.isBlank((String)this.blanketApproveWorkgroupId)) {
            return null;
        }
        return this.getGroupService().getGroup(this.blanketApproveWorkgroupId);
    }

    public void setBlanketApproveWorkgroup(Group blanketApproveWorkgroup) {
        this.blanketApproveWorkgroupId = null;
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)blanketApproveWorkgroup)) {
            this.blanketApproveWorkgroupId = blanketApproveWorkgroup.getId();
        }
    }

    public String getBlanketApprovePolicy() {
        return this.blanketApprovePolicy;
    }

    public void setBlanketApprovePolicy(String blanketApprovePolicy) {
        this.blanketApprovePolicy = blanketApprovePolicy;
    }

    public Group getBlanketApproveWorkgroupWithInheritance() {
        if (this.getParentDocType() != null && this.blanketApproveWorkgroupId == null) {
            return this.getParentDocType().getBlanketApproveWorkgroupWithInheritance();
        }
        if (this.blanketApproveWorkgroupId != null) {
            return this.getGroupService().getGroup(this.blanketApproveWorkgroupId);
        }
        return null;
    }

    public boolean isBlanketApprover(String principalId) {
        if ("none".equalsIgnoreCase(this.getBlanketApprovePolicy())) {
            return false;
        }
        if ("any".equalsIgnoreCase(this.getBlanketApprovePolicy())) {
            return true;
        }
        if (this.blanketApproveWorkgroupId != null) {
            return this.getGroupService().isMemberOfGroup(principalId, this.blanketApproveWorkgroupId);
        }
        DocumentType parentDoc = this.getParentDocType();
        if (parentDoc != null) {
            return parentDoc.isBlanketApprover(principalId);
        }
        return false;
    }

    public boolean isBlanketApproveGroupDefined() {
        if (StringUtils.isBlank((String)this.getBlanketApprovePolicy()) && this.blanketApproveWorkgroupId == null) {
            return this.getParentDocType() != null && this.getParentDocType().isBlanketApproveGroupDefined();
        }
        return true;
    }

    public String getReportingWorkgroupId() {
        return this.reportingWorkgroupId;
    }

    public void setReportingWorkgroupId(String reportingWorkgroupId) {
        this.reportingWorkgroupId = reportingWorkgroupId;
    }

    public Group getReportingWorkgroup() {
        if (StringUtils.isBlank((String)this.reportingWorkgroupId)) {
            return null;
        }
        return this.getGroupService().getGroup(this.reportingWorkgroupId);
    }

    public void setReportingWorkgroup(Group reportingWorkgroup) {
        this.reportingWorkgroupId = null;
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)reportingWorkgroup)) {
            this.reportingWorkgroupId = reportingWorkgroup.getId();
        }
    }

    public Group getDefaultExceptionWorkgroup() {
        return this.defaultExceptionWorkgroup;
    }

    public void setDefaultExceptionWorkgroup(Group defaultExceptionWorkgroup) {
        this.defaultExceptionWorkgroup = defaultExceptionWorkgroup;
    }

    public CustomActionListAttribute getCustomActionListAttribute() throws ResourceUnavailableException {
        CustomActionListAttribute result = null;
        RuleAttribute customActionListRuleAttribute = this.getCustomActionListRuleAttribute();
        if (customActionListRuleAttribute != null) {
            try {
                ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(customActionListRuleAttribute.getId());
                if (extensionDefinition != null) {
                    result = (CustomActionListAttribute)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition, (String)customActionListRuleAttribute.getApplicationId());
                } else {
                    LOG.warn((Object)("Could not load ExtensionDefinition for " + (Object)((Object)customActionListRuleAttribute)));
                }
            }
            catch (RiceRemoteServiceConnectionException e) {
                LOG.warn((Object)("Unable to connect to load custom action list attribute for " + (Object)((Object)customActionListRuleAttribute)), (Throwable)e);
            }
        }
        return result;
    }

    public CustomEmailAttribute getCustomEmailAttribute() throws ResourceUnavailableException {
        ObjectDefinition objDef = this.getAttributeObjectDefinition("EmailAttribute");
        if (objDef == null) {
            return null;
        }
        return (CustomEmailAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
    }

    public ObjectDefinition getAttributeObjectDefinition(String typeCode) {
        Iterator<DocumentTypeAttributeBo> iter = this.getDocumentTypeAttributes().iterator();
        while (iter.hasNext()) {
            RuleAttribute attribute = iter.next().getRuleAttribute();
            if (!attribute.getType().equals(typeCode)) continue;
            return this.getAttributeObjectDefinition(attribute);
        }
        if (this.getParentDocType() != null) {
            return this.getParentDocType().getAttributeObjectDefinition(typeCode);
        }
        return null;
    }

    public ObjectDefinition getAttributeObjectDefinition(RuleAttribute ruleAttribute) {
        if (ruleAttribute.getApplicationId() == null) {
            return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), this.getApplicationId());
        }
        return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), ruleAttribute.getApplicationId());
    }

    public CustomNoteAttribute getCustomNoteAttribute() throws ResourceUnavailableException {
        ObjectDefinition objDef = this.getAttributeObjectDefinition("NoteAttribute");
        if (objDef == null) {
            String defaultNoteClass = ConfigContext.getCurrentContextConfig().getDefaultKewNoteClass();
            if (defaultNoteClass == null && org.kuali.rice.krad.util.ObjectUtils.isNull((Object)(defaultNoteClass = ConfigContext.getCurrentContextConfig().getDefaultKewNoteClass()))) {
                return null;
            }
            objDef = new ObjectDefinition(defaultNoteClass);
        }
        return (CustomNoteAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
    }

    public ObjectDefinition getObjectDefinition(String objectName) {
        return new ObjectDefinition(objectName, this.getApplicationId());
    }

    public boolean isRouteInherited() {
        return this.processes.isEmpty() && this.getParentDocType() != null;
    }

    public DocumentType getRouteDefiningDocumentType() {
        if (this.isRouteInherited()) {
            return this.getParentDocType().getRouteDefiningDocumentType();
        }
        return this;
    }

    public boolean isDocTypeActive() {
        if (!this.getActive().booleanValue()) {
            return false;
        }
        return this.getParentDocType() == null || this.getParentActiveInd(this.getParentDocType());
    }

    private boolean getParentActiveInd(DocumentType parentDocType) {
        if (parentDocType.getActive() == null || parentDocType.getActive().booleanValue()) {
            if (parentDocType.getParentDocType() != null) {
                return this.getParentActiveInd(parentDocType.getParentDocType());
            }
            return true;
        }
        return false;
    }

    public void setDocumentTypeAttributes(List<DocumentTypeAttributeBo> documentTypeAttributes) {
        this.documentTypeAttributes = documentTypeAttributes;
    }

    public List<DocumentTypeAttributeBo> getDocumentTypeAttributes() {
        return this.documentTypeAttributes;
    }

    public void addProcess(ProcessDefinitionBo process) {
        this.processes.add(process);
    }

    public List getProcesses() {
        if (this.processes.isEmpty() && this.getParentDocType() != null) {
            return this.getParentProcesses(this.getParentDocType());
        }
        return Collections.unmodifiableList(this.processes);
    }

    public void setProcesses(List routeNodes) {
        this.processes = routeNodes;
    }

    private List getParentProcesses(DocumentType parent) {
        List parentProcesses = parent.getProcesses();
        if (parentProcesses == null) {
            parentProcesses = this.getParentProcesses(parent.getParentDocType());
        }
        return parentProcesses;
    }

    public ProcessDefinitionBo getPrimaryProcess() {
        for (ProcessDefinitionBo process : this.getProcesses()) {
            if (!process.isInitial()) continue;
            return process;
        }
        return null;
    }

    public ProcessDefinitionBo getNamedProcess(String name) {
        for (ProcessDefinitionBo process : this.getProcesses()) {
            if (!ObjectUtils.equals((Object)name, (Object)process.getName())) continue;
            return process;
        }
        return null;
    }

    public String getRoutingVersion() {
        return this.routingVersion;
    }

    public void setRoutingVersion(String routingVersion) {
        this.routingVersion = routingVersion;
    }

    public String getActualNotificationFromAddress() {
        return this.actualNotificationFromAddress;
    }

    public void setActualNotificationFromAddress(String actualNotificationFromAddress) {
        this.actualNotificationFromAddress = actualNotificationFromAddress;
    }

    public String getDisplayableNotificationFromAddress() {
        return this.getNotificationFromAddress(true);
    }

    public void setDisplayableNotificationFromAddress(String displayableNotificationFromAddress) {
    }

    public String getNotificationFromAddress() {
        return this.getNotificationFromAddress(false);
    }

    protected String getNotificationFromAddress(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getActualNotificationFromAddress())) {
            return this.getActualNotificationFromAddress();
        }
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)this.getParentDocType())) {
            String parentNotificationFromAddress = this.getParentDocType().getActualNotificationFromAddress();
            if (StringUtils.isNotBlank((String)parentNotificationFromAddress)) {
                if (forDisplayPurposes) {
                    parentNotificationFromAddress = parentNotificationFromAddress + " (Inherited from Parent)";
                }
                return parentNotificationFromAddress;
            }
            return this.getParentDocType().getNotificationFromAddress(forDisplayPurposes);
        }
        return null;
    }

    public void setNotificationFromAddress(String notificationFromAddress) {
        this.setActualNotificationFromAddress(notificationFromAddress);
    }

    public boolean isParentOf(DocumentType documentType) {
        for (DocumentType child : this.getChildrenDocTypes()) {
            if (!child.getName().equals(documentType.getName()) && !child.isParentOf(documentType)) continue;
            return true;
        }
        return false;
    }

    public String getLookupParentName() {
        DocumentType parent = this.getParentDocType();
        if (parent == null) {
            return "Root";
        }
        return parent.getName();
    }

    public boolean isSuperUser(String principalId) {
        Group workgroup = this.getSuperUserWorkgroup();
        if (workgroup == null) {
            return false;
        }
        return this.getGroupService().isMemberOfGroup(principalId, workgroup.getId());
    }

    public boolean hasPreviousVersion() {
        if (this.documentTypeId == null) {
            return false;
        }
        return !this.documentTypeId.equals(this.previousVersionId);
    }

    public String getActualApplicationId() {
        return this.actualApplicationId;
    }

    public void setActualApplicationId(String actualApplicationId) {
        this.actualApplicationId = actualApplicationId;
    }

    @Override
    public String getApplicationId() {
        return this.getApplicationId(false);
    }

    protected String getApplicationId(boolean forDisplayPurposes) {
        if (StringUtils.isNotBlank((String)this.getActualApplicationId())) {
            return this.getActualApplicationId();
        }
        if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)this.getParentDocType())) {
            String parentValue = this.getParentDocType().getActualApplicationId();
            if (StringUtils.isNotBlank((String)parentValue)) {
                if (forDisplayPurposes) {
                    parentValue = parentValue + " (Inherited from Parent)";
                }
                return parentValue;
            }
            return this.getParentDocType().getApplicationId(forDisplayPurposes);
        }
        String defaultValue = CoreConfigHelper.getApplicationId();
        if (forDisplayPurposes) {
            defaultValue = defaultValue + " (System Default)";
        }
        return defaultValue;
    }

    public String getDisplayableApplicationId() {
        return this.getApplicationId(true);
    }

    public String getCustomEmailStylesheet() {
        return this.customEmailStylesheet;
    }

    public void setCustomEmailStylesheet(String customEmailStylesheet) {
        this.customEmailStylesheet = customEmailStylesheet;
    }

    public String getBlanketApproveWorkgroupId() {
        return this.blanketApproveWorkgroupId;
    }

    public void setBlanketApproveWorkgroupId(String blanketApproveWorkgroupId) {
        this.blanketApproveWorkgroupId = blanketApproveWorkgroupId;
    }

    public Boolean getApplyRetroactively() {
        return this.applyRetroactively;
    }

    public void setApplyRetroactively(Boolean applyRetroactively) {
        this.applyRetroactively = applyRetroactively;
    }

    private GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    @Override
    public boolean isActive() {
        boolean bRet = false;
        if (this.active != null) {
            bRet = this.active;
        }
        return bRet;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Integer getDocumentTypeVersion() {
        return this.version;
    }

    public String getParentId() {
        return this.docTypeParentId;
    }

    public String getBlanketApproveGroupId() {
        return this.blanketApproveWorkgroupId;
    }

    public String getSuperUserGroupId() {
        return this.workgroupId;
    }

    public String getAuthorizer() {
        String result = this.authorizer;
        if (StringUtils.isBlank((String)result) && this.getParentDocType() != null) {
            return this.getParentDocType().getAuthorizer();
        }
        return result;
    }

    public void setAuthorizer(String authorizer) {
        this.authorizer = authorizer;
    }

    public static org.kuali.rice.kew.api.doctype.DocumentType to(DocumentType documentTypeBo) {
        if (documentTypeBo == null) {
            return null;
        }
        DocumentType.Builder builder = DocumentType.Builder.create((DocumentTypeContract)documentTypeBo);
        builder.setApplicationId(documentTypeBo.getActualApplicationId());
        return builder.build();
    }

    public static DocumentType from(DocumentTypeContract dt) {
        if (dt == null) {
            return null;
        }
        DocumentType ebo = new DocumentType();
        ebo.setDocumentTypeId(dt.getId());
        ebo.setActive(dt.isActive());
        ebo.setActualApplicationId(dt.getApplicationId());
        ebo.setBlanketApproveWorkgroupId(dt.getBlanketApproveGroupId());
        ebo.setCurrentInd(dt.isCurrent());
        ebo.setDescription(dt.getDescription());
        ebo.setVersionNumber(dt.getVersionNumber());
        ebo.setVersion(dt.getDocumentTypeVersion());
        ebo.setUnresolvedDocHandlerUrl(dt.getUnresolvedDocHandlerUrl());
        ebo.setUnresolvedDocSearchHelpUrl(dt.getDocSearchHelpUrl());
        ebo.setUnresolvedHelpDefinitionUrl(dt.getHelpDefinitionUrl());
        ebo.setLabel(dt.getLabel());
        ebo.setName(dt.getName());
        ebo.setDocTypeParentId(dt.getParentId());
        ebo.setPostProcessorName(dt.getPostProcessorName());
        ebo.setSuperUserWorkgroupIdNoInheritence(dt.getSuperUserGroupId());
        ArrayList<DocumentTypePolicy> policies = new ArrayList<DocumentTypePolicy>();
        if (dt.getPolicies() != null) {
            for (Map.Entry entry : dt.getPolicies().entrySet()) {
                policies.add(new DocumentTypePolicy(((org.kuali.rice.kew.api.doctype.DocumentTypePolicy)entry.getKey()).getCode(), Boolean.TRUE.toString().equals(entry.getValue())));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dt.getDocumentTypeAttributes())) {
            ArrayList<DocumentTypeAttributeBo> attributes = new ArrayList<DocumentTypeAttributeBo>();
            for (DocumentTypeAttributeContract attr : dt.getDocumentTypeAttributes()) {
                attributes.add(DocumentTypeAttributeBo.from(DocumentTypeAttribute.Builder.create((DocumentTypeAttributeContract)attr).build()));
            }
        }
        ebo.setDocumentTypePolicies(policies);
        ebo.setAuthorizer(dt.getAuthorizer());
        return ebo;
    }

    public static final class ExtensionHolder<T> {
        private final ExtensionDefinition extensionDefinition;
        private final T extension;

        public ExtensionHolder(ExtensionDefinition extensionDefinition, T extension) {
            this.extensionDefinition = extensionDefinition;
            this.extension = extension;
        }

        public ExtensionDefinition getExtensionDefinition() {
            return this.extensionDefinition;
        }

        public T getExtension() {
            return this.extension;
        }
    }
}

