/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RequestActivationNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Document;

public class FYIByUniversityId
extends RequestActivationNode {
    private static final Logger LOG = Logger.getLogger(FYIByUniversityId.class);

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        LOG.debug((Object)"processing FYIByUniversityId node");
        Element rootElement = FYIByUniversityId.getRootElement(new StandardDocumentContent(context.getDocument().getDocContent()));
        Collection fieldElements = XmlHelper.findElements((Element)rootElement, (String)"field");
        for (Element field : fieldElements) {
            Element version = field.getParentElement();
            if (!version.getAttribute("current").getValue().equals("true")) continue;
            LOG.debug((Object)("Looking for studentUid field:  " + field.getAttributeValue("name")));
            if (field.getAttribute("name") == null || !field.getAttributeValue("name").equals("studentUid")) continue;
            String employeeId = field.getChildText("value");
            LOG.debug((Object)("Should send an FYI to employee ID:  " + employeeId));
            if (StringUtils.isBlank((String)employeeId)) continue;
            Person person = KimApiServiceLocator.getPersonService().getPerson(employeeId);
            if (person == null) {
                throw new WorkflowRuntimeException("Failed to locate a Person with the given employee ID: " + employeeId);
            }
            if (!context.isSimulation()) {
                KEWServiceLocator.getWorkflowDocumentService().adHocRouteDocumentToPrincipal(person.getPrincipalId(), context.getDocument(), "F", null, null, "Notification Request", person.getPrincipalId(), "Notification Request", true, null);
            }
            LOG.debug((Object)("Sent FYI using the adHocRouteDocumentToPrincipal function to UniversityID:  " + person.getEmployeeId()));
            break;
        }
        return super.process(context, helper);
    }

    private static Element getRootElement(DocumentContent docContent) {
        Element rootElement = null;
        try {
            rootElement = XmlHelper.buildJDocument((Document)docContent.getDocument()).getRootElement();
        }
        catch (Exception e) {
            throw new WorkflowServiceErrorException("Invalid XML submitted", new ArrayList());
        }
        return rootElement;
    }

    protected Object getService(String serviceName) {
        return KEWServiceLocator.getService(serviceName);
    }
}

