/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.actionlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.ActionItemActionListExtension;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class ActionListServiceNewImpl
implements ActionListService {
    public Integer getUserActionItemCount(String principalId) {
        this.incomingParamCheck(principalId, "principalId");
        return KEWServiceLocator.getActionListService().getCount(principalId);
    }

    public List<org.kuali.rice.kew.api.action.ActionItem> getActionItemsForPrincipal(String principalId) {
        this.incomingParamCheck(principalId, "principalId");
        Collection<ActionItemActionListExtension> actionItems = KEWServiceLocator.getActionListService().getActionList(principalId, null);
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> actionItemVOs = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>(actionItems.size());
        for (ActionItem actionItem : actionItems) {
            actionItemVOs.add(ActionItem.to(actionItem));
        }
        return actionItemVOs;
    }

    public List<org.kuali.rice.kew.api.action.ActionItem> getAllActionItems(String documentId) {
        this.incomingParamCheck(documentId, "documentId");
        Collection<ActionItemActionListExtension> actionItems = KEWServiceLocator.getActionListService().getActionListForSingleDocument(documentId);
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> actionItemVOs = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>(actionItems.size());
        for (ActionItem actionItem : actionItems) {
            actionItemVOs.add(ActionItem.to(actionItem));
        }
        return actionItemVOs;
    }

    public List<org.kuali.rice.kew.api.action.ActionItem> getActionItems(String documentId, List<String> actionRequestedCodes) {
        this.incomingParamCheck(documentId, "documentId");
        List<org.kuali.rice.kew.api.action.ActionItem> actionItems = this.getAllActionItems(documentId);
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> matchingActionitems = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>();
        for (org.kuali.rice.kew.api.action.ActionItem actionItemVO : actionItems) {
            if (!actionRequestedCodes.contains(actionItemVO.getActionRequestCd())) continue;
            matchingActionitems.add(actionItemVO);
        }
        return matchingActionitems;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

