/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.note.Note;
import org.kuali.rice.kew.api.note.NoteContract;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity(name="org.kuali.rice.kew.notes.Note")
@Table(name="KREW_DOC_NTE_T")
@NamedQueries(value={@NamedQuery(name="KewNote.FindNoteByNoteId", query="select n from org.kuali.rice.kew.notes.Note as n where n.noteId = :noteId"), @NamedQuery(name="KewNote.FindNoteByDocumentId", query="select n from org.kuali.rice.kew.notes.Note as n where n.documentId = :documentId order by n.noteId")})
public class Note
implements Serializable,
NoteContract {
    private static final long serialVersionUID = -6136544551121011531L;
    @Id
    @GeneratedValue(generator="KREW_DOC_NTE_S")
    @GenericGenerator(name="KREW_DOC_NTE_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_DOC_NTE_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_NTE_ID")
    private String noteId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="AUTH_PRNCPL_ID")
    private String noteAuthorWorkflowId;
    @Column(name="CRT_DT")
    private Timestamp noteCreateDate;
    @Column(name="TXT")
    private String noteText;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=Attachment.class, mappedBy="note")
    @Fetch(value=FetchMode.SELECT)
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Transient
    private String noteAuthorEmailAddress;
    @Transient
    private String noteAuthorNetworkId;
    @Transient
    private String noteAuthorFullName;
    @Transient
    private Long noteCreateLongDate;
    @Transient
    private Boolean authorizedToEdit;
    @Transient
    private Boolean editingNote;

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public String getNoteAuthorWorkflowId() {
        return this.noteAuthorWorkflowId;
    }

    public void setNoteAuthorWorkflowId(String noteAuthorWorkflowId) {
        this.noteAuthorWorkflowId = noteAuthorWorkflowId;
    }

    public Timestamp getNoteCreateDate() {
        return this.noteCreateDate;
    }

    public void setNoteCreateDate(Timestamp noteCreateDate) {
        this.noteCreateDate = noteCreateDate;
    }

    public String getNoteId() {
        return this.noteId;
    }

    public void setNoteId(String noteId) {
        this.noteId = noteId;
    }

    public String getNoteText() {
        return this.noteText;
    }

    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getNoteAuthorEmailAddress() {
        return this.noteAuthorEmailAddress;
    }

    public void setNoteAuthorEmailAddress(String noteAuthorEmailAddress) {
        this.noteAuthorEmailAddress = noteAuthorEmailAddress;
    }

    public String getNoteAuthorFullName() {
        return this.noteAuthorFullName;
    }

    public void setNoteAuthorFullName(String noteAuthorFullName) {
        this.noteAuthorFullName = noteAuthorFullName;
    }

    public String getNoteAuthorNetworkId() {
        return this.noteAuthorNetworkId;
    }

    public void setNoteAuthorNetworkId(String noteAuthorNetworkId) {
        this.noteAuthorNetworkId = noteAuthorNetworkId;
    }

    public Long getNoteCreateLongDate() {
        return this.noteCreateLongDate;
    }

    public void setNoteCreateLongDate(Long noteCreateLongDate) {
        this.noteCreateLongDate = noteCreateLongDate;
    }

    public Boolean getAuthorizedToEdit() {
        return this.authorizedToEdit;
    }

    public void setAuthorizedToEdit(Boolean authorizedToEdit) {
        this.authorizedToEdit = authorizedToEdit;
    }

    public Boolean getEditingNote() {
        return this.editingNote;
    }

    public void setEditingNote(Boolean editingNote) {
        this.editingNote = editingNote;
    }

    public String getFormattedCreateDateTime() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        return dateFormat.format(date);
    }

    public String getFormattedCreateDate() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        DateFormat dateFormat = RiceConstants.getDefaultDateFormat();
        return dateFormat.format(date);
    }

    public String getFormattedCreateTime() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        DateFormat dateFormat = RiceConstants.getDefaultTimeFormat();
        return dateFormat.format(date);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public String getId() {
        if (this.getNoteId() == null) {
            return null;
        }
        return this.getNoteId().toString();
    }

    public Long getVersionNumber() {
        if (this.getLockVerNbr() == null) {
            return null;
        }
        return new Long(this.getLockVerNbr().longValue());
    }

    public String getAuthorPrincipalId() {
        return this.getNoteAuthorWorkflowId();
    }

    public DateTime getCreateDate() {
        if (this.getNoteCreateDate() == null) {
            return null;
        }
        return new DateTime(this.getNoteCreateDate().getTime());
    }

    public String getText() {
        return this.getNoteText();
    }

    public static org.kuali.rice.kew.api.note.Note to(Note note) {
        if (note == null) {
            return null;
        }
        return Note.Builder.create((NoteContract)note).build();
    }

    public static Note from(org.kuali.rice.kew.api.note.Note note) {
        if (note == null) {
            return null;
        }
        Note noteBo = new Note();
        if (note.getId() != null) {
            noteBo.setNoteId(note.getId());
        }
        noteBo.setDocumentId(note.getDocumentId());
        noteBo.setNoteAuthorWorkflowId(note.getAuthorPrincipalId());
        if (note.getCreateDate() != null) {
            noteBo.setNoteCreateDate(new Timestamp(note.getCreateDate().getMillis()));
        }
        noteBo.setNoteText(note.getText());
        if (note.getVersionNumber() != null) {
            noteBo.setLockVerNbr(note.getVersionNumber().intValue());
        }
        return noteBo;
    }
}

