/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.quicklinks.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ojb.broker.PersistenceBroker;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.quicklinks.ActionListStats;
import org.kuali.rice.kew.quicklinks.InitiatedDocumentType;
import org.kuali.rice.kew.quicklinks.WatchedDocument;
import org.kuali.rice.kew.quicklinks.dao.QuickLinksDAO;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class QuickLinksDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements QuickLinksDAO {
    @Override
    public List<ActionListStats> getActionListStats(final String principalId) {
        return (List)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement selectActionItems = null;
                Statement selectDocTypeLabel = null;
                ResultSet selectedActionItems = null;
                ResultSet selectedDocTypeLabel = null;
                ArrayList<ActionListStats> docTypes = new ArrayList<ActionListStats>();
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    selectActionItems = connection.prepareStatement("select DOC_TYP_NM, COUNT(*) from KREW_ACTN_ITM_T where PRNCPL_ID = ? and (dlgn_typ is null or dlgn_typ != '" + DelegationType.SECONDARY.getCode() + "') group by DOC_TYP_NM");
                    selectDocTypeLabel = connection.prepareStatement("select LBL from KREW_DOC_TYP_T WHERE DOC_TYP_NM = ? and CUR_IND = 1");
                    selectActionItems.setString(1, principalId);
                    selectedActionItems = selectActionItems.executeQuery();
                    while (selectedActionItems.next()) {
                        String docTypeName = selectedActionItems.getString(1);
                        int count = selectedActionItems.getInt(2);
                        selectDocTypeLabel.setString(1, docTypeName);
                        selectedDocTypeLabel = selectDocTypeLabel.executeQuery();
                        if (!selectedDocTypeLabel.next()) continue;
                        docTypes.add(new ActionListStats(docTypeName, selectedDocTypeLabel.getString(1), count));
                    }
                    Collections.sort(docTypes);
                    ArrayList<ActionListStats> arrayList = docTypes;
                    return arrayList;
                }
                catch (Exception e) {
                    throw new WorkflowRuntimeException("Error getting action list stats for user: " + principalId, (Throwable)e);
                }
                finally {
                    if (selectActionItems != null) {
                        try {
                            selectActionItems.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (selectDocTypeLabel != null) {
                        try {
                            selectDocTypeLabel.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (selectedActionItems != null) {
                        try {
                            selectedActionItems.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (selectedDocTypeLabel != null) {
                        try {
                            selectedDocTypeLabel.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    @Override
    public List<InitiatedDocumentType> getInitiatedDocumentTypesList(final String principalId) {
        return (List)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement selectDistinctDocumentTypes = null;
                ResultSet selectedDistinctDocumentTypes = null;
                ArrayList<InitiatedDocumentType> documentTypesByName = new ArrayList<InitiatedDocumentType>();
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    String sql = "select distinct B.DOC_TYP_NM, B.LBL from KREW_DOC_HDR_T A, KREW_DOC_TYP_T B where A.INITR_PRNCPL_ID = ? and A.DOC_TYP_ID = B.DOC_TYP_ID and B.ACTV_IND = 1 and B.CUR_IND = 1 order by upper(B.LBL)";
                    selectDistinctDocumentTypes = connection.prepareStatement(sql);
                    selectDistinctDocumentTypes.setString(1, principalId);
                    selectedDistinctDocumentTypes = selectDistinctDocumentTypes.executeQuery();
                    String documentNames = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "QuickLink", "RESTRICT_DOCUMENT_TYPES");
                    if (documentNames != null) {
                        documentNames = documentNames.trim();
                    }
                    if (documentNames == null || "none".equals(documentNames)) {
                        documentNames = "";
                    }
                    ArrayList<String> docTypesToRestrict = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(documentNames, ",");
                    while (st.hasMoreTokens()) {
                        docTypesToRestrict.add(st.nextToken());
                    }
                    while (selectedDistinctDocumentTypes.next()) {
                        DocumentType docType;
                        DocumentTypePolicy quickInitiatePolicy;
                        String docTypeName = selectedDistinctDocumentTypes.getString(1);
                        String docTypeTopParent = "";
                        int firstPeriod = docTypeName.indexOf(".");
                        docTypeTopParent = firstPeriod == -1 ? docTypeName.substring(0) : docTypeName.substring(0, firstPeriod);
                        if (docTypesToRestrict.contains(docTypeTopParent) || !(quickInitiatePolicy = (docType = KEWServiceLocator.getDocumentTypeService().findByName(docTypeName)).getSupportsQuickInitiatePolicy()).getPolicyValue().booleanValue()) continue;
                        documentTypesByName.add(new InitiatedDocumentType(docTypeName, selectedDistinctDocumentTypes.getString(2)));
                    }
                    ArrayList<InitiatedDocumentType> arrayList = documentTypesByName;
                    return arrayList;
                }
                catch (Exception e) {
                    throw new WorkflowRuntimeException("Error getting initiated document types for user: " + principalId, (Throwable)e);
                }
                finally {
                    if (selectDistinctDocumentTypes != null) {
                        try {
                            selectDistinctDocumentTypes.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (selectedDistinctDocumentTypes != null) {
                        try {
                            selectedDistinctDocumentTypes.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    @Override
    public List<KeyValue> getNamedSearches(String principalId) {
        return this.getDocumentSearchService().getNamedSearches(principalId);
    }

    @Override
    public List<KeyValue> getRecentSearches(String principalId) {
        return this.getDocumentSearchService().getMostRecentSearches(principalId);
    }

    @Override
    public List<WatchedDocument> getWatchedDocuments(final String principalId) {
        return (List)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                ArrayList<WatchedDocument> watchedDocuments = new ArrayList<WatchedDocument>();
                Statement selectWatchedDocuments = null;
                ResultSet selectedWatchedDocuments = null;
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    selectWatchedDocuments = connection.prepareStatement("select DOC_HDR_ID, DOC_HDR_STAT_CD, TTL, CRTE_DT from KREW_DOC_HDR_T where INITR_PRNCPL_ID = ? and DOC_HDR_STAT_CD in ('R','E') order by CRTE_DT desc");
                    selectWatchedDocuments.setString(1, principalId);
                    selectedWatchedDocuments = selectWatchedDocuments.executeQuery();
                    while (selectedWatchedDocuments.next()) {
                        watchedDocuments.add(new WatchedDocument(selectedWatchedDocuments.getString(1), (String)KewApiConstants.DOCUMENT_STATUSES.get(selectedWatchedDocuments.getString(2)), selectedWatchedDocuments.getString(3)));
                    }
                    ArrayList<WatchedDocument> arrayList = watchedDocuments;
                    return arrayList;
                }
                catch (Exception e) {
                    throw new WorkflowRuntimeException("Error getting initiated document types for user: " + principalId, (Throwable)e);
                }
                finally {
                    if (selectWatchedDocuments != null) {
                        try {
                            selectWatchedDocuments.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (selectedWatchedDocuments != null) {
                        try {
                            selectedWatchedDocuments.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    public DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    public DocumentSearchService getDocumentSearchService() {
        return (DocumentSearchService)KEWServiceLocator.getService("enDocumentSearchService");
    }
}

