/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.role.service.RoleService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.FlexRM;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class RoleServiceImpl
implements RoleService {
    private static final Logger LOG = Logger.getLogger(RoleServiceImpl.class);

    @Override
    public void reResolveRole(DocumentType documentType, String roleName) {
        String infoString = "documentType=" + (documentType == null ? null : documentType.getName()) + ", role=" + roleName;
        if (documentType == null || StringUtils.isEmpty((String)roleName)) {
            throw new IllegalArgumentException("Cannot pass null or empty arguments to reResolveQualifiedRole: " + infoString);
        }
        LOG.debug((Object)("Re-resolving role asynchronously for " + infoString));
        HashSet documentIds = new HashSet();
        this.findAffectedDocuments(documentType, roleName, null, documentIds);
        LOG.debug((Object)(documentIds.size() + " documents were affected by this re-resolution, requeueing with the RolePokerQueue"));
        for (String documentId : documentIds) {
            String applicationId = KEWServiceLocator.getRouteHeaderService().getApplicationIdByDocumentId(documentId);
            RolePokerQueue rolePokerQueue = KewApiServiceLocator.getRolePokerQueue((String)documentId, (String)applicationId);
            rolePokerQueue.reResolveRole(documentId, roleName);
        }
    }

    @Override
    public void reResolveQualifiedRole(DocumentType documentType, String roleName, String qualifiedRoleNameLabel) {
        String infoString = "documentType=" + (documentType == null ? null : documentType.getName()) + ", role=" + roleName + ", qualifiedRole=" + qualifiedRoleNameLabel;
        if (documentType == null || StringUtils.isEmpty((String)roleName) || StringUtils.isEmpty((String)qualifiedRoleNameLabel)) {
            throw new IllegalArgumentException("Cannot pass null or empty arguments to reResolveQualifiedRole: " + infoString);
        }
        LOG.debug((Object)("Re-resolving qualified role asynchronously for " + infoString));
        HashSet documentIds = new HashSet();
        this.findAffectedDocuments(documentType, roleName, qualifiedRoleNameLabel, documentIds);
        LOG.debug((Object)(documentIds.size() + " documents were affected by this re-resolution, requeueing with the RolePokerQueue"));
        for (String documentId : documentIds) {
            String applicationId = KEWServiceLocator.getRouteHeaderService().getApplicationIdByDocumentId(documentId);
            RolePokerQueue rolePokerQueue = KewApiServiceLocator.getRolePokerQueue((String)documentId, (String)applicationId);
            rolePokerQueue.reResolveQualifiedRole(documentId, roleName, qualifiedRoleNameLabel);
        }
    }

    @Override
    public void reResolveQualifiedRole(DocumentRouteHeaderValue routeHeader, String roleName, String qualifiedRoleNameLabel) {
        String infoString = "routeHeader=" + (routeHeader == null ? null : routeHeader.getDocumentId()) + ", role=" + roleName + ", qualifiedRole=" + qualifiedRoleNameLabel;
        if (routeHeader == null || StringUtils.isEmpty((String)roleName) || StringUtils.isEmpty((String)qualifiedRoleNameLabel)) {
            throw new IllegalArgumentException("Cannot pass null arguments to reResolveQualifiedRole: " + infoString);
        }
        LOG.debug((Object)("Re-resolving qualified role synchronously for " + infoString));
        List nodeInstances = this.findNodeInstances(routeHeader, roleName);
        int requestsGenerated = 0;
        if (!nodeInstances.isEmpty()) {
            this.deletePendingRoleRequests(routeHeader.getDocumentId(), roleName, qualifiedRoleNameLabel);
            for (RouteNodeInstance nodeInstance : nodeInstances) {
                RuleTemplateBo ruleTemplate = nodeInstance.getRouteNode().getRuleTemplate();
                FlexRM flexRM = new FlexRM();
                RouteContext context = RouteContext.getCurrentRouteContext();
                context.setDocument(routeHeader);
                context.setNodeInstance(nodeInstance);
                try {
                    List<ActionRequestValue> actionRequests = flexRM.getActionRequests(routeHeader, nodeInstance, ruleTemplate.getName());
                    for (ActionRequestValue actionRequest : actionRequests) {
                        if (!roleName.equals(actionRequest.getRoleName()) || !qualifiedRoleNameLabel.equals(actionRequest.getQualifiedRoleNameLabel())) continue;
                        actionRequest = KEWServiceLocator.getActionRequestService().initializeActionRequestGraph(actionRequest, routeHeader, nodeInstance);
                        KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest);
                        ++requestsGenerated;
                    }
                }
                catch (Exception e) {
                    RouteContext.clearCurrentRouteContext();
                }
            }
        }
        LOG.debug((Object)("Generated " + requestsGenerated + " action requests after re-resolve: " + infoString));
        this.requeueDocument(routeHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reResolveRole(DocumentRouteHeaderValue routeHeader, String roleName) {
        String infoString = "routeHeader=" + (routeHeader == null ? null : routeHeader.getDocumentId()) + ", role=" + roleName;
        if (routeHeader == null || StringUtils.isEmpty((String)roleName)) {
            throw new RiceIllegalArgumentException("Cannot pass null arguments to reResolveQualifiedRole: " + infoString);
        }
        LOG.debug((Object)("Re-resolving role synchronously for " + infoString));
        List nodeInstances = this.findNodeInstances(routeHeader, roleName);
        int requestsGenerated = 0;
        if (!nodeInstances.isEmpty()) {
            this.deletePendingRoleRequests(routeHeader.getDocumentId(), roleName, null);
            for (RouteNodeInstance nodeInstance : nodeInstances) {
                RuleTemplateBo ruleTemplate = nodeInstance.getRouteNode().getRuleTemplate();
                FlexRM flexRM = new FlexRM();
                RouteContext context = RouteContext.getCurrentRouteContext();
                context.setDocument(routeHeader);
                context.setNodeInstance(nodeInstance);
                try {
                    List<ActionRequestValue> actionRequests = flexRM.getActionRequests(routeHeader, nodeInstance, ruleTemplate.getName());
                    for (ActionRequestValue actionRequest : actionRequests) {
                        if (!roleName.equals(actionRequest.getRoleName())) continue;
                        actionRequest = KEWServiceLocator.getActionRequestService().initializeActionRequestGraph(actionRequest, routeHeader, nodeInstance);
                        KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest);
                        ++requestsGenerated;
                    }
                }
                finally {
                    RouteContext.clearCurrentRouteContext();
                }
            }
        }
        LOG.debug((Object)("Generated " + requestsGenerated + " action requests after re-resolve: " + infoString));
        this.requeueDocument(routeHeader);
    }

    private void findAffectedDocuments(DocumentType documentType, String roleName, String qualifiedRoleNameLabel, Set documentIds) {
        List<ActionRequestValue> pendingRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(documentType.getDocumentTypeId());
        for (ActionRequestValue actionRequest : pendingRequests) {
            if (!roleName.equals(actionRequest.getRoleName()) || qualifiedRoleNameLabel != null && !qualifiedRoleNameLabel.equals(actionRequest.getQualifiedRoleNameLabel())) continue;
            documentIds.add(actionRequest.getDocumentId());
        }
        for (DocumentType childDocumentType : documentType.getChildrenDocTypes()) {
            this.findAffectedDocuments(childDocumentType, roleName, qualifiedRoleNameLabel, documentIds);
        }
    }

    private void deletePendingRoleRequests(String documentId, String roleName, String qualifiedRoleNameLabel) {
        List<ActionRequestValue> pendingRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
        pendingRequests = KEWServiceLocator.getActionRequestService().getRootRequests(pendingRequests);
        ArrayList<ActionRequestValue> requestsToDelete = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : pendingRequests) {
            if (!roleName.equals(actionRequest.getRoleName()) || qualifiedRoleNameLabel != null && !qualifiedRoleNameLabel.equals(actionRequest.getQualifiedRoleNameLabel())) continue;
            requestsToDelete.add(actionRequest);
        }
        LOG.debug((Object)("Deleting " + requestsToDelete.size() + " action requests for roleName=" + roleName + ", qualifiedRoleNameLabel=" + qualifiedRoleNameLabel));
        Iterator<ActionRequestValue> iterator = requestsToDelete.iterator();
        while (iterator.hasNext()) {
            KEWServiceLocator.getActionRequestService().deleteActionRequestGraph(iterator.next());
        }
    }

    private List findNodeInstances(DocumentRouteHeaderValue routeHeader, String roleName) {
        ArrayList<RouteNodeInstance> nodeInstances = new ArrayList<RouteNodeInstance>();
        List<RouteNodeInstance> activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(routeHeader.getDocumentId());
        if (CollectionUtils.isEmpty(activeNodeInstances)) {
            throw new IllegalStateException("Document does not currently have any active nodes so re-resolving is not legal.");
        }
        for (RouteNodeInstance activeNodeInstance : activeNodeInstances) {
            RuleTemplateBo template = activeNodeInstance.getRouteNode().getRuleTemplate();
            if (!this.templateHasRole(template, roleName)) continue;
            nodeInstances.add(activeNodeInstance);
        }
        if (nodeInstances.isEmpty()) {
            throw new IllegalStateException("Could not locate given role to re-resolve: " + roleName);
        }
        return nodeInstances;
    }

    private boolean templateHasRole(RuleTemplateBo template, String roleName) {
        List<RuleTemplateAttributeBo> templateAttributes = template.getRuleTemplateAttributes();
        for (RuleTemplateAttributeBo templateAttribute : templateAttributes) {
            List<RoleName> roleNames = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRoleNames(templateAttribute);
            for (RoleName role : roleNames) {
                if (!role.getLabel().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    protected void requeueDocument(DocumentRouteHeaderValue document) {
        String applicationId = document.getDocumentType().getApplicationId();
        DocumentProcessingQueue documentProcessingQueue = KewApiServiceLocator.getDocumentProcessingQueue((String)document.getDocumentId(), (String)applicationId);
        documentProcessingQueue.process(document.getDocumentId());
    }
}

