/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.kew.api.document.DocumentStatusTransition;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_APP_DOC_STAT_TRAN_T")
public class DocumentStatusTransition
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = -2212481684546954746L;
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @GenericGenerator(name="KREW_DOC_HDR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_DOC_HDR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="APP_DOC_STAT_TRAN_ID")
    private String statusTransitionId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="APP_DOC_STAT_FROM")
    private String oldAppDocStatus;
    @Column(name="APP_DOC_STAT_TO")
    private String newAppDocStatus;
    @Column(name="STAT_TRANS_DATE")
    private Timestamp statusTransitionDate;

    public DocumentStatusTransition() {
    }

    public DocumentStatusTransition(String documentId, String oldStatus, String newStatus) {
        this.documentId = documentId;
        this.oldAppDocStatus = oldStatus;
        this.newAppDocStatus = newStatus;
        this.statusTransitionDate = new Timestamp(System.currentTimeMillis());
    }

    public String getStatusTransitionId() {
        return this.statusTransitionId;
    }

    public void setStatusTransitionId(String statusTransitionId) {
        this.statusTransitionId = statusTransitionId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getOldAppDocStatus() {
        return this.oldAppDocStatus;
    }

    public void setOldAppDocStatus(String oldAppDocStatus) {
        this.oldAppDocStatus = oldAppDocStatus;
    }

    public String getNewAppDocStatus() {
        return this.newAppDocStatus;
    }

    public void setNewAppDocStatus(String newAppDocStatus) {
        this.newAppDocStatus = newAppDocStatus;
    }

    public Timestamp getStatusTransitionDate() {
        return this.statusTransitionDate;
    }

    public void setStatusTransitionDate(Timestamp statusTransitionDate) {
        this.statusTransitionDate = statusTransitionDate;
    }

    public static DocumentStatusTransition from(org.kuali.rice.kew.api.document.DocumentStatusTransition im) {
        if (im == null) {
            return null;
        }
        DocumentStatusTransition transition = new DocumentStatusTransition(im.getDocumentId(), im.getOldStatus(), im.getNewStatus());
        transition.setStatusTransitionId(im.getId());
        if (im.getStatusTransitionDate() != null) {
            transition.setStatusTransitionDate(new Timestamp(im.getStatusTransitionDate().getMillis()));
        }
        return transition;
    }

    public static org.kuali.rice.kew.api.document.DocumentStatusTransition to(DocumentStatusTransition bo) {
        if (bo == null) {
            return null;
        }
        DocumentStatusTransition.Builder builder = DocumentStatusTransition.Builder.create((String)bo.getDocumentId(), (String)bo.getOldAppDocStatus(), (String)bo.getNewAppDocStatus());
        builder.setId(bo.getStatusTransitionId());
        if (bo.getStatusTransitionDate() != null) {
            builder.setStatusTransitionDate(new DateTime(bo.getStatusTransitionDate().getTime()));
        }
        return builder.build();
    }
}

