/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader.dao.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.LockingException;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.dao.DocumentRouteHeaderDAO;

public class DocumentRouteHeaderDAOJpaImpl
implements DocumentRouteHeaderDAO {
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;
    private static final Logger LOG = Logger.getLogger(DocumentRouteHeaderDAOJpaImpl.class);

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void saveRouteHeader(DocumentRouteHeaderValue routeHeader) {
        DocumentRouteHeaderValueContent documentContent = routeHeader.getDocumentContent();
        if (routeHeader.getDocumentId() == null) {
            this.entityManager.persist((Object)routeHeader);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)routeHeader);
        }
        documentContent.setDocumentId(routeHeader.getDocumentId());
        this.entityManager.merge((Object)documentContent);
    }

    @Override
    public DocumentRouteHeaderValueContent getContent(String documentId) {
        Query query = this.entityManager.createNamedQuery("DocumentRouteHeaderValueContent.FindByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        return (DocumentRouteHeaderValueContent)query.getSingleResult();
    }

    @Override
    public void clearRouteHeaderSearchValues(String documentId) {
        Collection<SearchableAttributeValue> searchableAttributeValues = this.findSearchableAttributeValues(documentId);
        for (SearchableAttributeValue searchableAttributeValue : searchableAttributeValues) {
            this.entityManager.remove((Object)searchableAttributeValue);
        }
    }

    @Override
    public Collection<SearchableAttributeValue> findSearchableAttributeValues(String documentId) {
        ArrayList<SearchableAttributeValue> searchableAttributeValues = new ArrayList<SearchableAttributeValue>();
        for (int i = 1; i <= 4; ++i) {
            String namedQuery = "";
            switch (i) {
                case 1: {
                    namedQuery = "SearchableAttributeFloatValue.FindByDocumentId";
                    break;
                }
                case 2: {
                    namedQuery = "SearchableAttributeDateTimeValue.FindByDocumentId";
                    break;
                }
                case 3: {
                    namedQuery = "SearchableAttributeLongValue.FindByDocumentId";
                    break;
                }
                case 4: {
                    namedQuery = "SearchableAttributeStringValue.FindByDocumentId";
                }
            }
            Query query = this.entityManager.createNamedQuery(namedQuery);
            query.setParameter("documentId", (Object)documentId);
            searchableAttributeValues.addAll(query.getResultList());
        }
        return searchableAttributeValues;
    }

    @Override
    public void lockRouteHeader(String documentId, boolean wait) {
        String sql = this.getPlatform().getLockRouteHeaderQuerySQL(documentId, wait);
        try {
            Query query = this.entityManager.createNativeQuery(sql);
            query.setParameter(1, (Object)documentId);
            query.getSingleResult();
        }
        catch (Exception e) {
            throw new LockingException("Could not aquire lock on document, documentId=" + documentId, (Throwable)e);
        }
    }

    @Override
    public DocumentRouteHeaderValue findRouteHeader(String documentId) {
        return this.findRouteHeader(documentId, false);
    }

    @Override
    public DocumentRouteHeaderValue findRouteHeader(String documentId, boolean clearCache) {
        Query query = this.entityManager.createNamedQuery("DocumentRouteHeaderValue.FindByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        if (clearCache) {
            // empty if block
        }
        DocumentRouteHeaderValue routeHeader = (DocumentRouteHeaderValue)query.getSingleResult();
        return routeHeader;
    }

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds) {
        return this.findRouteHeaders(documentIds, false);
    }

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds, boolean clearCache) {
        if (documentIds == null || documentIds.isEmpty()) {
            return null;
        }
        Criteria crit = new Criteria(DocumentRouteHeaderValue.class.getName());
        crit.in("documentId", documentIds);
        if (clearCache) {
            // empty if block
        }
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public void deleteRouteHeader(DocumentRouteHeaderValue routeHeader) {
        DocumentRouteHeaderValue attachedRouteHeader = this.findRouteHeader(routeHeader.getDocumentId());
        this.entityManager.remove((Object)attachedRouteHeader);
    }

    @Override
    public String getNextDocumentId() {
        Long nextDocumentId = this.getPlatform().getNextValSQL("KREW_DOC_HDR_S", this.entityManager);
        return nextDocumentId.toString();
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }

    @Override
    public Collection<String> findPendingByResponsibilityIds(Set<String> responsibilityIds) {
        if (responsibilityIds.isEmpty()) {
            return new ArrayList<String>();
        }
        String respIds = "('";
        int index = 0;
        for (String responsibilityId : responsibilityIds) {
            respIds = respIds + responsibilityId + (index == responsibilityIds.size() - 1 ? "" : "','");
        }
        respIds = respIds + "')";
        String query = "SELECT DISTINCT(doc_hdr_id) FROM KREW_ACTN_RQST_T WHERE (STAT_CD='" + ActionRequestStatus.INITIALIZED.getCode() + "' OR STAT_CD='" + ActionRequestStatus.ACTIVATED.getCode() + "') AND RSP_ID IN " + respIds;
        LOG.debug((Object)("Query to find pending documents for requeue: " + query));
        ArrayList<String> idList = new ArrayList<String>();
        for (Object tempId : this.entityManager.createNativeQuery(query).getResultList()) {
            idList.add((String)tempId);
        }
        return idList;
    }

    @Override
    public boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey, String searchableAttributeValue) {
        return this.hasSearchableAttributeValue(documentId, searchableAttributeKey, searchableAttributeValue, "SearchableAttributeDateTimeValue.FindByKey") || this.hasSearchableAttributeValue(documentId, searchableAttributeKey, searchableAttributeValue, "SearchableAttributeStringValue.FindByKey") || this.hasSearchableAttributeValue(documentId, searchableAttributeKey, searchableAttributeValue, "SearchableAttributeLongValue.FindByKey") || this.hasSearchableAttributeValue(documentId, searchableAttributeKey, searchableAttributeValue, "SearchableAttributeFloatValue.FindByKey");
    }

    private boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey, String searchableAttributeValue, String namedQuery) {
        Query query = this.entityManager.createNamedQuery(namedQuery);
        query.setParameter("documentId", (Object)documentId);
        query.setParameter("searchableAttributeKey", (Object)searchableAttributeKey);
        List results = query.getResultList();
        if (!results.isEmpty()) {
            for (SearchableAttributeValue attribute : results) {
                if (!StringUtils.equals((String)attribute.getSearchableAttributeDisplayValue(), (String)searchableAttributeValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getApplicationIdByDocumentId(String documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("Encountered a null document ID.");
        }
        String applicationId = null;
        try {
            String sql = "SELECT DT.APPL_ID FROM KREW_DOC_TYP_T DT, KREW_DOC_HDR_T DH WHERE DH.DOC_TYP_ID=DT.DOC_TYP_ID AND DH.DOC_HDR_ID=?";
            Query query = this.entityManager.createNativeQuery(sql);
            query.setParameter(1, (Object)documentId);
            applicationId = (String)query.getSingleResult();
        }
        catch (EntityNotFoundException enfe) {
            throw new WorkflowRuntimeException(enfe.getMessage());
        }
        return applicationId;
    }

    @Override
    public String getDocumentStatus(String documentId) {
        DocumentRouteHeaderValue document = this.findRouteHeader(documentId);
        return document.getDocRouteStatus();
    }

    @Override
    public String getAppDocId(String documentId) {
        Query query = this.entityManager.createNamedQuery("DocumentRouteHeaderValue.GetAppDocId");
        query.setParameter("documentId", (Object)documentId);
        return (String)query.getSingleResult();
    }

    @Override
    public String getAppDocStatus(String documentId) {
        Query query = this.entityManager.createNamedQuery("DocumentRouteHeaderValue.GetAppDocStatus");
        query.setParameter("documentId", (Object)documentId);
        return (String)query.getSingleResult();
    }

    @Override
    public void save(SearchableAttributeValue searchableAttributeValue) {
        if (searchableAttributeValue.getSearchableAttributeValueId() == null) {
            this.entityManager.persist((Object)searchableAttributeValue);
        } else {
            this.entityManager.merge((Object)searchableAttributeValue);
        }
    }

    @Override
    public Collection findByDocTypeAndAppId(String documentTypeName, String appId) {
        try {
            String sql = "SELECT DISTINCT     (docHdr.doc_hdr_id) FROM     KREW_DOC_HDR_T docHdr,     KREW_DOC_TYP_T docTyp WHERE     docHdr.APP_DOC_ID     = ?     AND docHdr.DOC_TYP_ID = docTyp.DOC_TYP_ID     AND docTyp.DOC_TYP_NM = ?";
            Query query = this.entityManager.createNativeQuery(sql);
            query.setParameter(1, (Object)appId);
            query.setParameter(2, (Object)documentTypeName);
            ArrayList<Long> idCollection = new ArrayList<Long>();
            for (Object tempId : query.getResultList()) {
                idCollection.add(((BigDecimal)tempId).longValueExact());
            }
            return idCollection;
        }
        catch (EntityNotFoundException enfe) {
            throw new WorkflowRuntimeException(enfe.getMessage());
        }
    }
}

