/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.LockingException;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.dao.DocumentRouteHeaderDAO;
import org.springframework.dao.CannotAcquireLockException;
import org.springmodules.orm.ojb.OjbFactoryUtils;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class DocumentRouteHeaderDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements DocumentRouteHeaderDAO {
    private static final Logger LOG = Logger.getLogger(DocumentRouteHeaderDAOOjbImpl.class);

    @Override
    public void saveRouteHeader(DocumentRouteHeaderValue routeHeader) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to Save the route Header: " + routeHeader.getDocumentId() + " / version=" + routeHeader.getVersionNumber()));
            DocumentRouteHeaderValue currHeader = this.findRouteHeader(routeHeader.getDocumentId());
            if (currHeader != null) {
                LOG.debug((Object)("Current Header Version: " + currHeader.getVersionNumber()));
            } else {
                LOG.debug((Object)"Current Header: null");
            }
            LOG.debug((Object)ExceptionUtils.getStackTrace((Throwable)new Throwable()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)routeHeader);
            routeHeader.getDocumentContent().setDocumentId(routeHeader.getDocumentId());
            this.getPersistenceBrokerTemplate().store((Object)routeHeader.getDocumentContent());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof OptimisticLockException) {
                LOG.error((Object)("Optimistic Locking Exception saving document header or content. Offending object: " + ((OptimisticLockException)ex.getCause()).getSourceObject() + "; DocumentId = " + routeHeader.getDocumentId() + " ;  Version Number = " + routeHeader.getVersionNumber()));
            }
            LOG.error((Object)("Unable to save document header or content. Route Header: " + routeHeader), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public DocumentRouteHeaderValueContent getContent(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return (DocumentRouteHeaderValueContent)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(DocumentRouteHeaderValueContent.class, crit));
    }

    @Override
    public void clearRouteHeaderSearchValues(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        QueryByCriteria query = new QueryByCriteria(SearchableAttributeValue.class, crit);
        query.addOrderByAscending("searchableAttributeValueId");
        Collection results = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (!results.isEmpty()) {
            for (SearchableAttributeValue srchAttrVal : results) {
                this.getPersistenceBrokerTemplate().delete((Object)srchAttrVal);
            }
        }
    }

    @Override
    public Collection<SearchableAttributeValue> findSearchableAttributeValues(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        QueryByCriteria query = new QueryByCriteria(SearchableAttributeValue.class, crit);
        query.addOrderByAscending("searchableAttributeValueId");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public void lockRouteHeader(final String documentId, final boolean wait) {
        this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement statement = null;
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    String sql = DocumentRouteHeaderDAOOjbImpl.this.getPlatform().getLockRouteHeaderQuerySQL(documentId, wait);
                    statement = connection.prepareStatement(sql);
                    statement.setString(1, documentId);
                    statement.execute();
                    Object var5_8 = null;
                    return var5_8;
                }
                catch (SQLException e) {
                    throw new LockingException("Could not aquire lock on document, documentId=" + documentId, (Throwable)e);
                }
                catch (LookupException e) {
                    throw new LockingException("Could not aquire lock on document, documentId=" + documentId, (Throwable)e);
                }
                catch (CannotAcquireLockException e) {
                    throw new LockingException("Could not aquire lock on document, documentId=" + documentId, (Throwable)e);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
    }

    @Override
    public DocumentRouteHeaderValue findRouteHeader(String documentId) {
        return this.findRouteHeader(documentId, false);
    }

    @Override
    public DocumentRouteHeaderValue findRouteHeader(String documentId, boolean clearCache) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        if (clearCache) {
            this.getPersistenceBrokerTemplate().clearCache();
        }
        return (DocumentRouteHeaderValue)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(DocumentRouteHeaderValue.class, crit));
    }

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds) {
        return this.findRouteHeaders(documentIds, false);
    }

    @Override
    public Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds, boolean clearCache) {
        if (documentIds == null || documentIds.isEmpty()) {
            return null;
        }
        Criteria crit = new Criteria();
        crit.addIn("documentId", documentIds);
        if (clearCache) {
            this.getPersistenceBrokerTemplate().clearCache();
        }
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(DocumentRouteHeaderValue.class, crit));
    }

    @Override
    public void deleteRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.getPersistenceBrokerTemplate().delete((Object)routeHeader);
    }

    @Override
    public String getNextDocumentId() {
        return (String)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                return DocumentRouteHeaderDAOOjbImpl.this.getPlatform().getNextValSQL("KREW_DOC_HDR_S", broker).toString();
            }
        });
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }

    @Override
    public Collection<String> findPendingByResponsibilityIds(Set<String> responsibilityIds) {
        ArrayList<String> documentIds = new ArrayList<String>();
        if (responsibilityIds.isEmpty()) {
            return documentIds;
        }
        PersistenceBroker broker = null;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            broker = this.getPersistenceBroker(false);
            conn = broker.serviceConnectionManager().getConnection();
            String respIds = "('";
            int index = 0;
            for (String responsibilityId : responsibilityIds) {
                respIds = respIds + responsibilityId + (index == responsibilityIds.size() - 1 ? "" : "','");
                ++index;
            }
            respIds = respIds + "')";
            String query = "SELECT DISTINCT(doc_hdr_id) FROM KREW_ACTN_RQST_T WHERE (STAT_CD='" + ActionRequestStatus.INITIALIZED.getCode() + "' OR STAT_CD='" + ActionRequestStatus.ACTIVATED.getCode() + "') AND RSP_ID IN " + respIds;
            LOG.debug((Object)("Query to find pending documents for requeue: " + query));
            statement = conn.createStatement();
            rs = statement.executeQuery(query);
            while (rs.next()) {
                documentIds.add(rs.getString(1));
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)("SQLException: " + sqle.getMessage()), (Throwable)sqle);
            throw new WorkflowRuntimeException((Throwable)sqle);
        }
        catch (LookupException le) {
            LOG.error((Object)("LookupException: " + le.getMessage()), (Throwable)le);
            throw new WorkflowRuntimeException((Throwable)le);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close result set.");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close statement.");
                }
            }
            try {
                if (broker != null) {
                    OjbFactoryUtils.releasePersistenceBroker((PersistenceBroker)broker, (PBKey)this.getPersistenceBrokerTemplate().getPbKey());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed closing connection: " + e.getMessage()), (Throwable)e);
            }
        }
        return documentIds;
    }

    @Override
    public boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey, String searchableAttributeValue) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("searchableAttributeKey", (Object)searchableAttributeKey);
        Collection results = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(SearchableAttributeValue.class, crit));
        if (!results.isEmpty()) {
            for (SearchableAttributeValue attribute : results) {
                if (!StringUtils.equals((String)attribute.getSearchableAttributeDisplayValue(), (String)searchableAttributeValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getApplicationIdByDocumentId(String documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("Encountered a null document ID.");
        }
        String applicationId = null;
        PersistenceBroker broker = null;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            broker = this.getPersistenceBroker(false);
            conn = broker.serviceConnectionManager().getConnection();
            String query = "SELECT DT.APPL_ID FROM KREW_DOC_TYP_T DT, KREW_DOC_HDR_T DH WHERE DH.DOC_TYP_ID=DT.DOC_TYP_ID AND DH.DOC_HDR_ID=?";
            statement = conn.prepareStatement(query);
            statement.setString(1, documentId);
            rs = statement.executeQuery();
            if (rs.next()) {
                applicationId = rs.getString(1);
                if (rs.wasNull()) {
                    applicationId = null;
                }
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)("SQLException: " + sqle.getMessage()), (Throwable)sqle);
            throw new WorkflowRuntimeException((Throwable)sqle);
        }
        catch (LookupException le) {
            LOG.error((Object)("LookupException: " + le.getMessage()), (Throwable)le);
            throw new WorkflowRuntimeException((Throwable)le);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close result set.");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close statement.");
                }
            }
            try {
                if (broker != null) {
                    OjbFactoryUtils.releasePersistenceBroker((PersistenceBroker)broker, (PBKey)this.getPersistenceBrokerTemplate().getPbKey());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed closing connection: " + e.getMessage()), (Throwable)e);
            }
        }
        return applicationId;
    }

    @Override
    public String getDocumentStatus(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentRouteHeaderValue.class, (Criteria)crit);
        query.setAttributes(new String[]{"docRouteStatus"});
        String status = null;
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] row = (Object[])iter.next();
            status = (String)row[0];
        }
        return status;
    }

    @Override
    public String getAppDocId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentRouteHeaderValue.class, (Criteria)crit);
        query.setAttributes(new String[]{"appDocId"});
        String appDocId = null;
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] row = (Object[])iter.next();
            appDocId = (String)row[0];
        }
        return appDocId;
    }

    @Override
    public String getAppDocStatus(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DocumentRouteHeaderValue.class, (Criteria)crit);
        query.setAttributes(new String[]{"appDocStatus"});
        String appDocStatus = null;
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] row = (Object[])iter.next();
            appDocStatus = (String)row[0];
        }
        return appDocStatus;
    }

    @Override
    public void save(SearchableAttributeValue searchableAttributeValue) {
        this.getPersistenceBrokerTemplate().store((Object)searchableAttributeValue);
    }

    @Override
    public Collection findByDocTypeAndAppId(String documentTypeName, String appId) {
        ArrayList<String> documentIds = new ArrayList<String>();
        PersistenceBroker broker = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            broker = this.getPersistenceBroker(false);
            conn = broker.serviceConnectionManager().getConnection();
            String query = "SELECT DISTINCT     (docHdr.doc_hdr_id) FROM     KREW_DOC_HDR_T docHdr,     KREW_DOC_TYP_T docTyp WHERE     docHdr.APP_DOC_ID     = ?     AND docHdr.DOC_TYP_ID = docTyp.DOC_TYP_ID     AND docTyp.DOC_TYP_NM = ?";
            LOG.debug((Object)("Query to find documents by app id: " + query));
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, appId);
            stmt.setString(2, documentTypeName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                documentIds.add(new String(rs.getString(1)));
            }
            rs.close();
        }
        catch (SQLException sqle) {
            LOG.error((Object)("SQLException: " + sqle.getMessage()), (Throwable)sqle);
            throw new WorkflowRuntimeException((Throwable)sqle);
        }
        catch (LookupException le) {
            LOG.error((Object)("LookupException: " + le.getMessage()), (Throwable)le);
            throw new WorkflowRuntimeException((Throwable)le);
        }
        finally {
            try {
                if (broker != null) {
                    OjbFactoryUtils.releasePersistenceBroker((PersistenceBroker)broker, (PBKey)this.getPersistenceBrokerTemplate().getPbKey());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed closing connection: " + e.getMessage()), (Throwable)e);
            }
        }
        return documentIds;
    }
}

