/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleDelegationContract;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_DLGN_RSP_T")
public class RuleDelegationBo
extends PersistableBusinessObjectBase
implements RuleDelegationContract {
    private static final long serialVersionUID = 7989203310473741293L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DLGN_RULE_ID")
    private String ruleDelegationId;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="DLGN_RULE_BASE_VAL_ID", insertable=false, updatable=false)
    private String delegateRuleId;
    @Column(name="DLGN_TYP")
    private String delegationTypeCode = DelegationType.PRIMARY.getCode();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DLGN_RULE_BASE_VAL_ID")
    private RuleBaseValues delegationRule;
    @Transient
    private String groupReviewerName;
    @Transient
    private String groupReviewerNamespace;
    @Transient
    private String personReviewer;
    @Transient
    private String personReviewerType;

    public Object copy(boolean preserveKeys) {
        RuleDelegationBo clone = new RuleDelegationBo();
        if (this.ruleDelegationId != null && preserveKeys) {
            clone.setRuleDelegationId(this.ruleDelegationId);
        }
        clone.setDelegationRule(this.delegationRule);
        clone.setDelegateRuleId(this.delegationRule.getId());
        if (this.delegationTypeCode != null) {
            clone.setDelegationType(DelegationType.fromCode((String)this.delegationTypeCode));
        }
        return clone;
    }

    public String getDelegateRuleId() {
        return this.delegateRuleId;
    }

    public void setDelegateRuleId(String delegateRuleId) {
        this.delegateRuleId = delegateRuleId;
    }

    public RuleBaseValues getDelegationRule() {
        return this.delegationRule;
    }

    public RuleBaseValues getDelegationRuleBaseValues() {
        return this.delegationRule;
    }

    public void setDelegationRuleBaseValues(RuleBaseValues delegationRuleBaseValues) {
        this.delegationRule = delegationRuleBaseValues;
    }

    public void setDelegationRule(RuleBaseValues delegationRule) {
        this.delegationRule = delegationRule;
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        DelegationType.fromCode((String)delegationTypeCode);
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this.delegationTypeCode);
    }

    public void setDelegationType(DelegationType delegationType) {
        this.delegationTypeCode = delegationType.getCode();
    }

    public String getRuleDelegationId() {
        return this.ruleDelegationId;
    }

    public void setRuleDelegationId(String ruleDelegationId) {
        this.ruleDelegationId = ruleDelegationId;
    }

    public RuleResponsibilityBo getRuleResponsibility() {
        if (this.getResponsibilityId() == null) {
            return null;
        }
        return KEWServiceLocator.getRuleService().findRuleResponsibility(this.getResponsibilityId());
    }

    public DocumentType getDocumentType() {
        return this.getDelegationRule().getDocumentType();
    }

    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    public void setResponsibilityId(String ruleResponsibilityId) {
        this.responsibilityId = ruleResponsibilityId;
    }

    public String getGroupReviewerName() {
        return this.groupReviewerName;
    }

    public String getGroupReviewerNamespace() {
        return this.groupReviewerNamespace;
    }

    public String getPersonReviewer() {
        return this.personReviewer;
    }

    public void setGroupReviewerName(String groupReviewerName) {
        this.groupReviewerName = groupReviewerName;
    }

    public void setGroupReviewerNamespace(String groupReviewerNamespace) {
        this.groupReviewerNamespace = groupReviewerNamespace;
    }

    public void setPersonReviewer(String personReviewer) {
        this.personReviewer = personReviewer;
    }

    public String getPersonReviewerType() {
        return this.personReviewerType;
    }

    public void setPersonReviewerType(String personReviewerType) {
        this.personReviewerType = personReviewerType;
    }

    public GroupBo getGroupBo() {
        GroupBo groupBo = null;
        if (StringUtils.isNotBlank((String)this.getGroupReviewerName()) && groupBo == null) {
            groupBo = GroupBo.from((Group)KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(this.getGroupReviewerNamespace(), this.getGroupReviewerName()));
        }
        return groupBo;
    }

    public PersonImpl getPersonImpl() {
        return new PersonImpl();
    }

    public void refresh() {
        RuleBaseValues oldRuleBaseValues = this.getDelegationRule();
        super.refresh();
        if (this.getDelegationRule() == null) {
            this.refreshReferenceObject("delegationRuleBaseValues");
            if (this.getDelegationRule() == null) {
                this.setDelegationRule(oldRuleBaseValues);
            }
        }
    }

    public static RuleDelegation to(RuleDelegationBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleDelegation.Builder.create((RuleDelegationContract)bo).build();
    }
}

