/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.rule.RuleTemplateAttributeContract;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_RULE_TMPL_ATTR_T")
public class RuleTemplateAttributeBo
extends PersistableBusinessObjectBase
implements Comparable<RuleTemplateAttributeBo>,
MutableInactivatable,
RuleTemplateAttributeContract {
    private static final long serialVersionUID = -3580049225424553828L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_TMPL_ATTR_ID")
    private String id;
    @Column(name="RULE_TMPL_ID", insertable=false, updatable=false)
    private String ruleTemplateId;
    @Column(name="RULE_ATTR_ID", insertable=false, updatable=false)
    private String ruleAttributeId;
    @Column(name="REQ_IND")
    private Boolean required = Boolean.FALSE;
    @Column(name="ACTV_IND")
    private Boolean active = Boolean.TRUE;
    @Column(name="DSPL_ORD")
    private Integer displayOrder;
    @Column(name="DFLT_VAL")
    private String defaultValue;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_TMPL_ID")
    private RuleTemplateBo ruleTemplate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ATTR_ID")
    private RuleAttribute ruleAttribute;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ruleTemplateAttribute")
    private List<RuleExtensionBo> ruleExtensions;

    @Override
    public int compareTo(RuleTemplateAttributeBo ruleTemplateAttribute) {
        if (this.getDisplayOrder() != null && ruleTemplateAttribute.getDisplayOrder() != null) {
            return this.getDisplayOrder().compareTo(ruleTemplateAttribute.getDisplayOrder());
        }
        return 0;
    }

    public Object getAttribute() {
        try {
            Object attribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)RuleAttribute.to(this.getRuleAttribute()), (String)this.getRuleAttribute().getApplicationId());
            if (attribute == null) {
                throw new WorkflowRuntimeException("Could not find attribute " + this.getRuleAttribute().getName());
            }
            if (attribute instanceof WorkflowRuleAttribute) {
                ((WorkflowRuleAttribute)attribute).setRequired(this.required);
            }
            return attribute;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught error attempting to load attribute class: " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public boolean isWorkflowAttribute() {
        return this.getRuleAttribute().isWorkflowAttribute();
    }

    public boolean isRuleValidationAttribute() {
        return "RuleValidationAttribute".equals(this.getRuleAttribute().getType());
    }

    public WorkflowRuleAttribute getWorkflowAttribute() {
        try {
            Object tempAttr = ExtensionUtils.loadExtension((ExtensionDefinitionContract)RuleAttribute.to(this.getRuleAttribute()), (String)this.getRuleAttribute().getApplicationId());
            if (tempAttr == null || !WorkflowRuleAttribute.class.isAssignableFrom(tempAttr.getClass())) {
                throw new WorkflowRuntimeException("Could not find workflow attribute " + this.getRuleAttribute().getName());
            }
            WorkflowRuleAttribute workflowAttribute = (WorkflowRuleAttribute)tempAttr;
            workflowAttribute.setRequired(this.required);
            return workflowAttribute;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception instantiating new " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public RuleValidationAttribute getRuleValidationAttribute() {
        try {
            RuleAttribute attrib = this.getRuleAttribute();
            return KEWServiceLocator.getRuleValidationAttributeResolver().resolveRuleValidationAttribute(attrib.getName(), attrib.getApplicationId());
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception instantiating new " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public List<RuleExtensionBo> getRuleExtensions() {
        return this.ruleExtensions;
    }

    public Map<String, String> getRuleExtensionMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        if (this.getRuleExtensions() != null) {
            for (RuleExtensionBo ext : this.getRuleExtensions()) {
                for (RuleExtensionValue value : ext.getExtensionValues()) {
                    extensions.put(value.getKey(), value.getValue());
                }
            }
        }
        return extensions;
    }

    public void setRuleExtensions(List<RuleExtensionBo> ruleExtensions) {
        this.ruleExtensions = ruleExtensions;
    }

    public RuleAttribute getRuleAttribute() {
        if (this.ruleAttribute == null && this.ruleAttributeId != null) {
            this.ruleAttribute = RuleAttribute.from(KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(this.ruleAttributeId));
        }
        return this.ruleAttribute;
    }

    public void setRuleAttribute(RuleAttribute ruleAttribute) {
        this.ruleAttribute = ruleAttribute;
    }

    public RuleTemplateBo getRuleTemplate() {
        return this.ruleTemplate;
    }

    public void setRuleTemplate(RuleTemplateBo ruleTemplate) {
        this.ruleTemplate = ruleTemplate;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isRequired() {
        return this.getRequired() == null || this.getRequired() != false;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public boolean isActive() {
        return this.getActive() == null || this.getActive() != false;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getRuleAttributeId() {
        return this.ruleAttributeId;
    }

    public void setRuleAttributeId(String ruleAttributeId) {
        this.ruleAttributeId = ruleAttributeId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRuleTemplateId() {
        return this.ruleTemplateId;
    }

    public void setRuleTemplateId(String ruleTemplateId) {
        this.ruleTemplateId = ruleTemplateId;
    }
}

