/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegationContract;
import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.api.validation.ValidationResults;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.responsibility.service.ResponsibilityIdService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.RuleRoutingDefinition;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleDAO;
import org.kuali.rice.kew.rule.dao.RuleResponsibilityDAO;
import org.kuali.rice.kew.rule.service.RuleDelegationService;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.xml.RuleXmlParser;
import org.kuali.rice.kew.xml.export.RuleXmlExporter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.cache.Cache;

public class RuleServiceInternalImpl
implements RuleServiceInternal {
    private static final String XML_PARSE_ERROR = "general.error.parsexml";
    private static final Logger LOG = Logger.getLogger(RuleServiceInternalImpl.class);
    private RuleDAO ruleDAO;
    private RuleResponsibilityDAO ruleResponsibilityDAO;

    public RuleResponsibilityDAO getRuleResponsibilityDAO() {
        return this.ruleResponsibilityDAO;
    }

    @Override
    public RuleBaseValues getRuleByName(String name) {
        return this.ruleDAO.findRuleBaseValuesByName(name);
    }

    @Override
    public RuleBaseValues findDefaultRuleByRuleTemplateId(String ruleTemplateId) {
        return this.ruleDAO.findDefaultRuleByRuleTemplateId(ruleTemplateId);
    }

    public void setRuleResponsibilityDAO(RuleResponsibilityDAO ruleResponsibilityDAO) {
        this.ruleResponsibilityDAO = ruleResponsibilityDAO;
    }

    @Override
    public void save2(RuleBaseValues ruleBaseValues) throws Exception {
        this.save2(ruleBaseValues, null, true);
    }

    public void save2(RuleBaseValues ruleBaseValues, RuleDelegationBo ruleDelegation, boolean saveDelegations) throws Exception {
        if (ruleBaseValues.getPreviousRuleId() != null) {
            RuleBaseValues oldRule = this.findRuleBaseValuesById(ruleBaseValues.getPreviousRuleId());
            ruleBaseValues.setPreviousVersion(oldRule);
            ruleBaseValues.setCurrentInd(Boolean.FALSE);
            ruleBaseValues.setVersionNbr(this.getNextVersionNumber(oldRule));
        }
        if (ruleBaseValues.getVersionNbr() == null) {
            ruleBaseValues.setVersionNbr(0);
        }
        if (ruleBaseValues.getCurrentInd() == null) {
            ruleBaseValues.setCurrentInd(Boolean.FALSE);
        }
        for (RuleResponsibilityBo element : ruleBaseValues.getRuleResponsibilities()) {
            RuleResponsibilityBo responsibility = element;
            if (responsibility.getResponsibilityId() == null) {
                responsibility.setResponsibilityId(this.getResponsibilityIdService().getNewResponsibilityId());
            }
            if (!saveDelegations) continue;
            Iterator<RuleDelegationBo> iterator = responsibility.getDelegationRules().iterator();
            while (iterator.hasNext()) {
                RuleDelegationBo element2;
                RuleDelegationBo localRuleDelegation = element2 = iterator.next();
                this.save2(localRuleDelegation.getDelegationRule(), localRuleDelegation, true);
            }
        }
        this.validate2(ruleBaseValues, ruleDelegation, null);
        this.getRuleDAO().save(ruleBaseValues);
    }

    @Override
    public void makeCurrent(String documentId) {
        this.makeCurrent(this.findByDocumentId(documentId));
    }

    public void makeCurrent(List<RuleBaseValues> rules) {
        PerformanceLogger performanceLogger = new PerformanceLogger();
        boolean isGenerateRuleArs = true;
        String generateRuleArs = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "GENERATE_ACTION_REQUESTS_IND");
        if (!StringUtils.isBlank((String)generateRuleArs)) {
            isGenerateRuleArs = "Y".equalsIgnoreCase(generateRuleArs);
        }
        HashSet<String> responsibilityIds = new HashSet<String>();
        HashMap<String, RuleBaseValues> rulesToSave = new HashMap<String, RuleBaseValues>();
        Collections.sort(rules, new RuleDelegationSorter());
        boolean delegateFirst = false;
        for (RuleBaseValues rule : rules) {
            performanceLogger.log("Preparing rule: " + rule.getDescription());
            rule.setCurrentInd(Boolean.TRUE);
            Timestamp date = new Timestamp(System.currentTimeMillis());
            rule.setActivationDate(date);
            try {
                rule.setDeactivationDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse("01/01/2100").getTime()));
            }
            catch (Exception e) {
                LOG.error((Object)"Parse Exception", (Throwable)e);
            }
            rulesToSave.put(rule.getId(), rule);
            RuleBaseValues oldRule = rule.getPreviousVersion();
            if (oldRule != null) {
                performanceLogger.log("Setting previous rule: " + oldRule.getId() + " to non current.");
                oldRule.setCurrentInd(Boolean.FALSE);
                oldRule.setDeactivationDate(date);
                rulesToSave.put(oldRule.getId(), oldRule);
                if (!delegateFirst) {
                    responsibilityIds.addAll(this.getResponsibilityIdsFromGraph(oldRule, isGenerateRuleArs));
                }
                if (rule.getDelegateRule().booleanValue() && rule.getPreviousRuleId() != null) {
                    delegateFirst = true;
                }
                List<RuleBaseValues> oldDelegationRules = this.findOldDelegationRules(oldRule, rule, performanceLogger);
                for (RuleBaseValues delegationRule : oldDelegationRules) {
                    performanceLogger.log("Setting previous delegation rule: " + delegationRule.getId() + "to non current.");
                    delegationRule.setCurrentInd(Boolean.FALSE);
                    rulesToSave.put(delegationRule.getId(), delegationRule);
                    responsibilityIds.addAll(this.getResponsibilityIdsFromGraph(delegationRule, isGenerateRuleArs));
                }
            }
            Iterator<RuleResponsibilityBo> iterator = rule.getRuleResponsibilities().iterator();
            while (iterator.hasNext()) {
                RuleResponsibilityBo element;
                RuleResponsibilityBo responsibility = element = iterator.next();
                Iterator<RuleDelegationBo> iterator2 = responsibility.getDelegationRules().iterator();
                while (iterator2.hasNext()) {
                    RuleDelegationBo element2;
                    RuleDelegationBo delegation = element2 = iterator2.next();
                    delegation.getDelegationRule().setCurrentInd(Boolean.TRUE);
                    RuleBaseValues delegatorRule = delegation.getDelegationRule();
                    performanceLogger.log("Setting delegate rule: " + delegatorRule.getDescription() + " to current.");
                    if (delegatorRule.getActivationDate() == null) {
                        delegatorRule.setActivationDate(date);
                    }
                    try {
                        delegatorRule.setDeactivationDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse("01/01/2100").getTime()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Parse Exception", (Throwable)e);
                    }
                    rulesToSave.put(delegatorRule.getId(), delegatorRule);
                }
            }
        }
        for (RuleBaseValues rule : rulesToSave.values()) {
            this.getRuleDAO().save(rule);
            performanceLogger.log("Saved rule: " + rule.getId());
        }
        this.getActionRequestService().updateActionRequestsForResponsibilityChange(responsibilityIds);
        performanceLogger.log("Time to make current");
    }

    public void makeCurrent2(List<RuleBaseValues> rules) {
        PerformanceLogger performanceLogger = new PerformanceLogger();
        boolean isGenerateRuleArs = true;
        String generateRuleArs = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "GENERATE_ACTION_REQUESTS_IND");
        if (!StringUtils.isBlank((String)generateRuleArs)) {
            isGenerateRuleArs = "Y".equalsIgnoreCase(generateRuleArs);
        }
        HashSet<String> responsibilityIds = new HashSet<String>();
        HashMap<String, RuleBaseValues> rulesToSave = new HashMap<String, RuleBaseValues>();
        Collections.sort(rules, new RuleDelegationSorter());
        for (RuleBaseValues rule : rules) {
            performanceLogger.log("Preparing rule: " + rule.getDescription());
            rule.setCurrentInd(Boolean.TRUE);
            Timestamp date = new Timestamp(System.currentTimeMillis());
            rule.setActivationDate(date);
            try {
                rule.setDeactivationDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse("01/01/2100").getTime()));
            }
            catch (Exception e) {
                LOG.error((Object)"Parse Exception", (Throwable)e);
            }
            rulesToSave.put(rule.getId(), rule);
            RuleBaseValues oldRule = rule.getPreviousVersion();
            if (oldRule != null) {
                performanceLogger.log("Setting previous rule: " + oldRule.getId() + " to non current.");
                oldRule.setCurrentInd(Boolean.FALSE);
                oldRule.setDeactivationDate(date);
                rulesToSave.put(oldRule.getId(), oldRule);
                responsibilityIds.addAll(this.getModifiedResponsibilityIds(oldRule, rule));
            }
            Iterator<RuleResponsibilityBo> iterator = rule.getRuleResponsibilities().iterator();
            while (iterator.hasNext()) {
                RuleResponsibilityBo element;
                RuleResponsibilityBo responsibility = element = iterator.next();
                Iterator<RuleDelegationBo> iterator2 = responsibility.getDelegationRules().iterator();
                while (iterator2.hasNext()) {
                    RuleDelegationBo element2;
                    RuleDelegationBo delegation = element2 = iterator2.next();
                    RuleBaseValues delegateRule = delegation.getDelegationRule();
                    delegateRule.setCurrentInd(Boolean.TRUE);
                    performanceLogger.log("Setting delegate rule: " + delegateRule.getDescription() + " to current.");
                    if (delegateRule.getActivationDate() == null) {
                        delegateRule.setActivationDate(date);
                    }
                    try {
                        delegateRule.setDeactivationDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse("01/01/2100").getTime()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Parse Exception", (Throwable)e);
                    }
                    rulesToSave.put(delegateRule.getId(), delegateRule);
                }
            }
        }
        for (RuleBaseValues rule : rulesToSave.values()) {
            this.getRuleDAO().save(rule);
            performanceLogger.log("Saved rule: " + rule.getId());
        }
        if (isGenerateRuleArs) {
            this.getActionRequestService().updateActionRequestsForResponsibilityChange(responsibilityIds);
        }
        performanceLogger.log("Time to make current");
    }

    @Override
    public void makeCurrent(RuleBaseValues rule, boolean isRetroactiveUpdatePermitted) {
        this.makeCurrent(null, rule, isRetroactiveUpdatePermitted);
    }

    @Override
    public void makeCurrent(RuleDelegationBo ruleDelegation, boolean isRetroactiveUpdatePermitted) {
        this.clearCache("http://rice.kuali.org/kew/v2_0/RuleDelegationType");
        this.makeCurrent(ruleDelegation, ruleDelegation.getDelegationRule(), isRetroactiveUpdatePermitted);
    }

    protected void makeCurrent(RuleDelegationBo ruleDelegation, RuleBaseValues rule, boolean isRetroactiveUpdatePermitted) {
        RuleBaseValues oldRule;
        PerformanceLogger performanceLogger = new PerformanceLogger();
        boolean isGenerateRuleArs = false;
        if (isRetroactiveUpdatePermitted) {
            isGenerateRuleArs = true;
            String generateRuleArs = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "GENERATE_ACTION_REQUESTS_IND");
            if (!StringUtils.isBlank((String)generateRuleArs)) {
                isGenerateRuleArs = "Y".equalsIgnoreCase(generateRuleArs);
            }
        }
        HashSet<String> responsibilityIds = new HashSet<String>();
        performanceLogger.log("Preparing rule: " + rule.getDescription());
        HashMap<String, RuleBaseValues> rulesToSave = new HashMap<String, RuleBaseValues>();
        this.generateRuleNameIfNeeded(rule);
        this.assignResponsibilityIds(rule);
        rule.setCurrentInd(Boolean.TRUE);
        Timestamp date = new Timestamp(System.currentTimeMillis());
        rule.setActivationDate(date);
        rule.setDeactivationDate(null);
        rulesToSave.put(rule.getId(), rule);
        if (rule.getPreviousRuleId() != null) {
            oldRule = this.findRuleBaseValuesById(rule.getPreviousRuleId());
            rule.setPreviousVersion(oldRule);
        }
        rule.setVersionNbr(0);
        rule.setObjectId(null);
        oldRule = rule.getPreviousVersion();
        if (oldRule != null) {
            performanceLogger.log("Setting previous rule: " + oldRule.getId() + " to non current.");
            oldRule.setCurrentInd(Boolean.FALSE);
            oldRule.setDeactivationDate(date);
            rulesToSave.put(oldRule.getId(), oldRule);
            responsibilityIds.addAll(this.getModifiedResponsibilityIds(oldRule, rule));
            rule.setVersionNbr(this.getNextVersionNumber(oldRule));
        }
        boolean isRuleDelegation = ruleDelegation != null;
        for (RuleBaseValues ruleToSave : rulesToSave.values()) {
            this.getRuleDAO().save(ruleToSave);
            performanceLogger.log("Saved rule: " + ruleToSave.getId());
        }
        if (isRuleDelegation) {
            responsibilityIds.add(ruleDelegation.getResponsibilityId());
            ruleDelegation.setDelegateRuleId(rule.getId());
            this.getRuleDelegationService().save(ruleDelegation);
        }
        if (isGenerateRuleArs && org.apache.commons.collections.CollectionUtils.isNotEmpty(responsibilityIds)) {
            this.getActionRequestService().updateActionRequestsForResponsibilityChange(responsibilityIds);
        }
        performanceLogger.log("Time to make current");
    }

    private void clearCache(String cacheName) {
        DistributedCacheManagerDecorator distributedCacheManagerDecorator = (DistributedCacheManagerDecorator)GlobalResourceLoader.getService((String)"kewDistributedCacheManager");
        Cache cache = distributedCacheManagerDecorator.getCache(cacheName);
        if (cache != null) {
            cache.clear();
        }
    }

    @Override
    public RuleBaseValues getParentRule(String ruleBaseValuesId) {
        return this.getRuleDAO().getParentRule(ruleBaseValuesId);
    }

    private Set getResponsibilityIdsFromGraph(RuleBaseValues rule, boolean isRuleCollecting) {
        HashSet<String> responsibilityIds = new HashSet<String>();
        Iterator<RuleResponsibilityBo> iterator = rule.getRuleResponsibilities().iterator();
        while (iterator.hasNext()) {
            RuleResponsibilityBo element;
            RuleResponsibilityBo responsibility = element = iterator.next();
            if (!isRuleCollecting) continue;
            responsibilityIds.add(responsibility.getResponsibilityId());
        }
        return responsibilityIds;
    }

    private Set<String> getModifiedResponsibilityIds(RuleBaseValues oldRule, RuleBaseValues newRule) {
        RuleResponsibilityBo responsibility;
        HashMap<String, RuleResponsibilityBo> modifiedResponsibilityMap = new HashMap<String, RuleResponsibilityBo>();
        Iterator<RuleResponsibilityBo> iterator = oldRule.getRuleResponsibilities().iterator();
        while (iterator.hasNext()) {
            RuleResponsibilityBo element;
            responsibility = element = iterator.next();
            modifiedResponsibilityMap.put(responsibility.getResponsibilityId(), responsibility);
        }
        for (RuleResponsibilityBo element : newRule.getRuleResponsibilities()) {
            responsibility = element;
            RuleResponsibilityBo oldResponsibility = (RuleResponsibilityBo)((Object)modifiedResponsibilityMap.get(responsibility.getResponsibilityId()));
            if (oldResponsibility == null) {
                modifiedResponsibilityMap.put(responsibility.getResponsibilityId(), responsibility);
                continue;
            }
            if (this.hasResponsibilityChanged(oldResponsibility, responsibility)) continue;
            modifiedResponsibilityMap.remove(responsibility.getResponsibilityId());
        }
        return modifiedResponsibilityMap.keySet();
    }

    private boolean hasResponsibilityChanged(RuleResponsibilityBo oldResponsibility, RuleResponsibilityBo newResponsibility) {
        return !ObjectUtils.equals((Object)oldResponsibility.getActionRequestedCd(), (Object)newResponsibility.getActionRequestedCd()) || !ObjectUtils.equals((Object)oldResponsibility.getApprovePolicy(), (Object)newResponsibility.getActionRequestedCd()) || !ObjectUtils.equals((Object)oldResponsibility.getPriority(), (Object)newResponsibility.getPriority()) || !ObjectUtils.equals((Object)oldResponsibility.getRole(), (Object)newResponsibility.getRole()) || !ObjectUtils.equals((Object)oldResponsibility.getRuleResponsibilityName(), (Object)newResponsibility.getRuleResponsibilityName()) || !ObjectUtils.equals((Object)oldResponsibility.getRuleResponsibilityType(), (Object)newResponsibility.getRuleResponsibilityType());
    }

    private List<RuleBaseValues> findOldDelegationRules(RuleBaseValues oldRule, RuleBaseValues newRule, PerformanceLogger performanceLogger) {
        performanceLogger.log("Begin to get delegation rules.");
        List oldDelegations = this.getRuleDAO().findOldDelegations(oldRule, newRule);
        performanceLogger.log("Located " + oldDelegations.size() + " old delegation rules.");
        return oldDelegations;
    }

    @Override
    public String routeRuleWithDelegate(String documentId, RuleBaseValues parentRule, RuleBaseValues delegateRule, PrincipalContract principal, String annotation, boolean blanketApprove) throws Exception {
        boolean isRoutingParent;
        if (parentRule == null) {
            throw new IllegalArgumentException("Cannot route a delegate without a parent rule.");
        }
        if (parentRule.getDelegateRule().booleanValue()) {
            throw new IllegalArgumentException("Parent rule cannot be a delegate.");
        }
        if (parentRule.getPreviousRuleId() == null && delegateRule.getPreviousRuleId() == null) {
            throw new IllegalArgumentException("Previous rule version required.");
        }
        RuleDelegationBo ruleDelegation = this.getRuleDelegation(parentRule, delegateRule);
        this.save2(delegateRule, ruleDelegation, true);
        boolean bl = isRoutingParent = parentRule.getId() == null;
        if (isRoutingParent) {
            this.save2(parentRule, null, false);
        }
        WorkflowDocument workflowDocument = null;
        if (documentId != null) {
            workflowDocument = WorkflowDocumentFactory.loadDocument((String)principal.getPrincipalId(), (String)documentId);
        } else {
            ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
            rules.add(delegateRule);
            rules.add(parentRule);
            workflowDocument = WorkflowDocumentFactory.createDocument((String)principal.getPrincipalId(), (String)this.getRuleDocumentTypeName(rules));
        }
        workflowDocument.setTitle(this.generateTitle(parentRule, delegateRule));
        delegateRule.setDocumentId(workflowDocument.getDocumentId());
        workflowDocument.addAttributeDefinition(RuleRoutingDefinition.createAttributeDefinition(parentRule.getDocTypeName()));
        this.getRuleDAO().save(delegateRule);
        if (isRoutingParent) {
            parentRule.setDocumentId(workflowDocument.getDocumentId());
            this.getRuleDAO().save(parentRule);
        }
        if (blanketApprove) {
            workflowDocument.blanketApprove(annotation);
        } else {
            workflowDocument.route(annotation);
        }
        return workflowDocument.getDocumentId();
    }

    private RuleDelegationBo getRuleDelegation(RuleBaseValues parentRule, RuleBaseValues delegateRule) throws Exception {
        Iterator<RuleResponsibilityBo> iterator = parentRule.getRuleResponsibilities().iterator();
        while (iterator.hasNext()) {
            RuleResponsibilityBo element;
            RuleResponsibilityBo responsibility = element = iterator.next();
            for (RuleDelegationBo element2 : responsibility.getDelegationRules()) {
                RuleDelegationBo ruleDelegation = element2;
                if (!((Object)((Object)ruleDelegation.getDelegationRule())).equals((Object)delegateRule)) continue;
                return ruleDelegation;
            }
        }
        return null;
    }

    private String generateTitle(RuleBaseValues parentRule, RuleBaseValues delegateRule) {
        StringBuffer title = new StringBuffer();
        if (delegateRule.getPreviousRuleId() != null) {
            title.append("Editing Delegation Rule '").append(delegateRule.getDescription()).append("' on '");
        } else {
            title.append("Adding Delegation Rule '").append(delegateRule.getDescription()).append("' to '");
        }
        title.append(parentRule.getDescription()).append("'");
        return title.toString();
    }

    public void validate(RuleBaseValues ruleBaseValues, List errors) {
        if (errors == null) {
            errors = new ArrayList<WorkflowServiceErrorImpl>();
        }
        if (this.getDocumentTypeService().findByName(ruleBaseValues.getDocTypeName()) == null) {
            errors.add(new WorkflowServiceErrorImpl("Document Type Invalid", "doctype.documenttypeservice.doctypename.required"));
        }
        if (ruleBaseValues.getToDateValue().before(ruleBaseValues.getFromDateValue())) {
            errors.add(new WorkflowServiceErrorImpl("From Date is later than to date", "routetemplate.ruleservice.daterange.fromafterto"));
        }
        if (ruleBaseValues.getDescription() == null || ruleBaseValues.getDescription().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Description is required", "routetemplate.ruleservice.description.required"));
        }
        if (ruleBaseValues.getRuleResponsibilities().isEmpty()) {
            errors.add(new WorkflowServiceErrorImpl("A responsibility is required", "routetemplate.ruleservice.responsibility.required"));
        } else {
            for (RuleResponsibilityBo element : ruleBaseValues.getRuleResponsibilities()) {
                RuleResponsibilityBo responsibility = element;
                if (responsibility.getRuleResponsibilityName() != null && "G".equals(responsibility.getRuleResponsibilityType())) {
                    if (this.getGroupService().getGroup(responsibility.getRuleResponsibilityName()) != null) continue;
                    errors.add(new WorkflowServiceErrorImpl("Workgroup is invalid", "routetemplate.ruleservice.workgroup.invalid"));
                    continue;
                }
                if (responsibility.getPrincipal() != null || responsibility.getRole() != null) continue;
                errors.add(new WorkflowServiceErrorImpl("User is invalid", "routetemplate.ruleservice.user.invalid"));
            }
        }
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("RuleBaseValues validation errors", errors);
        }
    }

    @Override
    public void validate2(RuleBaseValues ruleBaseValues, RuleDelegationBo ruleDelegation, List errors) {
        if (errors == null) {
            errors = new ArrayList();
        }
        if (this.getDocumentTypeService().findByName(ruleBaseValues.getDocTypeName()) == null) {
            errors.add(new WorkflowServiceErrorImpl("Document Type Invalid", "doctype.documenttypeservice.doctypename.required"));
            LOG.error((Object)"Document Type Invalid");
        }
        if (ruleBaseValues.getToDateValue() == null) {
            try {
                ruleBaseValues.setToDateValue(new Timestamp(RiceConstants.getDefaultDateFormat().parse("01/01/2100").getTime()));
            }
            catch (ParseException e) {
                LOG.error((Object)"Error date-parsing default date");
                throw new WorkflowServiceErrorException("Error parsing default date.", e);
            }
        }
        if (ruleBaseValues.getFromDateValue() == null) {
            ruleBaseValues.setFromDateValue(new Timestamp(System.currentTimeMillis()));
        }
        if (ruleBaseValues.getToDateValue().before(ruleBaseValues.getFromDateValue())) {
            errors.add(new WorkflowServiceErrorImpl("From Date is later than to date", "routetemplate.ruleservice.daterange.fromafterto"));
            LOG.error((Object)"From Date is later than to date");
        }
        if (ruleBaseValues.getDescription() == null || ruleBaseValues.getDescription().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Description is required", "routetemplate.ruleservice.description.required"));
            LOG.error((Object)"Description is missing");
        }
        for (RuleResponsibilityBo ruleResponsibilityBo : ruleBaseValues.getRuleResponsibilities()) {
            RuleResponsibilityBo responsibility = ruleResponsibilityBo;
            if (responsibility.getRuleResponsibilityName() != null && "G".equals(responsibility.getRuleResponsibilityType())) {
                if (this.getGroupService().getGroup(responsibility.getRuleResponsibilityName()) != null) continue;
                errors.add(new WorkflowServiceErrorImpl("Workgroup is invalid", "routetemplate.ruleservice.workgroup.invalid"));
                LOG.error((Object)"Workgroup is invalid");
                continue;
            }
            if (responsibility.getPrincipal() == null && responsibility.getRole() == null) {
                errors.add(new WorkflowServiceErrorImpl("User is invalid", "routetemplate.ruleservice.user.invalid"));
                LOG.error((Object)"User is invalid");
                continue;
            }
            if (!responsibility.isUsingRole() || responsibility.getApprovePolicy() != null && (responsibility.getApprovePolicy().equals(ActionRequestPolicy.ALL.getCode()) || responsibility.getApprovePolicy().equals(ActionRequestPolicy.FIRST.getCode()))) continue;
            errors.add(new WorkflowServiceErrorImpl("Approve Policy is Invalid", "routetemplate.ruleservice.approve.policy.invalid"));
            LOG.error((Object)"Approve Policy is Invalid");
        }
        if (ruleBaseValues.getRuleTemplate() != null) {
            for (PersistableBusinessObjectBase persistableBusinessObjectBase : ruleBaseValues.getRuleTemplate().getActiveRuleTemplateAttributes()) {
                RuleTemplateAttributeBo templateAttribute = (RuleTemplateAttributeBo)persistableBusinessObjectBase;
                if (!templateAttribute.isRuleValidationAttribute()) continue;
                RuleValidationAttribute attribute = templateAttribute.getRuleValidationAttribute();
                UserSession userSession = GlobalVariables.getUserSession();
                try {
                    RuleValidationContext validationContext = RuleValidationContext.Builder.create((RuleContract)RuleBaseValues.to(ruleBaseValues), (RuleDelegationContract)RuleDelegationBo.to(ruleDelegation), (String)userSession.getPrincipalId()).build();
                    ValidationResults results = attribute.validate(validationContext);
                    if (results == null || results.getErrors().isEmpty()) continue;
                    errors.add((WorkflowServiceErrorImpl)results);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException("Problem validation rule.", e);
                }
            }
        }
        if (ruleBaseValues.getRuleExpressionDef() != null) {
            // empty if block
        }
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("RuleBaseValues validation errors", errors);
        }
    }

    @Override
    public List<RuleBaseValues> findByDocumentId(String documentId) {
        return this.getRuleDAO().findByDocumentId(documentId);
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String groupId, String principalId, Boolean delegateRule, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        return this.getRuleDAO().search(docTypeName, ruleId, ruleTemplateId, ruleDescription, groupId, principalId, delegateRule, activeInd, extensionValues, workflowIdDirective);
    }

    @Override
    public List<RuleBaseValues> searchByTemplate(String docTypeName, String ruleTemplateName, String ruleDescription, String groupId, String principalId, Boolean workgroupMember, Boolean delegateRule, Boolean activeInd, Map extensionValues, Collection<String> actionRequestCodes) {
        if (StringUtils.isEmpty((String)docTypeName) && StringUtils.isEmpty((String)ruleTemplateName) && StringUtils.isEmpty((String)ruleDescription) && StringUtils.isEmpty((String)groupId) && StringUtils.isEmpty((String)principalId) && extensionValues.isEmpty() && actionRequestCodes.isEmpty()) {
            throw new IllegalArgumentException("At least one criterion must be sent");
        }
        RuleTemplateBo ruleTemplate = this.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName);
        String ruleTemplateId = null;
        if (ruleTemplate != null) {
            ruleTemplateId = ruleTemplate.getId();
        }
        if (extensionValues != null && !extensionValues.isEmpty() && ruleTemplateId == null) {
            throw new IllegalArgumentException("A Rule Template Name must be given if using Rule Extension values");
        }
        List<String> workgroupIds = new ArrayList<String>();
        if (principalId != null) {
            KEWServiceLocator.getIdentityHelperService().validatePrincipalId(principalId);
            if (workgroupMember == null || workgroupMember.booleanValue()) {
                workgroupIds = this.getGroupService().getGroupIdsByPrincipalId(principalId);
            }
        } else if (groupId != null) {
            Group group = KEWServiceLocator.getIdentityHelperService().getGroup(groupId);
            if (group == null) {
                throw new IllegalArgumentException("Group does not exist in for given group id: " + groupId);
            }
            workgroupIds.add(group.getId());
        }
        return this.getRuleDAO().search(docTypeName, ruleTemplateId, ruleDescription, workgroupIds, principalId, delegateRule, activeInd, extensionValues, actionRequestCodes);
    }

    @Override
    public void delete(String ruleBaseValuesId) {
        this.getRuleDAO().delete(ruleBaseValuesId);
    }

    @Override
    public RuleBaseValues findRuleBaseValuesById(String ruleBaseValuesId) {
        return this.getRuleDAO().findRuleBaseValuesById(ruleBaseValuesId);
    }

    @Override
    public RuleResponsibilityBo findRuleResponsibility(String responsibilityId) {
        return this.getRuleDAO().findRuleResponsibility(responsibilityId);
    }

    public List fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateName, String documentType) {
        String ruleTemplateId = this.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName).getId();
        return this.getRuleDAO().fetchAllCurrentRulesForTemplateDocCombination(ruleTemplateId, this.getDocGroupAndTypeList(documentType));
    }

    public List fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateName, String documentType, Timestamp effectiveDate) {
        String ruleTemplateId = this.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName).getId();
        PerformanceLogger performanceLogger = new PerformanceLogger();
        performanceLogger.log("Time to fetchRules by template " + ruleTemplateName + " not caching.");
        return this.getRuleDAO().fetchAllCurrentRulesForTemplateDocCombination(ruleTemplateId, this.getDocGroupAndTypeList(documentType), effectiveDate);
    }

    public List fetchAllRules(boolean currentRules) {
        return this.getRuleDAO().fetchAllRules(currentRules);
    }

    private List getDocGroupAndTypeList(String documentType) {
        ArrayList<String> docTypeList = new ArrayList<String>();
        DocumentTypeService docTypeService = (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
        for (DocumentType docType = docTypeService.findByName(documentType); docType != null; docType = docType.getParentDocType()) {
            docTypeList.add(docType.getName());
        }
        return docTypeList;
    }

    private Integer getNextVersionNumber(RuleBaseValues currentRule) {
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        candidates.add(currentRule.getVersionNbr());
        List<RuleBaseValues> pendingRules = this.ruleDAO.findByPreviousRuleId(currentRule.getId());
        for (RuleBaseValues pendingRule : pendingRules) {
            candidates.add(pendingRule.getVersionNbr());
        }
        Collections.sort(candidates);
        Integer maxVersionNumber = (Integer)candidates.get(candidates.size() - 1);
        if (maxVersionNumber == null) {
            return 0;
        }
        return maxVersionNumber + 1;
    }

    @Override
    public String isLockedForRouting(String currentRuleBaseValuesId) {
        List<RuleBaseValues> pendingRules = this.ruleDAO.findByPreviousRuleId(currentRuleBaseValuesId);
        boolean isDead = true;
        for (RuleBaseValues pendingRule : pendingRules) {
            if (pendingRule.getDocumentId() != null && StringUtils.isNotBlank((String)pendingRule.getDocumentId())) {
                DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(pendingRule.getDocumentId());
                boolean bl = isDead = routeHeader.isDisaproved() || routeHeader.isCanceled();
                if (!isDead) {
                    return pendingRule.getDocumentId();
                }
            }
            Iterator<RuleResponsibilityBo> iterator = pendingRule.getRuleResponsibilities().iterator();
            while (iterator.hasNext()) {
                RuleResponsibilityBo element;
                RuleResponsibilityBo responsibility = element = iterator.next();
                Iterator<RuleDelegationBo> iterator2 = responsibility.getDelegationRules().iterator();
                while (iterator2.hasNext()) {
                    RuleDelegationBo element2;
                    RuleDelegationBo delegation = element2 = iterator2.next();
                    List<RuleBaseValues> pendingDelegateRules = this.ruleDAO.findByPreviousRuleId(delegation.getDelegationRule().getId());
                    for (RuleBaseValues pendingDelegateRule : pendingDelegateRules) {
                        DocumentRouteHeaderValue routeHeader;
                        if (pendingDelegateRule.getDocumentId() == null || !StringUtils.isNotBlank((String)pendingDelegateRule.getDocumentId()) || (isDead = (routeHeader = this.getRouteHeaderService().getRouteHeader(pendingDelegateRule.getDocumentId())).isDisaproved() || routeHeader.isCanceled())) continue;
                        return pendingDelegateRule.getDocumentId();
                    }
                }
            }
        }
        return null;
    }

    public RuleBaseValues getParentRule(RuleBaseValues rule) {
        if (rule == null || rule.getId() == null) {
            throw new IllegalArgumentException("Rule must be non-null with non-null id: " + (Object)((Object)rule));
        }
        if (!Boolean.TRUE.equals(rule.getDelegateRule())) {
            return null;
        }
        return this.getRuleDAO().getParentRule(rule.getId());
    }

    public String getRuleDocumentTypeName(List rules) {
        if (rules.size() == 0) {
            throw new IllegalArgumentException("Cannot determine rule DocumentType for an empty list of rules.");
        }
        String ruleDocTypeName = null;
        RuleRoutingConfig config = RuleRoutingConfig.parse();
        RuleBaseValues firstRule = (RuleBaseValues)((Object)rules.get(0));
        if (Boolean.TRUE.equals(firstRule.getDelegateRule())) {
            ruleDocTypeName = config.getDocumentTypeName(firstRule);
        } else {
            String parentRulesDocTypeName = null;
            for (RuleBaseValues rule : rules) {
                if (Boolean.TRUE.equals(rule.getDelegateRule())) continue;
                String currentDocTypeName = config.getDocumentTypeName(rule);
                if (parentRulesDocTypeName == null) {
                    parentRulesDocTypeName = currentDocTypeName;
                    continue;
                }
                if (ObjectUtils.equals((Object)currentDocTypeName, (Object)parentRulesDocTypeName)) continue;
                throw new RuntimeException("There are multiple rules being routed and they have different document type definitions!  " + parentRulesDocTypeName + " and " + currentDocTypeName);
            }
            ruleDocTypeName = parentRulesDocTypeName;
        }
        if (ruleDocTypeName == null) {
            ruleDocTypeName = "RuleDocument";
        }
        return ruleDocTypeName;
    }

    public void setRuleDAO(RuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    public RuleDAO getRuleDAO() {
        return this.ruleDAO;
    }

    @Override
    public void deleteRuleResponsibilityById(String ruleResponsibilityId) {
        this.getRuleResponsibilityDAO().delete(ruleResponsibilityId);
    }

    @Override
    public RuleResponsibilityBo findByRuleResponsibilityId(String ruleResponsibilityId) {
        return this.getRuleResponsibilityDAO().findByRuleResponsibilityId(ruleResponsibilityId);
    }

    public List findRuleBaseValuesByResponsibilityReviewer(String reviewerName, String type) {
        return this.getRuleDAO().findRuleBaseValuesByResponsibilityReviewer(reviewerName, type);
    }

    public List findRuleBaseValuesByResponsibilityReviewerTemplateDoc(String ruleTemplateName, String documentType, String reviewerName, String type) {
        return this.getRuleDAO().findRuleBaseValuesByResponsibilityReviewerTemplateDoc(ruleTemplateName, documentType, reviewerName, type);
    }

    public RuleTemplateService getRuleTemplateService() {
        return (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
    }

    public DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    public GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    public ActionRequestService getActionRequestService() {
        return (ActionRequestService)KEWServiceLocator.getService("enActionRequestService");
    }

    private ResponsibilityIdService getResponsibilityIdService() {
        return (ResponsibilityIdService)KEWServiceLocator.getService("enResponsibilityIdService");
    }

    private RuleDelegationService getRuleDelegationService() {
        return (RuleDelegationService)KEWServiceLocator.getService("enRuleDelegationService");
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    public void loadXml(InputStream inputStream, String principalId) {
        RuleXmlParser parser = new RuleXmlParser();
        try {
            parser.parseRules(inputStream);
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading xml file", (Throwable)e);
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error loading xml file", new WorkflowServiceErrorImpl("Error loading xml file", XML_PARSE_ERROR));
            wsee.initCause(e);
            throw wsee;
        }
    }

    public Element export(ExportDataSet dataSet) {
        RuleXmlExporter exporter = new RuleXmlExporter(XmlConstants.RULE_NAMESPACE);
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    protected List<RuleBaseValues> loadRules(List<String> ruleIds) {
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (String ruleId : ruleIds) {
            RuleBaseValues rule = KEWServiceLocator.getRuleService().findRuleBaseValuesById(ruleId);
            rules.add(rule);
        }
        return rules;
    }

    protected boolean shouldChangeRuleInvolvement(String documentId, RuleBaseValues rule) {
        if (!rule.getCurrentInd().booleanValue()) {
            LOG.warn((Object)("Rule requested for rule involvement change by document " + documentId + " is no longer current.  Change will not be executed!  Rule id is: " + rule.getId()));
            return false;
        }
        String lockingDocumentId = KEWServiceLocator.getRuleService().isLockedForRouting(rule.getId());
        if (lockingDocumentId != null) {
            LOG.warn((Object)("Rule requested for rule involvement change by document " + documentId + " is locked by document " + lockingDocumentId + " and cannot be modified.  " + "Change will not be executed!  Rule id is: " + rule.getId()));
            return false;
        }
        return true;
    }

    protected RuleDelegationBo getRuleDelegationForDelegateRule(RuleBaseValues rule) {
        if (Boolean.TRUE.equals(rule.getDelegateRule())) {
            List<RuleDelegationBo> delegations = this.getRuleDelegationService().findByDelegateRuleId(rule.getId());
            for (RuleDelegationBo ruleDelegation : delegations) {
                RuleBaseValues parentRule = ruleDelegation.getRuleResponsibility().getRuleBaseValues();
                if (!Boolean.TRUE.equals(parentRule.getCurrentInd())) continue;
                return ruleDelegation;
            }
        }
        return null;
    }

    protected void hookUpDelegateRuleToParentRule(RuleBaseValues newParentRule, RuleBaseValues newDelegationRule, RuleDelegationBo existingRuleDelegation) {
        boolean foundDelegation = false;
        block0: for (RuleResponsibilityBo responsibility : newParentRule.getRuleResponsibilities()) {
            for (RuleDelegationBo ruleDelegation : responsibility.getDelegationRules()) {
                if (!ruleDelegation.getDelegationRule().getId().equals(existingRuleDelegation.getDelegationRule().getId())) continue;
                ruleDelegation.setDelegationRule(newDelegationRule);
                foundDelegation = true;
                break block0;
            }
        }
        if (!foundDelegation) {
            throw new WorkflowRuntimeException("Failed to locate the existing rule delegation with id: " + existingRuleDelegation.getDelegationRule().getId());
        }
    }

    protected RuleBaseValues createNewRuleVersion(RuleBaseValues existingRule, String documentId) throws Exception {
        RuleBaseValues rule = new RuleBaseValues();
        PropertyUtils.copyProperties((Object)((Object)rule), (Object)((Object)existingRule));
        rule.setPreviousVersion(existingRule);
        rule.setPreviousRuleId(existingRule.getId());
        rule.setId(null);
        rule.setActivationDate(null);
        rule.setDeactivationDate(null);
        rule.setVersionNumber(0L);
        rule.setDocumentId(documentId);
        rule.setRuleResponsibilities(new ArrayList<RuleResponsibilityBo>());
        for (RuleResponsibilityBo existingResponsibility : existingRule.getRuleResponsibilities()) {
            RuleResponsibilityBo responsibility = new RuleResponsibilityBo();
            PropertyUtils.copyProperties((Object)((Object)responsibility), (Object)((Object)existingResponsibility));
            responsibility.setRuleBaseValues(rule);
            responsibility.setRuleBaseValuesId(null);
            responsibility.setId(null);
            responsibility.setVersionNumber(0L);
            rule.getRuleResponsibilities().add(responsibility);
        }
        rule.setRuleExtensions(new ArrayList<RuleExtensionBo>());
        for (RuleExtensionBo existingExtension : existingRule.getRuleExtensions()) {
            RuleExtensionBo extension = new RuleExtensionBo();
            PropertyUtils.copyProperties((Object)extension, (Object)existingExtension);
            extension.setVersionNumber(new Long(0L));
            extension.setRuleBaseValues(rule);
            extension.setRuleBaseValuesId(null);
            extension.setRuleExtensionId(null);
            rule.getRuleExtensions().add(extension);
            extension.setExtensionValues(new ArrayList<RuleExtensionValue>());
            for (RuleExtensionValue existingExtensionValue : extension.getExtensionValues()) {
                RuleExtensionValue extensionValue = new RuleExtensionValue();
                PropertyUtils.copyProperties((Object)extensionValue, (Object)existingExtensionValue);
                extensionValue.setExtension(extension);
                extensionValue.setRuleExtensionId(null);
                extensionValue.setLockVerNbr(0);
                extensionValue.setRuleExtensionValueId(null);
                extension.getExtensionValues().add(extensionValue);
            }
        }
        return rule;
    }

    @Override
    public String getDuplicateRuleId(RuleBaseValues rule) {
        Rule baseRule = RuleBaseValues.to(rule);
        List responsibilities = baseRule.getRuleResponsibilities();
        List extensions = baseRule.getRuleExtensions();
        String docTypeName = baseRule.getDocTypeName();
        String ruleTemplateName = baseRule.getRuleTemplateName();
        List rules = KewApiServiceLocator.getRuleService().getRulesByTemplateNameAndDocumentTypeName(ruleTemplateName, docTypeName);
        for (Rule r : rules) {
            if (!ObjectUtils.equals((Object)rule.isActive(), (Object)r.isActive()) || !ObjectUtils.equals((Object)docTypeName, (Object)r.getDocTypeName()) || !ObjectUtils.equals((Object)ruleTemplateName, (Object)r.getRuleTemplateName()) || !CollectionUtils.collectionsEquivalent((Collection)responsibilities, (Collection)r.getRuleResponsibilities()) || !CollectionUtils.collectionsEquivalent((Collection)extensions, (Collection)r.getRuleExtensions()) || !ObjectUtils.equals((Object)baseRule.getRuleExpressionDef(), (Object)r.getRuleExpressionDef()) && (baseRule.getRuleExpressionDef() == null || r.getRuleExpressionDef() == null || !ObjectUtils.equals((Object)baseRule.getRuleExpressionDef().getType(), (Object)r.getRuleExpressionDef().getType()) || !ObjectUtils.equals((Object)baseRule.getRuleExpressionDef().getExpression(), (Object)r.getRuleExpressionDef().getExpression()))) continue;
            return r.getId();
        }
        return null;
    }

    private void generateRuleNameIfNeeded(RuleBaseValues rule) {
        if (StringUtils.isBlank((String)rule.getName())) {
            rule.setName(UUID.randomUUID().toString());
        }
    }

    private void assignResponsibilityIds(RuleBaseValues rule) {
        for (RuleResponsibilityBo responsibility : rule.getRuleResponsibilities()) {
            if (responsibility.getResponsibilityId() != null) continue;
            responsibility.setResponsibilityId(KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId());
        }
    }

    @Override
    public RuleBaseValues saveRule(RuleBaseValues rule, boolean isRetroactiveUpdatePermitted) {
        rule.setPreviousRuleId(rule.getId());
        rule.setPreviousVersion(null);
        rule.setId(null);
        this.makeCurrent(rule, isRetroactiveUpdatePermitted);
        return rule;
    }

    @Override
    public List<RuleBaseValues> saveRules(List<RuleBaseValues> rulesToSave, boolean isRetroactiveUpdatePermitted) {
        ArrayList<RuleBaseValues> savedRules = new ArrayList<RuleBaseValues>();
        for (RuleBaseValues rule : rulesToSave) {
            rule = this.saveRule(rule, isRetroactiveUpdatePermitted);
            savedRules.add(rule);
        }
        return savedRules;
    }

    @Override
    public RuleDelegationBo saveRuleDelegation(RuleDelegationBo ruleDelegation, boolean isRetroactiveUpdatePermitted) {
        RuleBaseValues rule = ruleDelegation.getDelegationRule();
        rule.setPreviousRuleId(rule.getId());
        rule.setPreviousVersion(null);
        rule.setId(null);
        ruleDelegation.setRuleDelegationId(null);
        this.makeCurrent(ruleDelegation, isRetroactiveUpdatePermitted);
        return ruleDelegation;
    }

    @Override
    public List<RuleDelegationBo> saveRuleDelegations(List<RuleDelegationBo> ruleDelegationsToSave, boolean isRetroactiveUpdatePermitted) {
        ArrayList<RuleDelegationBo> savedRuleDelegations = new ArrayList<RuleDelegationBo>();
        for (RuleDelegationBo ruleDelegation : ruleDelegationsToSave) {
            ruleDelegation = this.saveRuleDelegation(ruleDelegation, isRetroactiveUpdatePermitted);
            savedRuleDelegations.add(ruleDelegation);
        }
        return savedRuleDelegations;
    }

    @Override
    public String findResponsibilityIdForRule(String ruleName, String ruleResponsibilityName, String ruleResponsibilityType) {
        return this.getRuleDAO().findResponsibilityIdForRule(ruleName, ruleResponsibilityName, ruleResponsibilityType);
    }

    protected String getRuleByTemplateAndDocTypeCacheKey(String ruleTemplateName, String docTypeName) {
        return "'templateName=' + " + ruleTemplateName + " '|' + 'documentTypeName=' + " + docTypeName;
    }

    private static class RuleRoutingConfig {
        private List configs = new ArrayList();

        private RuleRoutingConfig() {
        }

        public static RuleRoutingConfig parse() {
            RuleRoutingConfig config = new RuleRoutingConfig();
            String constant = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "CUSTOM_DOCUMENT_TYPES");
            if (!StringUtils.isEmpty((String)constant)) {
                String[] ruleConfigs;
                for (String ruleConfig : ruleConfigs = constant.split(",")) {
                    String[] configElements = ruleConfig.split(":");
                    if (configElements.length != 4) {
                        throw new RuntimeException("Found incorrect number of config elements within a section of the custom rule document types config.  There should have been four ':' delimited sections!  " + ruleConfig);
                    }
                    config.configs.add(configElements);
                }
            }
            return config;
        }

        public String getDocumentTypeName(RuleBaseValues rule) {
            for (String[] configElements : this.configs) {
                String docTypeName = configElements[0];
                String ruleTemplateName = configElements[1];
                String type = configElements[2];
                String ruleDocTypeName = configElements[3];
                if (!rule.getDocTypeName().equals(docTypeName) || !rule.getRuleTemplateName().equals(ruleTemplateName)) continue;
                if (type.equals("M")) {
                    if (!Boolean.FALSE.equals(rule.getDelegateRule())) continue;
                    return ruleDocTypeName;
                }
                if (type.equals("D")) {
                    if (!Boolean.TRUE.equals(rule.getDelegateRule())) continue;
                    return ruleDocTypeName;
                }
                throw new RuntimeException("Bad rule type '" + type + "' in rule doc type routing config.");
            }
            return null;
        }
    }

    private static class RuleVersion {
        public RuleBaseValues rule;
        public RuleBaseValues parent;
        public RuleDelegationBo delegation;

        private RuleVersion() {
        }
    }

    public class RuleDelegationSorter
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            RuleBaseValues rule1 = (RuleBaseValues)((Object)arg0);
            RuleBaseValues rule2 = (RuleBaseValues)((Object)arg1);
            Integer rule1Value = new Integer(rule1.getDelegateRule() != false ? 0 : 1);
            Integer rule2Value = new Integer(rule2.getDelegateRule() != false ? 0 : 1);
            int value = rule1Value.compareTo(rule2Value);
            return value;
        }
    }
}

