/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.useroptions.dao.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.dao.UserOptionsDAO;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class UserOptionsDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements UserOptionsDAO {
    @Override
    public Long getNewOptionIdForActionList() {
        return (Long)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                return UserOptionsDAOOjbImpl.this.getPlatform().getNextValSQL("KREW_ACTN_LIST_OPTN_S", broker);
            }
        });
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }

    @Override
    public List<UserOptions> findByUserQualified(String principalId, String likeString) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("workflowId", (Object)principalId);
        criteria.addLike((Object)"optionId", (Object)likeString);
        return new ArrayList<UserOptions>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(UserOptions.class, criteria)));
    }

    @Override
    public void deleteByUserQualified(String principalId, String likeString) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("workflowId", (Object)principalId);
        criteria.addLike((Object)"optionId", (Object)likeString);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(UserOptions.class, criteria));
    }

    @Override
    public Collection<UserOptions> findByWorkflowUser(String principalId) {
        UserOptions userOptions = new UserOptions();
        userOptions.setWorkflowId(principalId);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria((Object)userOptions));
    }

    @Override
    public void save(UserOptions userOptions) {
        this.getPersistenceBrokerTemplate().store((Object)userOptions);
    }

    @Override
    public void save(Collection<UserOptions> userOptions) {
        if (userOptions != null) {
            for (UserOptions option : userOptions) {
                this.getPersistenceBrokerTemplate().store((Object)option);
            }
        }
    }

    @Override
    public void deleteUserOptions(UserOptions userOptions) {
        this.getPersistenceBrokerTemplate().delete((Object)userOptions);
    }

    @Override
    public UserOptions findByOptionId(String optionId, String principalId) {
        UserOptions userOptions = new UserOptions();
        userOptions.setOptionId(optionId);
        userOptions.setWorkflowId(principalId);
        return (UserOptions)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria((Object)userOptions));
    }

    @Override
    public Collection<UserOptions> findByOptionValue(String optionId, String optionValue) {
        UserOptions userOptions = new UserOptions();
        userOptions.setOptionId(optionId);
        userOptions.setOptionVal(optionValue);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria((Object)userOptions));
    }

    @Override
    public List<UserOptions> findEmailUserOptionsByType(String emailSetting) {
        Criteria optionIDCriteria = new Criteria();
        optionIDCriteria.addEqualTo("optionId", (Object)"EMAIL_NOTIFICATION");
        Criteria documentTypeNotificationCriteria = new Criteria();
        documentTypeNotificationCriteria.addLike((Object)"optionId", (Object)"%.DocumentTypeNotification");
        optionIDCriteria.addOrCriteria(documentTypeNotificationCriteria);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("optionVal", (Object)emailSetting);
        criteria.addAndCriteria(optionIDCriteria);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(UserOptions.class, criteria)), UserOptions.class));
    }
}

