/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.InquirySectionDefinition;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.service.impl.DataObjectMetaDataServiceImpl;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;

@Deprecated
public class BusinessObjectMetaDataServiceImpl
extends DataObjectMetaDataServiceImpl
implements BusinessObjectMetaDataService {
    private static final Logger LOG = Logger.getLogger(BusinessObjectMetaDataServiceImpl.class);
    private BusinessObjectDictionaryService businessObjectDictionaryService;

    public Collection<String> getCollectionNames(BusinessObject bo) {
        return this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(bo.getClass().getName()).getCollectionNames();
    }

    public Collection<String> getInquirableFieldNames(Class boClass, String sectionTitle) {
        return this.businessObjectDictionaryService.getInquiryFieldNames(boClass, sectionTitle);
    }

    public List<String> getLookupableFieldNames(Class boClass) {
        return this.businessObjectDictionaryService.getLookupFieldNames(boClass);
    }

    public String getLookupFieldDefaultValue(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldDefaultValue(businessObjectClass, attributeName);
    }

    public Class getLookupFieldDefaultValueFinderClass(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldDefaultValueFinderClass(businessObjectClass, attributeName);
    }

    public String getLookupFieldQuickfinderParameterString(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldQuickfinderParameterString(businessObjectClass, attributeName);
    }

    public Class<? extends ValueFinder> getLookupFieldQuickfinderParameterStringBuilderClass(Class businessObjectClass, String attributeName) {
        return this.businessObjectDictionaryService.getLookupFieldQuickfinderParameterStringBuilderClass(businessObjectClass, attributeName);
    }

    public boolean isAttributeInquirable(Class boClass, String attributeName, String sectionTitle) {
        List sections = this.businessObjectDictionaryService.getInquirySections(boClass);
        boolean isInquirable = true;
        for (InquirySectionDefinition def : sections) {
            for (FieldDefinition field : def.getInquiryFields()) {
                if (!field.getAttributeName().equalsIgnoreCase(attributeName)) continue;
                isInquirable = !field.isNoInquiry();
            }
        }
        if (isInquirable) {
            Object obj = null;
            if (boClass != null && BusinessObject.class.isAssignableFrom(boClass)) {
                obj = ObjectUtils.createNewObjectFromClass((Class)boClass);
            }
            if (obj != null) {
                BusinessObject bo = (BusinessObject)obj;
                Class clazz = this.getNestedBOClass(bo, attributeName);
                if (clazz != null && BusinessObject.class.isAssignableFrom(clazz)) {
                    return this.businessObjectDictionaryService.isInquirable(clazz);
                }
                return false;
            }
            return false;
        }
        return isInquirable;
    }

    public boolean isInquirable(Class boClass) {
        boolean inquirable = false;
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(boClass);
        if (moduleService != null && moduleService.isExternalizable(boClass)) {
            inquirable = moduleService.isExternalizableBusinessObjectInquirable(boClass);
        } else {
            Boolean isLookupable = this.businessObjectDictionaryService.isInquirable(boClass);
            if (isLookupable != null) {
                inquirable = isLookupable;
            }
        }
        return inquirable;
    }

    public boolean isAttributeLookupable(Class boClass, String attributeName) {
        Object obj = null;
        if (boClass != null && BusinessObject.class.isAssignableFrom(boClass)) {
            obj = ObjectUtils.createNewObjectFromClass((Class)boClass);
        }
        if (obj != null) {
            BusinessObject bo = (BusinessObject)obj;
            DataObjectRelationship relationship = this.getBusinessObjectRelationship(bo, attributeName);
            if (relationship != null && relationship.getRelatedClass() != null && BusinessObject.class.isAssignableFrom(relationship.getRelatedClass())) {
                return this.isLookupable(relationship.getRelatedClass());
            }
            return false;
        }
        return false;
    }

    public boolean isLookupable(Class boClass) {
        boolean lookupable = false;
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(boClass);
        if (moduleService != null && moduleService.isExternalizable(boClass)) {
            lookupable = moduleService.isExternalizableBusinessObjectLookupable(boClass);
        } else {
            Boolean isLookupable = this.businessObjectDictionaryService.isLookupable(boClass);
            if (isLookupable != null) {
                lookupable = isLookupable;
            }
        }
        return lookupable;
    }

    public DataObjectRelationship getBusinessObjectRelationship(BusinessObject bo, String attributeName) {
        return this.getBusinessObjectRelationship(bo, bo.getClass(), attributeName, "", true);
    }

    public DataObjectRelationship getBusinessObjectRelationship(RelationshipDefinition ddReference, BusinessObject bo, Class boClass, String attributeName, String attributePrefix, boolean keysOnly) {
        DataObjectRelationship relationship = null;
        if (ObjectUtils.isNestedAttribute((String)attributeName)) {
            if (ddReference != null) {
                relationship = new DataObjectRelationship(boClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
                for (PrimitiveAttributeDefinition def : ddReference.getPrimitiveAttributes()) {
                    if (StringUtils.isNotBlank((String)attributePrefix)) {
                        relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                        continue;
                    }
                    relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
                }
                if (!keysOnly) {
                    for (PrimitiveAttributeDefinition def : ddReference.getSupportAttributes()) {
                        if (StringUtils.isNotBlank((String)attributePrefix)) {
                            relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                            if (!def.isIdentifier()) continue;
                            relationship.setUserVisibleIdentifierKey(attributePrefix + "." + def.getSourceName());
                            continue;
                        }
                        relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
                        if (!def.isIdentifier()) continue;
                        relationship.setUserVisibleIdentifierKey(def.getSourceName());
                    }
                }
                return relationship;
            }
            String localPrefix = StringUtils.substringBefore((String)attributeName, (String)".");
            String localAttributeName = StringUtils.substringAfter((String)attributeName, (String)".");
            if (bo == null) {
                bo = (BusinessObject)ObjectUtils.createNewObjectFromClass((Class)boClass);
            }
            Class nestedClass = ObjectUtils.getPropertyType((Object)bo, (String)localPrefix, (PersistenceStructureService)this.getPersistenceStructureService());
            String fullPrefix = localPrefix;
            if (StringUtils.isNotBlank((String)attributePrefix)) {
                fullPrefix = attributePrefix + "." + localPrefix;
            }
            if (BusinessObject.class.isAssignableFrom(nestedClass)) {
                relationship = this.getBusinessObjectRelationship(null, nestedClass, localAttributeName, fullPrefix, keysOnly);
            }
            return relationship;
        }
        int maxSize = Integer.MAX_VALUE;
        if (PersistableBusinessObject.class.isAssignableFrom(boClass) && this.getPersistenceStructureService().isPersistable(boClass)) {
            Map rels = this.getPersistenceStructureService().getRelationshipMetadata(boClass, attributeName, attributePrefix);
            if (rels.size() > 0) {
                for (DataObjectRelationship rel : rels.values()) {
                    if (rel.getParentToChildReferences().size() >= maxSize || !this.isLookupable(rel.getRelatedClass())) continue;
                    maxSize = rel.getParentToChildReferences().size();
                    relationship = rel;
                }
            }
        } else {
            ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
            if (moduleService != null && moduleService.isExternalizable(boClass) && (relationship = this.getRelationshipMetadata(boClass, attributeName, attributePrefix)) != null) {
                return relationship;
            }
        }
        if (ddReference != null && this.isLookupable(ddReference.getTargetClass()) && bo != null && ddReference.getPrimitiveAttributes().size() < maxSize) {
            relationship = new DataObjectRelationship(boClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
            for (PrimitiveAttributeDefinition def : ddReference.getPrimitiveAttributes()) {
                relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
            }
            if (!keysOnly) {
                for (PrimitiveAttributeDefinition def : ddReference.getSupportAttributes()) {
                    relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
                }
            }
        }
        return relationship;
    }

    public RelationshipDefinition getBusinessObjectRelationshipDefinition(Class c, String attributeName) {
        return this.getDictionaryRelationship(c, attributeName);
    }

    public RelationshipDefinition getBusinessObjectRelationshipDefinition(BusinessObject bo, String attributeName) {
        return this.getBusinessObjectRelationshipDefinition(bo.getClass(), attributeName);
    }

    public DataObjectRelationship getBusinessObjectRelationship(BusinessObject bo, Class boClass, String attributeName, String attributePrefix, boolean keysOnly) {
        RelationshipDefinition ddReference = this.getBusinessObjectRelationshipDefinition(boClass, attributeName);
        return this.getBusinessObjectRelationship(ddReference, bo, boClass, attributeName, attributePrefix, keysOnly);
    }

    private Class getNestedBOClass(BusinessObject bo, String attributeName) {
        String[] nestedAttributes = StringUtils.split((String)attributeName, (String)".");
        String attributeRefName = "";
        Class clazz = null;
        if (nestedAttributes.length > 1) {
            String attributeStringSoFar = "";
            for (int i = 0; i < nestedAttributes.length - 1; ++i) {
                try {
                    if (i != 0) {
                        attributeStringSoFar = attributeStringSoFar + ".";
                    }
                    attributeStringSoFar = attributeStringSoFar + nestedAttributes[i];
                    clazz = ObjectUtils.easyGetPropertyType((Object)bo, (String)attributeStringSoFar);
                    continue;
                }
                catch (InvocationTargetException ite) {
                    LOG.info((Object)ite);
                    return null;
                }
                catch (NoSuchMethodException nsme) {
                    LOG.info((Object)nsme);
                    return null;
                }
                catch (IllegalAccessException iae) {
                    LOG.info((Object)iae);
                    return null;
                }
            }
        }
        return clazz;
    }

    public List<DataObjectRelationship> getBusinessObjectRelationships(BusinessObject bo) {
        if (bo == null) {
            return null;
        }
        return this.getBusinessObjectRelationships(bo.getClass());
    }

    public List<DataObjectRelationship> getBusinessObjectRelationships(Class<? extends BusinessObject> boClass) {
        DataDictionaryEntry ddEntry;
        if (boClass == null) {
            return null;
        }
        Map referenceClasses = null;
        if (PersistableBusinessObject.class.isAssignableFrom(boClass) && this.getPersistenceStructureService().isPersistable(boClass)) {
            referenceClasses = this.getPersistenceStructureService().listReferenceObjectFields(boClass);
        }
        List ddRelationships = (ddEntry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(boClass.getName())) == null ? new ArrayList() : ddEntry.getRelationships();
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        if (referenceClasses != null) {
            for (Map.Entry entry : referenceClasses.entrySet()) {
                if (!this.isLookupable((Class)entry.getValue())) continue;
                Map fkToPkRefs = this.getPersistenceStructureService().getForeignKeysForReference(boClass, (String)entry.getKey());
                DataObjectRelationship rel = new DataObjectRelationship(boClass, (String)entry.getKey(), (Class)entry.getValue());
                for (Map.Entry ref : fkToPkRefs.entrySet()) {
                    rel.getParentToChildReferences().put(ref.getKey(), ref.getValue());
                }
                relationships.add(rel);
            }
        }
        for (RelationshipDefinition relationshipDefinition : ddRelationships) {
            if (!this.isLookupable(relationshipDefinition.getTargetClass())) continue;
            DataObjectRelationship rel = new DataObjectRelationship(boClass, relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
            for (PrimitiveAttributeDefinition def : relationshipDefinition.getPrimitiveAttributes()) {
                rel.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
            }
            relationships.add(rel);
        }
        return relationships;
    }

    public Map<String, Class> getReferencesForForeignKey(BusinessObject bo, String attributeName) {
        List<DataObjectRelationship> dataObjectRelationships = this.getBusinessObjectRelationships(bo);
        HashMap<String, Class> referencesForForeignKey = new HashMap<String, Class>();
        for (DataObjectRelationship dataObjectRelationship : dataObjectRelationships) {
            if (dataObjectRelationship == null || dataObjectRelationship.getParentToChildReferences() == null || !dataObjectRelationship.getParentToChildReferences().containsKey(attributeName)) continue;
            referencesForForeignKey.put(dataObjectRelationship.getParentAttributeName(), dataObjectRelationship.getRelatedClass());
        }
        return referencesForForeignKey;
    }

    public String getForeignKeyFieldName(Class businessObjectClass, String attributeName, String targetName) {
        String fkName = "";
        RelationshipDefinition relationshipDefinition = this.getDictionaryRelationship(businessObjectClass, attributeName);
        if (relationshipDefinition != null) {
            List primitives = relationshipDefinition.getPrimitiveAttributes();
            for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitives) {
                if (!primitiveAttributeDefinition.getTargetName().equals(targetName)) continue;
                fkName = primitiveAttributeDefinition.getSourceName();
                break;
            }
        }
        if (StringUtils.isBlank((String)fkName) && PersistableBusinessObject.class.isAssignableFrom(businessObjectClass) && this.getPersistenceStructureService().isPersistable(businessObjectClass)) {
            fkName = this.getPersistenceStructureService().getForeignKeyFieldName(businessObjectClass, attributeName, targetName);
        }
        return fkName;
    }

    public boolean hasLocalLookup(Class<?> dataObjectClass) {
        Boolean isLookupable;
        boolean hasLookup = super.hasLocalLookup(dataObjectClass);
        if (!hasLookup && (isLookupable = this.getBusinessObjectDictionaryService().isLookupable(dataObjectClass)) != null) {
            hasLookup = isLookupable;
        }
        return hasLookup;
    }

    public boolean hasLocalInquiry(Class<?> dataObjectClass) {
        Boolean isInquirable;
        boolean hasInquiry = super.hasLocalInquiry(dataObjectClass);
        if (!hasInquiry && (isInquirable = this.getBusinessObjectDictionaryService().isInquirable(dataObjectClass)) != null) {
            hasInquiry = isInquirable;
        }
        return hasInquiry;
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }
}

