/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow.attribute;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.role.QualifierResolver;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public abstract class QualifierResolverBase
implements QualifierResolver {
    private static Logger LOG = Logger.getLogger(QualifierResolverBase.class);
    protected static final String KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME = "documentTypeName";
    protected static final String KIM_ATTRIBUTE_DOCUMENT_NUMBER = "documentNumber";
    protected static final String KIM_ATTRIBUTE_ROUTE_LEVEL_NAME = "routeNodeName";
    private static DocumentService documentService;

    protected Document getDocument(RouteContext context) {
        String documentID = this.getDocumentId(context);
        if (documentID != null) {
            try {
                return this.getDocumentService().getByDocumentHeaderIdSessionless(documentID);
            }
            catch (WorkflowException e) {
                LOG.error((Object)"Unable to retrieve document with system user.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected String getDocumentId(RouteContext context) {
        String documentID = context.getNodeInstance().getDocumentId();
        return documentID != null ? documentID.toString() : null;
    }

    public DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return documentService;
    }

    protected void decorateWithCommonQualifiers(List<Map<String, String>> qualifiers, RouteContext context, String customDocTypeName) {
        for (Map<String, String> qualifier : qualifiers) {
            this.addCommonQualifiersToMap(qualifier, context, customDocTypeName);
        }
    }

    protected void addCommonQualifiersToMap(Map<String, String> qualifier, RouteContext context, String customDocTypeName) {
        qualifier.put(KIM_ATTRIBUTE_DOCUMENT_NUMBER, context.getDocument().getDocumentId());
        if (!qualifier.containsKey(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME)) {
            if (StringUtils.isBlank((String)customDocTypeName)) {
                qualifier.put(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME, context.getDocument().getDocumentType().getName());
            } else {
                qualifier.put(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME, customDocTypeName);
            }
        }
        qualifier.put(KIM_ATTRIBUTE_ROUTE_LEVEL_NAME, context.getNodeInstance().getName());
    }
}

