/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.support.xstream;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.xml.xstream.XStreamSafeEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XStreamSafeEvaluatorTest {
    private static final String XML = "<document>  <beans>    <testBean1>      <bean1Name>Bean One #1</bean1Name>      <bean2>        <seeHowFarTheRabbitHoleGoes><value>20</value></seeHowFarTheRabbitHoleGoes>        <bean2Name>Bean Two #1</bean2Name>        <redPill reference=\"../../../redPill\"/>        <redPill reference=\"../seeHowFarTheRabbitHoleGoes\"/>        <redPill><value>30</value></redPill>      </bean2>    </testBean1>    <testBean1>      <bean1Name>Bean One #2</bean1Name>      <bean2 reference=\"../../testBean1/bean2\"/>    </testBean1>    <redPill><value>10</value></redPill>  </beans></document>";
    private static final String XML2 = "<document>  <test1 reference=\"../test2\"/>  <test2 reference=\"../test3\"/>  <test3>test3</test3></document>";
    private static final String XPATH_NO_REF = "//document/beans/testBean1/bean1Name";
    private static final String XPATH_THROUGH_REF = "//document/beans/testBean1/bean2/bean2Name";
    private static final String XPATH_RED_PILL = "//document/beans/testBean1/bean2/redPill/value";
    private static final String XPATH2_TEST1 = "/document/test1";
    private static final String XPATH2_TEST2 = "//test2";
    private static final String XPATH2_TEST3 = "//document/test3";
    private static final String XPATH_GET_FOR_RELATIVE = "/document/beans/testBean1/bean2";
    private static final String XPATH_VALUE_20_RELATIVE = "./seeHowFarTheRabbitHoleGoes/value";
    private static final String XPATH_VALUE_10_20_30_RELATIVE = "./redPill/value";
    private Document document;
    private XStreamSafeEvaluator eval = new XStreamSafeEvaluator();
    private XPath xpath;

    @Before
    public void setUp() throws Exception {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(XML.getBytes()));
        this.xpath = XPathHelper.newXPath((Node)this.document);
    }

    @Test
    public void testEvaluation() throws Exception {
        NodeList nodeList = (NodeList)this.xpath.evaluate(XPATH_NO_REF, this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Should find 2 nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(XPATH_THROUGH_REF, this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Should find 1 nodes.", (long)1L, (long)nodeList.getLength());
        nodeList = this.eval.evaluate(XPATH_NO_REF, (Node)this.document);
        Assert.assertEquals((String)"Should find 2 nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = this.eval.evaluate(XPATH_THROUGH_REF, (Node)this.document);
        Assert.assertEquals((String)"Should find 2 nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(this.wrapXStreamSafe(XPATH_NO_REF), this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Should find 2 nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(this.wrapXStreamSafe(XPATH_THROUGH_REF), this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Should find 2 nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(XPATH_RED_PILL, this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Without XStream safe evaulation, should only find 1 node.", (long)1L, (long)nodeList.getLength());
        System.out.println("\n\n\n\n");
        nodeList = (NodeList)this.xpath.evaluate(this.wrapXStreamSafe(XPATH_RED_PILL), this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"Should have 6 nodes.", (long)6L, (long)nodeList.getLength());
        String totalValue = this.xpath.evaluate("sum(" + this.wrapXStreamSafe(XPATH_RED_PILL) + ")", this.document);
        Assert.assertEquals((String)"Sum should be 120.", (Object)"120", (Object)totalValue);
    }

    @Test
    public void testTerminalReferences() throws Exception {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(XML2.getBytes()));
        this.xpath = XPathHelper.newXPath((Node)this.document);
        NodeList nodeList = (NodeList)this.xpath.evaluate(XPATH2_TEST1, this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"There should be one node.", (long)1L, (long)nodeList.getLength());
        Assert.assertEquals((String)"The first node should be named 'test1'", (Object)"test1", (Object)nodeList.item(0).getNodeName());
        Assert.assertEquals((String)"The node should have no children.", (long)0L, (long)nodeList.item(0).getChildNodes().getLength());
        Assert.assertNotNull((String)"The node should have a reference attribute.", (Object)nodeList.item(0).getAttributes().getNamedItem("reference"));
        String test3Value = this.xpath.evaluate(XPATH2_TEST3, this.document);
        Assert.assertEquals((Object)"test3", (Object)test3Value);
        String test1Value = this.xpath.evaluate(this.wrapXStreamSafe(XPATH2_TEST1), this.document);
        Assert.assertEquals((Object)"test3", (Object)test1Value);
        String test2Value = this.xpath.evaluate(this.wrapXStreamSafe(XPATH2_TEST2), this.document);
        Assert.assertEquals((Object)"test3", (Object)test2Value);
        test3Value = this.xpath.evaluate(this.wrapXStreamSafe(XPATH2_TEST3), this.document);
        Assert.assertEquals((Object)"test3", (Object)test3Value);
    }

    @Test
    public void testContextRelativeExpressions() throws Exception {
        NodeList nodeList = (NodeList)this.xpath.evaluate(XPATH_GET_FOR_RELATIVE, this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"There should be two nodes.", (long)2L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(this.wrapXStreamSafe(XPATH_GET_FOR_RELATIVE), this.document, XPathConstants.NODESET);
        Assert.assertEquals((String)"There should be two nodes.", (long)2L, (long)nodeList.getLength());
        Node node = nodeList.item(0);
        this.xpath = XPathHelper.newXPath((Node)node);
        String value = this.xpath.evaluate(XPATH_VALUE_20_RELATIVE, node);
        Assert.assertEquals((Object)"20", (Object)value);
        value = this.xpath.evaluate(this.wrapXStreamSafe(XPATH_VALUE_20_RELATIVE), node);
        Assert.assertEquals((Object)"20", (Object)value);
        nodeList = (NodeList)this.xpath.evaluate(XPATH_VALUE_10_20_30_RELATIVE, node, XPathConstants.NODESET);
        Assert.assertEquals((String)"NodeList should have 1 elements.", (long)1L, (long)nodeList.getLength());
        nodeList = (NodeList)this.xpath.evaluate(this.wrapXStreamSafe(XPATH_VALUE_10_20_30_RELATIVE), node, XPathConstants.NODESET);
        Assert.assertEquals((String)"NodeList should have 3 elements.", (long)3L, (long)nodeList.getLength());
    }

    private String wrapXStreamSafe(String xPathExpression) {
        return "wf:xstreamsafe('" + xPathExpression + "')";
    }
}

