/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.StandardWorkflowEngine;
import org.kuali.rice.kew.engine.WorkflowEngine;
import org.kuali.rice.kew.engine.WorkflowEngineFactory;
import org.kuali.rice.kew.engine.WorkflowEngineFactoryImpl;
import org.kuali.rice.kew.engine.simulation.SimulationEngine;

public class WorkflowEngineFactoryImplTest {
    private WorkflowEngineFactory factory;

    @Before
    public void setup() {
        this.factory = new WorkflowEngineFactoryImpl();
    }

    @Test
    public void standardEngineCreate() {
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD);
        WorkflowEngine workflowEngine = this.factory.newEngine(config);
        Assert.assertNotNull((Object)workflowEngine);
        Assert.assertFalse((boolean)(workflowEngine instanceof BlanketApproveEngine));
        Assert.assertFalse((boolean)(workflowEngine instanceof SimulationEngine));
        Assert.assertTrue((boolean)(workflowEngine instanceof StandardWorkflowEngine));
    }

    @Test
    public void blanketApproveEngineCreate() {
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.BLANKET_APPROVAL);
        WorkflowEngine workflowEngine = this.factory.newEngine(config);
        Assert.assertNotNull((Object)workflowEngine);
        Assert.assertTrue((boolean)(workflowEngine instanceof BlanketApproveEngine));
        Assert.assertFalse((boolean)(workflowEngine instanceof SimulationEngine));
    }

    @Test
    public void simulationEngineCreate() {
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.SIMULATION);
        WorkflowEngine workflowEngine = this.factory.newEngine(config);
        Assert.assertNotNull((Object)workflowEngine);
        Assert.assertFalse((boolean)(workflowEngine instanceof BlanketApproveEngine));
        Assert.assertTrue((boolean)(workflowEngine instanceof SimulationEngine));
    }

    @Test
    public void standardEngineRunPostProcessLogic() {
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD, true);
        WorkflowEngine workflowEngine = this.factory.newEngine(config);
        Assert.assertTrue((boolean)((StandardWorkflowEngine)workflowEngine).isRunPostProcessorLogic());
    }

    @Test
    public void standardEngineDoNotRunPostProcessLogic() {
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD, false);
        WorkflowEngine workflowEngine = this.factory.newEngine(config);
        Assert.assertFalse((boolean)((StandardWorkflowEngine)workflowEngine).isRunPostProcessorLogic());
    }
}

