/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.kuali.rice.kew.rule.GenericAttributeContent;

public class GenericAttributeContentTest {
    private static final String ATTRIB1_CONTENT = "    <boringAttribute>      <field>        <name>color</name>        <value>green</value>      </field>      <field>        <name>shape</name>        <value>circle</value>      </field>    </boringAttribute>";
    private static final String ATTRIB2_CONTENT = "    <coolAttribute>      <field>        <name>car</name>        <value>KIT</value>      </field>      <field>        <name>driver</name>        <value>hasselhof</value>      </field>    </coolAttribute>";
    private static final String TEST_CONTENT = "<documentContent>  <attributeContent>    <boringAttribute>      <field>        <name>color</name>        <value>green</value>      </field>      <field>        <name>shape</name>        <value>circle</value>      </field>    </boringAttribute>    <coolAttribute>      <field>        <name>car</name>        <value>KIT</value>      </field>      <field>        <name>driver</name>        <value>hasselhof</value>      </field>    </coolAttribute>  </attributeContent></documentContent>";

    @Test
    public void testGenerateContent() throws Exception {
        StandardDocumentContent dc = new StandardDocumentContent(TEST_CONTENT);
        GenericAttributeContent gac = new GenericAttributeContent("boringAttribute");
        List attrs = gac.parseContent(dc.getAttributeContent());
        Assert.assertEquals((long)1L, (long)attrs.size());
        Map properties = (Map)attrs.get(0);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals((Object)"green", properties.get("color"));
        Assert.assertEquals((Object)"circle", properties.get("shape"));
        String content = gac.generateContent(properties);
        Assert.assertEquals((Object)content.replaceAll("\\s+", ""), (Object)ATTRIB1_CONTENT.replaceAll("\\s+", ""));
        gac = new GenericAttributeContent("coolAttribute");
        attrs = gac.parseContent(dc.getAttributeContent());
        Assert.assertEquals((long)1L, (long)attrs.size());
        properties = (Map)attrs.get(0);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals((Object)"hasselhof", properties.get("driver"));
        Assert.assertEquals((Object)"KIT", properties.get("car"));
        content = gac.generateContent(properties);
        Assert.assertEquals((Object)content.replaceAll("\\s+", ""), (Object)ATTRIB2_CONTENT.replaceAll("\\s+", ""));
    }
}

